/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.lifecycle.AppUninstaller;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.db.DBScript;
import com.actionsoft.bpms.bo.design.dao.BODaoFactory;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AppContainerException;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;

public class ApplicationUninstallWeb
extends AMCWeb {
    public ApplicationUninstallWeb(UserContext me) {
        super(me);
    }

    public String getApplicationUninstallPage() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", super.getContext().getSessionId());
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appuninstall.htm", macroLibraries);
    }

    public static String getToBeUnInstalledHtml(UserContext uc) {
        StringBuilder html = new StringBuilder();
        List unInstallApps = AppsAPIManager.getInstance().getUninstalledApps();
        for (AppContext appContext : unInstallApps) {
            AppContext installApp = AMCUtil.getAppFromInstall(appContext);
            String mes = "";
            String id = appContext.getId().replaceAll("\\.", "_");
            String img64 = AppsAPIManager.getInstance().getIcon64URL(appContext.getId(), uc);
            String appInfo = ApplicationUninstallWeb.getDelAppInfo(appContext.getId());
            String recovery = "<input type='button' onclick='Uninstall.recoveryApp(\"" + appContext.getId() + "\",\"" + AMCUtil.getAppNewName(appContext.getName(), 22) + "\",\"" + img64 + "\",\"" + id + "\");return false;' class='awsui-btn awsui-btn-sm awsui-btn-blue' value='\u8fd8\u539f'/>";
            String input = "<input id='versionType_" + id + "' type='hidden'  value='-1'>";
            if (installApp != null) {
                if (installApp.getVersion() > appContext.getVersion()) {
                    mes = "<font color='red'>(\u4f4e\u4e8e\u5df2\u5b89\u88c5\u7684\u7248\u672c)</font>&nbsp;";
                    input = "<input id='versionType_" + id + "' type='hidden'  value='1'>";
                } else if (installApp.getVersion() == appContext.getVersion() && installApp.getBuildNo() > appContext.getBuildNo()) {
                    mes = "<font color='red'>(\u4f4e\u4e8e\u5df2\u5b89\u88c5\u7684\u7248\u672c)</font>&nbsp;";
                    input = "<input id='versionType_" + id + "' type='hidden' value='1'>";
                }
            }
            String img = AMCUtil.getListAppIcon(appContext.getId(), true);
            html.append("<tr>");
            html.append("<td style='width: 60%;' >" + img + "<span title='" + appContext.getName() + "'>" + AMCUtil.getAppNewName(appContext.getName(), 22) + "</span>");
            html.append("<br>");
            html.append("<span style='font-size:12px;'>" + appContext.getId() + "</span></td>");
            html.append("<td style='width:10%;white-space:normal;'>" + appContext.getVersion() + "." + appContext.getBuildNo() + mes + "</td>");
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String time = "";
            if (appContext.getInstallDate() != null) {
                time = sf.format(appContext.getInstallDate());
            }
            html.append("<td style='width:10%;'>" + time + "</td>");
            html.append("<td style='width:20%;' nowrap='nowrap'>" + recovery + "<input type='button' onclick='Uninstall.removeApp(\"" + appContext.getId() + "\",\"" + appContext.getName() + "\",\"" + img64 + "\")' class='awsui-btn awsui-btn-sm' value='\u5f7b\u5e95\u5220\u9664'/></td>");
            html.append("</tr>");
            html.append(input);
        }
        return html.toString();
    }

    public static String getDelAppInfo(String appId) {
        Map models;
        AppContext delApp = AppsAPIManager.getInstance().getAppContext(appId);
        StringBuilder info = new StringBuilder();
        List list = DBScript.getInstance().getUninstallStatement(delApp);
        StringBuilder boInfos = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            String boInfo = (String)list.get(i);
            boInfos.append("<font color=red><b>");
            if (i == 0) {
                boInfos.append(boInfo);
            } else {
                boInfos.append("<br>" + boInfo);
            }
            boInfos.append("</b></font>");
            ++i;
        }
        if (!boInfos.toString().equals("")) {
            info.append("<b>\u5c06\u4f1a\u6267\u884c\u5982\u4e0b\u4e0d\u53ef\u9006\u64cd\u4f5c:</b><br>");
            info.append((CharSequence)boInfos);
        }
        if (!UtilString.isEmpty(models = BODaoFactory.createBO().getInstanceByApp(delApp))) {
            if (info.length() != 0) {
                info.append("<br>");
            }
            info.append("<b>\u5c06\u5220\u9664\u5982\u4e0bBO\u4e1a\u52a1\u6a21\u578b\u7684\u7269\u7406\u8868:</b><br>");
            ArrayList tmp = new ArrayList(models.values());
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < tmp.size()) {
                BOModel model = (BOModel)tmp.get(i2);
                String boInfo = String.valueOf(model.getName()) + "[" + model.getTitle() + "]";
                sb.append("<font color=red><b>");
                if (i2 == 0) {
                    sb.append(boInfo);
                } else {
                    sb.append("<br>" + boInfo);
                }
                sb.append("</b></font>");
                ++i2;
            }
            info.append((CharSequence)sb);
        }
        if (SDK.getAppAPI().isActive("com.actionsoft.apps.dict")) {
            JSONArray dictList;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appId", appId);
            ResponseObject ro = SDK.getAppAPI().callASLP(SDK.getAppAPI().getAppContext("_bpm.platform"), "aslp://com.actionsoft.apps.dict/queryKVDict", params);
            if (ro.isOk() && ro.toJsonObject().containsKey((Object)"data") && ro.toJsonObject().getJSONObject("data").containsKey((Object)"list") && !(dictList = ro.toJsonObject().getJSONObject("data").getJSONArray("list")).isEmpty()) {
                info.append("<br/><br/><b>\u5c06\u5220\u9664\u5982\u4e0b\u57fa\u7840\u5b57\u5178\u7684\u6570\u636e:</b><br>");
                for (Map dict : dictList) {
                    if (!dict.get("appId").equals(appId)) continue;
                    info.append("<font color=red><b>" + dict.get("dictKey") + "</b></font><br/>");
                }
            }
        }
        return info.toString();
    }

    public String recoveryApp(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        JSONObject json = new JSONObject();
        if (app != null) {
            try {
                AppUninstaller.recovery((AppContext)app);
                json.put("status", (Object)"ok");
                ro.ok();
            }
            catch (AppContainerException e) {
                json.put("status", (Object)"fail");
                ro.err();
                ro.msg(e.getMessage());
                e.printStackTrace();
            }
        } else {
            json.put("status", (Object)"fail");
            json.put("mes", (Object)"\u8be5App\u4e0d\u5b58\u5728");
        }
        ro.setData(json);
        return ro.toString();
    }

    public String remvoeApp(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        JSONObject json = new JSONObject();
        if (app != null) {
            try {
                AppUninstaller.physicalDelete((AppContext)app);
                json.put("status", (Object)"ok");
                ro.ok();
            }
            catch (AppContainerException e) {
                json.put("status", (Object)"fail");
                json.put("mes", (Object)e.getMessage());
                ro.err();
                ro.msg(e.getMessage());
                e.printStackTrace();
            }
        } else {
            json.put("status", (Object)"fail");
            json.put("mes", (Object)"\u8be5App\u4e0d\u5b58\u5728");
            ro.warn();
        }
        ro.setData(json);
        return ro.toString();
    }
}

