/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.lifecycle.AppInstaller;
import com.actionsoft.apps.lifecycle.AppUpgrader;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextDepend;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationUpgradeWeb
extends AMCWeb {
    public ApplicationUpgradeWeb(UserContext me) {
        super(me);
    }

    public String getApplicationUpgradePage() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        JSONArray appJsons = new JSONArray();
        List apps = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext app : apps) {
            JSONObject json = new JSONObject();
            json.put("appId", (Object)app.getId());
            json.put("version", (Object)app.getVersion());
            json.put("buildNo", (Object)app.getBuildNo());
            appJsons.add((Object)json);
        }
        String upgradeAll = "<button class='awsui-btn awsui-btn-green' onclick='AppUpgrade.upgradeAll(true);return false;'>\u4e00\u952e\u5347\u7ea7\u5168\u90e8</button>";
        if (!GradeSecurityUtil.isSuperMaster(this.getContext().getUID())) {
            upgradeAll = "";
        }
        String upgradeFormAppStore = "";
        if (!HighSecurity.isON()) {
            upgradeFormAppStore = AMCUtil.getVisitStore("<button class='awsui-btn awsui-btn-blue' onclick='AppUpgrade.checkUpdate();return false;'>\u4ece" + AMCUtil.getAppStoreName() + "\u68c0\u67e5\u5347\u7ea7</button>");
        }
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("upgradeFormAppStore", upgradeFormAppStore);
        macroLibraries.put("appsJson", appJsons);
        macroLibraries.put("upgradeAll", upgradeAll);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appupgrade.htm", macroLibraries);
    }

    public static String getToBeUpgradeHtml(UserContext me) {
        StringBuilder html = new StringBuilder();
        String doInstallAppPath = AppInstaller.getUploadPath();
        File f = new File(doInstallAppPath);
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".app");
            }
        });
        files = AMCUtil.getFileListOrderByLastModified(files);
        int m = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File zipFile = fileArray[n2];
            if (!zipFile.isDirectory()) {
                String appId = "";
                JSONObject appMap = null;
                File ff = new File(zipFile.getPath());
                String fileName = ff.getName();
                boolean isApp = true;
                if (fileName.endsWith(".app")) {
                    appId = fileName.substring(0, fileName.lastIndexOf(".app"));
                } else {
                    appId = fileName;
                    isApp = false;
                }
                if (!fileName.endsWith(".app")) {
                    html.append(ApplicationUpgradeWeb.getNoManifestHtml(appId, ""));
                    ++m;
                } else if (GradeSecurityUtil.isSuperMaster(me.getUID()) || AMCAPIManager.isDevelopApp(appId, me.getUID()) || AMCAPIManager.isManagementApp(appId, me.getUID())) {
                    String img = "";
                    String appRId = appId.replaceAll("\\.", "_");
                    try {
                        appMap = AMCUtil.readZipFile(zipFile.getPath());
                        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
                        boolean isUpgrade = AppUpgrader.isUpgrade((String)appId, (double)appMap.getDoubleValue("version"), (int)appMap.getIntValue("buildNo"));
                        boolean isEnvErr = false;
                        String platformEnv = appMap.getString("env");
                        String msg = "";
                        if (!AppContextDepend.isDependEnvVersion((String)platformEnv)) {
                            msg = "\u5f53\u524d\u5e94\u7528\u4f9d\u8d56\u5e73\u53f0\u7248\u672c[" + platformEnv + "]\uff0c\u9700\u5148\u5347\u7ea7\u5e73\u53f0";
                            isUpgrade = false;
                            isEnvErr = true;
                        }
                        String red = "";
                        if (!isUpgrade) {
                            red = "red";
                        }
                        html.append("<tr>");
                        html.append("<td style='width: 43%' style='white-space:normal;' name='titleTd' >");
                        html.append(String.valueOf(img) + "<span style='color:" + red + "' title='" + UtilJson.optString(appMap, "name") + "'  >" + AMCUtil.getAppNewName(UtilJson.optString(appMap, "name")) + "</span><br><span style='color:" + red + ";font-size: 12px;'>" + UtilJson.optString(appMap, "appId") + "</span>");
                        html.append("</td>");
                        html.append("<td style='width: 6%'>" + UtilJson.optString(appMap, "version") + "." + appMap.getIntValue("buildNo") + "</td>");
                        html.append("<td style='width: 10%'>" + UtilJson.optString(appMap, "releaseDate") + "</td>");
                        String type = "&nbsp;\u4ea7\u54c1";
                        try {
                            appMap.getString("productId");
                        }
                        catch (Exception e) {
                            type = "&nbsp;\u79c1\u6709";
                        }
                        html.append("<td style='width: 7%'>" + type + "</td>");
                        if (isUpgrade) {
                            html.append("<td style='width: 10%' index='" + m + "' name='state' id='" + appRId + "_state'>&nbsp;\u5c31\u7eea</td>");
                        } else if (isEnvErr) {
                            html.append("<td style='width: 10%' name='state' title='" + msg + "'><font color='red'><b>&nbsp;\u7248\u672c\u4f9d\u8d56\u5f02\u5e38</b></font></td>");
                        } else {
                            html.append("<td style='width: 10%' name='state'><font color='red'><b>&nbsp;\u672c\u5730\u5df2\u6700\u65b0(" + app.getVersion() + "." + app.getBuildNo() + ")</b></font></td>");
                        }
                        html.append("<td style='width:24%;' name='installTd'>");
                        if (isUpgrade) {
                            html.append("<div style='float:left;height:30px;margin-top:10px; width:65px;' id='buttons_" + appRId + "'>");
                            html.append("<input type='button'  id='i_" + appRId + "' appId='" + appId + "' class='awsui-btn awsui-btn-sm awsui-btn-blue' name='upgradeBtn' onclick='AppUpgrade.upgrade(\"" + appId + "\",\"" + appRId + "\",false," + isApp + ")' value='\u5347\u7ea7'/>");
                            html.append("</div>");
                            html.append("<div style='float:left;margin-top:10px;'>");
                            html.append("<input type='button' id='g_" + appRId + "' class='awsui-btn awsui-btn-sm awsui-btn-green' onclick='AppUpgrade.giveup(\"" + appId + "\",\"" + app.getName() + "\",\"" + AppsAPIManager.getInstance().getIcon64URL(appId, me) + "\")'  value='\u653e\u5f03'/>");
                            html.append("</div>");
                            html.append("<div style='float:right;height:28px;' style='display:none;border-left: 1px solid #999999 ;margin: 1px;height: 36px;'>");
                            html.append("<div id='log_" + appRId + "'  style='display:none;border-left: 1px solid #999999 ;margin: 1px;height: 36px;'>");
                            html.append("<img src='../apps/_bpm.platform/img/amc/up32.png'  id='s_" + appRId + "' style='cursor:pointer;width:24px;height:24px;margin:6px 5px 6px 7px;'  onclick='AppUpgrade.showLog(\"" + appRId + "\");return false;'   title='\u663e\u793a\u5347\u7ea7\u65e5\u5fd7'/>");
                            html.append("</div>");
                            html.append("</div>");
                        } else {
                            html.append("<div style='float:left;'><input type='button'   id='g_" + appId.replaceAll("\\.", "_") + "' class='awsui-btn awsui-btn-sm' onclick='AppUpgrade.giveup(\"" + appId + "\",\"" + appId.replaceAll("\\.", "_") + "\")'  value='\u653e\u5f03'/></div>");
                        }
                        html.append("</td>");
                        html.append("</tr>");
                        html.append("<tr>");
                        html.append("<td colspan='6' style='border:0px;'>");
                        html.append("<div id='expInfo_" + appRId + "' style=\" display:none;border-width: 0 1px 1px 1px;border-style: solid;border-bottom-left-radius: 5px;border-bottom-right-radius: 5px;   left: 20px; height:210px; overflow:auto; font-family:'Courier New'; font-size:12px; background-color:#000; background-image:none; line-height:normal;white-space:nowrap\">");
                        html.append("<span style=\"color:#0F0;\" id='infomes_" + appRId + "'>");
                        html.append("</span>");
                        html.append("</div>");
                        html.append("</td>");
                        html.append("</tr>");
                    }
                    catch (Exception e) {
                        html.append(ApplicationUpgradeWeb.getNoManifestHtml(appId, e.getMessage()));
                        ++m;
                    }
                    ++m;
                }
            }
            ++n2;
        }
        return html.toString();
    }

    public static String getNoManifestHtml(String appId, String mes) {
        StringBuilder noManifestHtml = new StringBuilder();
        String str = "\u4e0d\u88ab\u8bc6\u522b\u7684\u6587\u4ef6\u683c\u5f0f";
        if (!"".equals(mes)) {
            str = mes;
        }
        noManifestHtml.append("<tr>");
        noManifestHtml.append("<td style='width: 43%;white-space:normal;' name='titleTd' ><span>" + str + "</span><br><span style='font-size: 12px;'>" + appId + "</span></td>");
        noManifestHtml.append("<td style='width: 6%' >N/A</td>");
        noManifestHtml.append("<td style='width: 10%' >N/A</td>");
        noManifestHtml.append("<td style='width: 7%' >N/A</td></td>");
        noManifestHtml.append("<td style='width: 10%'  name='state'>\u6587\u4ef6\u9519\u8bef</td>");
        noManifestHtml.append("<td style='width:24%;' name='installTd'><div style='float:left;padding-left:65px;'><input type='button'   id='g_" + appId.replaceAll("\\.", "_") + "' class='awsui-btn awsui-btn-sm' onclick='AppUpgrade.giveup(\"" + appId + "\",\"" + appId.replaceAll("\\.", "_") + "\")'  value='\u653e\u5f03'/></div></td>");
        noManifestHtml.append("</tr>");
        return noManifestHtml.toString();
    }

    public String getCompletionrateInfo(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        StringBuilder log = new StringBuilder();
        JSONObject info = new JSONObject();
        int percent = 0;
        if (AppUpgrader.percentMap.get(appId) != null) {
            percent = (Integer)AppUpgrader.percentMap.get(appId);
        }
        List logs = AppsLogger.getLogs((String)appId);
        try {
            for (AppLogMsg appLogBean : logs) {
                String msg = appLogBean.getMsg();
                if (msg == null) continue;
                log.append(this.getLogInfo(appLogBean));
            }
        }
        catch (Exception appLogBean) {
            // empty catch block
        }
        String newLog = log.toString();
        if (newLog.equals("")) {
            newLog = "\u6570\u636e\u52a0\u8f7d\u4e2d...";
        }
        info.put("log", (Object)newLog);
        info.put("percent", (Object)percent);
        if (AppUpgrader.percentMap.get(appId) != null && (percent = ((Integer)AppUpgrader.percentMap.get(appId)).intValue()) == 100) {
            AppUpgrader.percentMap.put(appId, 0);
        }
        ro.setData(info);
        return ro.toDataString();
    }

    private String getLogInfo(AppLogMsg appLogBean) {
        SimpleDateFormat smp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder log = new StringBuilder();
        if (appLogBean.getLevel().equals("err")) {
            log.append("<font style='color:red'>\u9519\u8bef:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "</font><br>");
        }
        if (appLogBean.getLevel().equals("warn")) {
            log.append("<font style='color:yellow'>\u8b66\u544a:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "</font><br>");
        } else {
            log.append("\u4fe1\u606f:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "<br>");
        }
        return log.toString();
    }

    public String upgradeApp(String mappId) {
        String str;
        ResponseObject ro;
        block7: {
            ro = ResponseObject.newOkResponse();
            Map upgradeApp = new HashMap();
            try {
                List<String> v = new UtilString(mappId).split(",");
                ArrayList<String> newApps = new ArrayList<String>();
                int i = 0;
                while (i < v.size()) {
                    String appId = v.get(i);
                    if (appId != null && appId.trim().length() > 0) {
                        newApps.add(String.valueOf(appId.trim()) + ".app");
                    }
                    ++i;
                }
                upgradeApp = AppUpgrader.upgrade(newApps);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            str = "";
            try {
                if (upgradeApp.size() > 0) {
                    str = ((String)upgradeApp.get(mappId)).toString();
                }
            }
            catch (Exception ex) {
                if (upgradeApp.size() <= 0) break block7;
                str = ((String)upgradeApp.get(String.valueOf(mappId) + ".app")).toString();
            }
        }
        JSONObject js = new JSONObject();
        js.put("info", (Object)str);
        ro.setData(js);
        return ro.toDataString();
    }
}

