/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextDepend;
import com.actionsoft.apps.resource.AppDependencyHelper;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.util.AppComparator;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AppContainerException;
import com.actionsoft.i18n.I18nMetadataUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DashboardWeb
extends AMCWeb {
    public DashboardWeb(UserContext me) {
        super(me);
    }

    public String getDashboardPage(String param) {
        int totalPage;
        JSONObject paramJO;
        try {
            paramJO = JSONArray.parseObject((String)param);
        }
        catch (Exception e) {
            paramJO = new JSONObject();
            paramJO.put("navIndex", (Object)1);
        }
        int navIndex = paramJO.getIntValue("navIndex");
        int mesPage = paramJO.getIntValue("mesPage");
        if (mesPage == 0) {
            mesPage = 1;
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        List appContextsTmp = AppsAPIManager.getInstance().getInstalledApps();
        ArrayList<AppContext> appContexts = new ArrayList<AppContext>();
        for (AppContext appContext : appContextsTmp) {
            if (!GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) && !AMCAPIManager.isDevelopApp(appContext.getId(), this.getContext().getUID()) && !AMCAPIManager.isManagementApp(appContext.getId(), this.getContext().getUID())) continue;
            appContexts.add(appContext);
        }
        int totalError = this.getAllAppNotificationCount(appContexts, "err");
        int totalWaring = this.getAllAppNotificationCount(appContexts, "warn");
        String appLink = this.getAppLink();
        List<AppLogMsg> messageList = AMCUtil.getALLAppMessageListNoInfo();
        int n = totalPage = messageList.size() % 20 > 0 ? messageList.size() / 20 + 1 : messageList.size() / 20;
        if (navIndex == 1) {
            macroLibraries.put("htmlList", this.getAppOperationStateHtml());
            macroLibraries.put("appSize", appContexts.size());
            macroLibraries.put("list", HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.dashboard.apprunningstate.htm", macroLibraries));
        } else if (navIndex == 2) {
            String more = "";
            if (totalPage > 1) {
                more = "<span id='more'><a href='#' style='margin-left: 5px;margin-top:10px;font-size: 14px' onclick='Dashboard.getMoreRecodes();return false;'>\u67e5\u770b\u66f4\u591a\u6d88\u606f\u8bb0\u5f55</a></span>";
            }
            macroLibraries.put("more", more);
            macroLibraries.put("htmlMessageList", this.getMessageCenterHtml(mesPage));
            macroLibraries.put("list", HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.dashboard.infocenter.htm", macroLibraries));
        }
        Map queryAppListState = AppDependencyHelper.queryAppListState((String)this.getContext().getUID());
        int activeAppSize = ((List)queryAppListState.get("ACTIVE")).size();
        int suspendAppSize = ((List)queryAppListState.get("STOPPED")).size();
        int offLineAppsSize = ((List)queryAppListState.get("OFFLINE")).size();
        int totalApps = appContexts.size();
        String healthDegreeTitle = "\u5e94\u7528\u5065\u5eb7";
        String healthDegreeColor = "#9BCA63";
        if (offLineAppsSize > 0) {
            healthDegreeTitle = "\u6709\u8131\u673a\u5e94\u7528";
            healthDegreeColor = "#FAD860";
        } else if (suspendAppSize > 0) {
            healthDegreeTitle = "\u6709\u6682\u505c\u5e94\u7528";
            healthDegreeColor = "#FE8463";
        }
        macroLibraries.put("offLineAppsSize", offLineAppsSize);
        macroLibraries.put("suspendAppSize", suspendAppSize);
        macroLibraries.put("activeAppSize", activeAppSize);
        macroLibraries.put("totalApps", totalApps);
        macroLibraries.put("healthDegreeTitle", healthDegreeTitle);
        macroLibraries.put("healthDegreeColor", healthDegreeColor);
        macroLibraries.put("totalPage", totalPage);
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("navIndex", navIndex);
        macroLibraries.put("appLink", appLink);
        macroLibraries.put("errorAndWaring", this.getTotalErrorAndWaringHtml(totalError, totalWaring));
        macroLibraries.put("messageCount", this.getMessageCountHtml(totalError + totalWaring));
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.dashboard.htm", macroLibraries);
    }

    private String getAppLink() {
        StringBuilder appLink = new StringBuilder();
        appLink.append("<a href='#'\tonclick='Dashboard.skipAppInstall();return false;'>\u672c\u5730\u5b89\u88c5</a>");
        AppPlatformConfig.initConfig();
        if (AppPlatformConfig.isAppStoreService()) {
            appLink.append("\u6216\u6d4f\u89c8<a\t href='#' onclick='Dashboard.openStore();return false;'>" + AppPlatformConfig.getAppStoreName() + "</a>");
        }
        appLink.append("</a>");
        return appLink.toString();
    }

    public String getTotalErrorAndWaringHtml(int totalError, int totalWaring) {
        StringBuilder html = new StringBuilder();
        html.append("<div id='errorinfo' style='position:absolute;height:20px;line-height:20px;margin-top:25px;color:gray;font-size:10px;font-weight:normal'>");
        if (totalError > 0) {
            html.append("<span class='overview error'>");
            html.append(totalError);
            html.append("</span> &nbsp;");
        }
        if (totalWaring > 0) {
            html.append("<span class='overview warn'>");
            html.append(totalWaring);
            html.append("</span>");
        }
        html.append("</div>");
        return html.toString();
    }

    private String getAppOperationStateHtml() {
        StringBuilder html = new StringBuilder();
        AppContext sysApp = AppsAPIManager.getInstance().getAppContext("_bpm.platform");
        List<Object> appContexts = new ArrayList();
        try {
            appContexts = AMCUtil.queryAllAppsList();
            for (AppContext appContext : appContexts) {
                if (appContext == null || !GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) && !AMCAPIManager.isDevelopApp(appContext.getId(), this.getContext().getUID()) && !AMCAPIManager.isManagementApp(appContext.getId(), this.getContext().getUID())) continue;
                html.append(this.getEveryOneAppOperationStateHtml(appContext));
            }
        }
        catch (AppContainerException appContainerException) {
            appContainerException.printStackTrace();
        }
        return html.toString();
    }

    private String getEveryOneAppOperationStateHtml(AppContext appContext) {
        boolean isDepend = true;
        AppContextDepend appDependContext = appContext.getDepend();
        AppContext dependApp = null;
        if (appDependContext != null && (dependApp = AppsAPIManager.getInstance().getAppContext(appDependContext.getAppId())) != null) {
            isDepend = appDependContext.isDependVersion(dependApp.getVersion());
        }
        StringBuilder html = new StringBuilder();
        html.append("<tr>");
        String img = AMCUtil.getListAppIcon(appContext.getId());
        String function = "Dashboard.skip(1,\"" + appContext.getId() + "\",\"" + appContext.getName() + "\",\"index\");return false;";
        html.append("<input type='hidden' value='" + appContext.getId() + "' name='appId'>");
        html.append("<td class='list name'>");
        html.append(img);
        String appNameI18N = I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName());
        if (isDepend) {
            html.append("<a class='app_name' href='#' onclick='" + function + "' title='" + appNameI18N + "'>" + AMCUtil.getAppNewName(appNameI18N, 22) + "</a>");
        } else {
            String dependNameI18N = I18nMetadataUtil.findValue(dependApp.getId(), "APP_NAME_", dependApp.getId(), this.getContext().getLanguage(), dependApp.getName());
            html.append("<span style='color: gray;' title='\u5f53\u524d\u5e94\u7528\u4f9d\u8d56\u7684\u7236\u5e94\u7528[" + dependNameI18N + "]\u5df2\u7ecf\u5347\u7ea7\u81f3[" + dependApp.getVersion() + "]\u800c\u5f53\u524d\u5e94\u7528\u4f9d\u8d56[" + dependNameI18N + "]\u7684[" + appDependContext.getVersions() + "],\u8bf7\u5347\u7ea7\u5f53\u524d\u5e94\u7528\u4ee5\u7ee7\u7eed\u64cd\u4f5c'>" + AMCUtil.getAppNewName(appNameI18N) + "</span>");
        }
        html.append("</td>");
        html.append("<td class='list state'>");
        html.append(AMCUtil.getAppNotificationCountHtml(appContext, "dashboard", isDepend));
        html.append("</td>");
        html.append("<td class='list runtime'>");
        if (appContext.getRuntimeState().equals("ACTIVE")) {
            html.append("\u5df2\u8fd0\u884c" + AMCUtil.getAppRunTime(appContext.getStartTime()));
        } else {
            html.append(AMCUtil.getAppRunTimeStatus(appContext.getRuntimeState()));
        }
        html.append("</td>");
        html.append("</tr>");
        return html.toString();
    }

    private int getAllAppNotificationCount(List<AppContext> appContexts, String level) {
        int total = 0;
        for (AppContext appContext : appContexts) {
            if (appContext == null) continue;
            total += AMCUtil.getAppNotificationNoReadCount(appContext.getId(), level);
        }
        return total;
    }

    public String getMessageCountHtml(int totalMessages) {
        StringBuilder html = new StringBuilder();
        if (totalMessages > 0) {
            html.append("<div id='imcenter' style='position:absolute;height:20px;line-height:20px;margin-top:25px;color:gray;font-weight:normal'>");
            html.append(String.valueOf(totalMessages) + "\u6761\u6d88\u606f");
            html.append("</div>");
        }
        return html.toString();
    }

    public String getMessageCenterHtml(int page) {
        return this.getMessageCenterByPage(page, true);
    }

    public String getMessageCenterByPage(int page, boolean isPage) {
        StringBuilder html = new StringBuilder();
        List<AppLogMsg> messageList = AMCUtil.getALLAppMessageListNoInfo();
        Collections.sort(messageList, new AppComparator.MessageDateComparatorDESC());
        int total = messageList.size();
        int start = 0;
        int end = total;
        if (isPage) {
            start = (page - 1) * 20;
            end = page * 20;
            end = end > total ? total : end;
        }
        StringBuilder appIds = new StringBuilder();
        int i = start;
        while (i < end) {
            AppLogMsg appLogBean = messageList.get(i);
            appLogBean.setRead(true);
            String css1 = "info1";
            String css2 = "unread";
            String level = appLogBean.getLevel();
            boolean isRead = appLogBean.isRead();
            if (level.equals("err")) {
                css1 = "error1";
            } else if (level.equals("warn")) {
                css1 = "warn1";
            }
            if (isRead) {
                css2 = "read";
            }
            AppContext targetApp = AMCUtil.getAppByLogBean(appLogBean);
            String appId = "";
            String appName = "";
            if (targetApp != null) {
                appId = targetApp.getId();
                appName = targetApp.getName();
            }
            html.append("<tr>");
            html.append("<td class='infolist info' infotd=infotd>");
            html.append("<div style='margin: 5px; border-bottom: 1px solid rgb(230, 230, 230);' id='" + appLogBean.getId() + "' class='ellipsis " + css2 + "' title='" + appLogBean.getMsg() + "' appId='" + appId + "' logId='" + appLogBean.getId() + "' >");
            html.append("<span class='icon " + css1 + "'> </span>");
            html.append("<span class='infolist appname' style='margin-right:6px;'>" + appName + "</span> ");
            html.append("<span class='infolist appname'>" + UtilDate.datetimeFormat(new Date(appLogBean.getTime())) + "</span>");
            html.append("<br>");
            html.append("<span style='color: gray;' onclick='Dashboard.setRead(\"" + appId + "\",\"" + appLogBean.getId() + "\");return false;' >" + appLogBean.getMsg() + "</span>");
            html.append("</div>");
            html.append("</td>");
            html.append("</tr>");
            if (i == 0) {
                appIds.append(String.valueOf(appId) + "-" + appLogBean.getId());
            } else {
                appIds.append("|" + appId + "-" + appLogBean.getId());
            }
            ++i;
        }
        html.append("<input type='hidden' id='appIdandLogId' value='" + appIds + "'  >");
        return html.toString().replaceAll("\n", "<br>").replaceAll("\t", "&nbsp;&nbsp;");
    }

    public String getInstallAppNames(String key) {
        List appContexts = AppsAPIManager.getInstance().getInstalledApps();
        JSONArray appNames = new JSONArray();
        for (AppContext appContext : appContexts) {
            if (appContext.getId().toLowerCase().indexOf(key.toLowerCase()) <= -1 && appContext.getName().toLowerCase().indexOf(key.toLowerCase()) <= -1) continue;
            JSONObject json = new JSONObject();
            String img = AMCUtil.getAppIconNoClass(appContext.getId());
            json.put("id", (Object)appContext.getId());
            json.put("label", (Object)appContext.getName());
            json.put("value", (Object)appContext.getName());
            json.put("imgs", (Object)img);
            appNames.add((Object)json);
        }
        return appNames.toString();
    }

    public String modifyLogToRead(String appIdAndlogId, boolean isRead) {
        String isSuccess = "";
        UtilString ut = new UtilString(appIdAndlogId);
        List<String> list = ut.split("|");
        int i = 0;
        while (i < list.size()) {
            String al = list.get(i);
            if (al.indexOf("-") > -1) {
                UtilString aut = new UtilString(al);
                List<String> li = aut.split("-");
                String appId = li.get(0);
                String logId = li.get(1);
                AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
                List logs = app.getNotification();
                for (AppLogMsg appLogBean : logs) {
                    if (!appLogBean.getId().equals(logId)) continue;
                    appLogBean.setRead(isRead);
                    isSuccess = "ok";
                    break;
                }
            }
            ++i;
        }
        return isSuccess;
    }
}

