/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.util.AppComparator;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class MessageCenterWeb
extends AMCWeb {
    public MessageCenterWeb(UserContext me) {
        super(me);
    }

    public String getMessageCenterPage() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        List<AppLogMsg> messageList = AMCUtil.getALLAppMessageList(this.getContext().getUID());
        int totalPage = messageList.size() % 50 > 0 ? messageList.size() / 50 + 1 : messageList.size() / 50;
        String more = "";
        if (totalPage > 1) {
            more = "<span id='more' style='display:none;'><a href='#' style='margin-left: 5px;margin-top:10px;font-size: 14px;' onclick='ApplicationMessageCenter.getMore();return false;'>\u67e5\u770b\u66f4\u591a\u6d88\u606f\u8bb0\u5f55</a></span>";
        }
        macroLibraries.put("sid", this.getContext().getSessionId());
        macroLibraries.put("more", more);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmessagecenter.htm", macroLibraries);
    }

    public String getMessageCenterGrid(String searchKey, int page, String level) {
        List<AppLogMsg> messageList = AMCUtil.getMessageListByLevel(level, this.getContext().getUID());
        return this.getGridData(messageList, searchKey, page);
    }

    private String getGridData(List<AppLogMsg> messageList, String searchKey, int page) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject info = new JSONObject();
        StringBuilder grid = new StringBuilder();
        int totalPage = 0;
        Collections.sort(messageList, new AppComparator.MessageDateComparatorDESC());
        ArrayList<AppLogMsg> newList = new ArrayList<AppLogMsg>();
        for (AppLogMsg appLogBean : messageList) {
            if (appLogBean == null || UtilString.isEmpty(appLogBean.getMsg()) || appLogBean == null || appLogBean.getMsg().toLowerCase().indexOf(searchKey.toLowerCase()) <= -1) continue;
            newList.add(appLogBean);
        }
        int total = newList.size();
        int start = 0;
        int end = total;
        start = (page - 1) * 50;
        end = page * 50;
        end = end > total ? total : end;
        int i = start;
        while (i < end) {
            AppLogMsg appLogBean = (AppLogMsg)newList.get(i);
            if (appLogBean.getMsg().toLowerCase().indexOf(searchKey.toLowerCase()) > -1) {
                grid.append(this.getSingleAppHtml(appLogBean));
            }
            ++i;
        }
        totalPage = newList.size() % 50 > 0 ? newList.size() / 50 + 1 : newList.size() / 50;
        info.put("grid", (Object)grid.toString());
        info.put("count", (Object)AMCUtil.getSuspendStr());
        info.put("totalPage", (Object)totalPage);
        ro.setData(info);
        return ro.toString();
    }

    public String getSingleAppHtml(AppLogMsg appLogBean) {
        StringBuilder html = new StringBuilder();
        html.append("<tr id='" + appLogBean.getId() + "'>");
        html.append(this.getSingleAppNoTrHtml(appLogBean));
        html.append("</tr>");
        return html.toString();
    }

    public String getSingleAppNoTrHtml(AppLogMsg appLogBean) {
        StringBuilder html = new StringBuilder();
        String css1 = "info1";
        String level = appLogBean.getLevel();
        boolean isRead = appLogBean.isRead();
        String css2 = "unread";
        if (isRead) {
            css2 = "read";
        }
        if (level.equals("err")) {
            css1 = "error1";
        } else if (level.equals("warn")) {
            css1 = "warn1";
        }
        html.append("<td class='list'style='text-align:center;width:5%;' >");
        html.append("<div>");
        html.append("<span class='icon " + css1 + "'> </span>");
        html.append("</div>");
        html.append("</td>");
        html.append("<td class='list'  style='width:54%;' infotd='infotd'>");
        html.append("<div style='margin:0px 5px;white-space:normal;float:left;line-height:25px;' class='ellipsis " + css2 + "' id='log_" + appLogBean.getId() + "' logId='" + appLogBean.getId() + "'>");
        html.append(appLogBean.getMsg());
        html.append("</div>");
        html.append("</td>");
        AppContext targetApp = AMCUtil.getAppByLogBean(appLogBean);
        html.append("<td style='width:25%;' class='list'>");
        html.append("<div style='float:left;' title='" + (targetApp == null ? "" : targetApp.getName()) + "' >");
        html.append(targetApp == null ? "" : AMCUtil.getAppNewName(targetApp.getName()));
        html.append("</div>");
        html.append("</td>");
        html.append("<td style='width:15%;' class='list runtime'>");
        html.append(UtilDate.datetimeFormat(new Date(appLogBean.getTime())));
        html.append("</td>");
        if (!appLogBean.isRead()) {
            appLogBean.setRead(true);
        }
        return html.toString();
    }

    public String getNotificationByLevel(String level, int page) {
        List<AppLogMsg> messageList = AMCUtil.getMessageListByLevel(level, this.getContext().getUID());
        Collections.sort(messageList, new AppComparator.MessageDateComparatorDESC());
        return this.getGridData(messageList, "", page);
    }
}

