/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.appextension;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.AppExtensionProfile;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.sdk.local.SDK;
import java.util.List;
import java.util.Vector;

public final class AppExtensionManager {
    private static List<AppExtensionProfile> _list = new Vector<AppExtensionProfile>();

    private AppExtensionManager() {
    }

    public static boolean registerPlugin(AppContext app, AppExtensionProfile profile) {
        for (AppExtensionProfile p : _list) {
            if (!p.getId().equals(profile.getId())) continue;
            SDK.getAppAPI().err(app, "AppExtension\u540d[" + profile.getName() + "]\u5df2\u88ab\u6ce8\u518c\u4f7f\u7528");
            return false;
        }
        profile.setAppContext(app);
        _list.add(profile);
        return true;
    }

    public static void bindService() {
        for (AppExtensionProfile p : _list) {
            p.setCall(true);
            ResponseObject ro = SDK.getAppAPI().callASLP(p.getAppContext(), p.getAslp(), p.getParams());
            if (ro.isOk()) continue;
            SDK.getAppAPI().err(p.getAppContext(), ro.getMsg());
        }
    }

    public static void unBindService(AppContext app) {
        for (AppExtensionProfile p : _list) {
            if (!p.getAppContext().getId().equals(app.getId())) continue;
            p.setCall(false);
        }
    }

    public static void bindService(String appId) {
        for (AppExtensionProfile p : _list) {
            ResponseObject ro;
            if (!p.getParentAppId().equals(appId) || (ro = SDK.getAppAPI().callASLP(p.getAppContext(), p.getAslp(), p.getParams())).isOk()) continue;
            SDK.getAppAPI().err(p.getAppContext(), ro.getMsg());
        }
    }

    public static boolean destoryPlugin(AppContext app, AppExtensionProfile profile) {
        AppExtensionProfile p = AppExtensionManager.getProfile(profile.getId());
        if (p != null) {
            _list.remove(p);
        }
        return true;
    }

    public static AppExtensionProfile getProfile(String id) {
        for (AppExtensionProfile p : _list) {
            if (!p.getId().equals(id)) continue;
            return p;
        }
        return null;
    }
}

