/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.appstore.util;

import com.actionsoft.bpms.commons.appstore.util.DoInByteStreamRequest;
import com.actionsoft.bpms.commons.appstore.util.WebClientDevWrapper;
import com.actionsoft.exception.AppStoreException;
import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AppStoreHttpRequestUtil {
    public static String doGet(String url, String queryString) {
        String resultHtml;
        block15: {
            if (queryString != null && !"".equals(queryString)) {
                url = String.valueOf(url) + "?" + queryString;
            }
            resultHtml = null;
            DefaultHttpClient httpClient = null;
            HttpGet httpGet = null;
            httpClient = new DefaultHttpClient();
            HttpResponse response = null;
            HttpEntity httpEntity = null;
            try {
                try {
                    httpClient = WebClientDevWrapper.wrapClient((HttpClient)httpClient);
                    httpGet = new HttpGet(url);
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    httpEntity = response.getEntity();
                    int code = response.getStatusLine().getStatusCode();
                    if (code == 200 && httpEntity != null) {
                        resultHtml = EntityUtils.toString((HttpEntity)httpEntity);
                        break block15;
                    }
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (HttpHostConnectException e) {
                    e.printStackTrace(System.err);
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (NoRouteToHostException e) {
                    e.printStackTrace(System.err);
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (UnknownHostException e) {
                    e.printStackTrace(System.err);
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (httpEntity != null) {
                    try {
                        httpEntity.consumeContent();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        return resultHtml;
    }

    public static void doGetByteStream(String url, String queryString, DoInByteStreamRequest doin) throws Exception {
        block14: {
            if (queryString != null && !"".equals(queryString)) {
                url = String.valueOf(url) + "?" + queryString;
            }
            DefaultHttpClient httpClient = null;
            HttpGet httpGet = null;
            httpClient = new DefaultHttpClient();
            HttpResponse response = null;
            HttpEntity httpEntity = null;
            try {
                httpClient = WebClientDevWrapper.wrapClient((HttpClient)httpClient);
                httpGet = new HttpGet(url);
                response = httpClient.execute((HttpUriRequest)httpGet);
                httpEntity = response.getEntity();
                int code = response.getStatusLine().getStatusCode();
                if (code == 200 && httpEntity != null) {
                    InputStream input = null;
                    if (httpEntity.isStreaming()) {
                        long fileLength = httpEntity.getContentLength();
                        input = httpEntity.getContent();
                        doin.executeStream(fileLength, input);
                        break block14;
                    }
                    throw new Exception("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u54cd\u5e94\u4e0d\u662f\u5b57\u8282\u6d41");
                }
                if (code != 200) {
                    throw new Exception("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0chttp\u54cd\u5e94\u7801\uff1a" + code);
                }
                throw new Exception("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a");
            }
            finally {
                if (httpEntity != null) {
                    httpEntity.consumeContent();
                }
            }
        }
    }

    public static String doPost(String url, Map<String, String> params) {
        String resultHtml;
        block16: {
            resultHtml = null;
            DefaultHttpClient httpClient = null;
            HttpPost httpPost = null;
            httpClient = new DefaultHttpClient();
            HttpResponse response = null;
            HttpEntity httpEntity = null;
            try {
                try {
                    httpClient = WebClientDevWrapper.wrapClient((HttpClient)httpClient);
                    httpPost = new HttpPost(url);
                    if (params != null && params.size() > 0) {
                        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                        for (Map.Entry<String, String> entry : params.entrySet()) {
                            pairList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                        }
                        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(pairList, "UTF-8");
                        formEntity.setContentType("application/x-www-form-urlencoded");
                        httpPost.setEntity((HttpEntity)formEntity);
                    }
                    response = httpClient.execute((HttpUriRequest)httpPost);
                    httpEntity = response.getEntity();
                    int code = response.getStatusLine().getStatusCode();
                    if (code == 200 && httpEntity != null) {
                        resultHtml = EntityUtils.toString((HttpEntity)httpEntity);
                        break block16;
                    }
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (HttpHostConnectException e) {
                    e.printStackTrace(System.err);
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (NoRouteToHostException e) {
                    e.printStackTrace(System.err);
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (UnknownHostException e) {
                    e.printStackTrace(System.err);
                    throw new AppStoreException("\u65e0\u6cd5\u8fde\u63a5\u5230\u5e94\u7528\u5546\u5e97\u4e3b\u673a");
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (httpEntity != null) {
                    try {
                        httpEntity.consumeContent();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return resultHtml;
    }

    public static void main(String[] args) {
        String x = AppStoreHttpRequestUtil.doGet("http://192.168.0.15/api/login", "uid=dama@store.com&pwd=111111");
        System.out.println(x);
    }
}

