/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.appstore.util;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.AppInstaller;
import java.io.File;

public class AppStoreURLCreateUtil {
    private static final String URI_APPSTORE_LOGIN = "/api/login";
    private static final String URI_APPSTORE_APPINIT = "/api/queryTagApps/{tag}/{page}/{size}";
    private static final String URI_APPSTORE_CATEGORY_APP = "/api/queryCategoryApps/{categoryType}/{categoryId}/{page}/{size}";
    private static final String URI_APPSTORE_KEYWORD_APP = "/api/queryApps/{keyword}/{page}/{size}";
    private static final String URI_APPSTORE_CATEGORYS = "/api/queryCategoryDef";
    private static final String URI_APPSTORE_CHECKAPPBEFOREDOWN = "/api/checkAppBeforeDown/{productId}";
    private static final String URI_APPSTORE_DOWNLOADAPP = "/api/downloadApp/{productId}";
    private static final String URI_APPSTORE_INSTALLAPP = "/api/installApp/{productId}";
    private static final String URI_APPSTORE_STARTAPPERR = "/api/startAppError/{productId}";
    private static final String URI_APPSTORE_PIC = "/fileRead/appImgfile/simple/{appid}/{filename}";
    private static final String URI_APPSTORE_CHECKAPPSUPGRADE = "/api/appsNeedUpgrade";
    private static final String URI_APPSTORE_SOLUTIONPACKAGE = "/api/solutionpackages";
    private static final String URI_APPSTORE_INSTALLSOLUTIONPACKAGE = "/api/savespinstall/{spid}";
    private static final String URI_APPSTORE_APPDETAIL = "/api/detailApp/{appId}";
    private static final String URI_SESSIONID = "jsessionid";
    public static final String APP_TAG_HOT = "hot";
    public static final String APP_TAG_FREE = "free";
    public static final String APP_TAG_RECOMMEND = "recommend";
    public static final String APP_TAG_NEW = "new";
    public static final String APP_TAG_TOP = "top";

    public static String getStoreLoginUrl(String uid, String pwd) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_LOGIN;
        url = String.valueOf(url) + "?uid=" + uid + "&pwd=" + pwd + "&pwdtype=md5";
        return url;
    }

    public static String getCheckAppsNeedUpgardeUrl(String jessionid) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_CHECKAPPSUPGRADE + "?" + URI_SESSIONID + "=" + jessionid;
        return url;
    }

    public static String getAppsByTagUrl(String jsessionid, String tag, int page, int size) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_APPINIT + "?" + URI_SESSIONID + "=" + jsessionid;
        url = url.replace("{tag}", tag).replace("{page}", String.valueOf(page)).replace("{size}", String.valueOf(size));
        return url;
    }

    public static String getAppPicUrl(String appId, String filename) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_PIC;
        url = url.replace("{appid}", appId).replace("{filename}", filename);
        return url;
    }

    public static String getAppByKeywordUrl(String jsessionid, String keyword, String where, String sort, int page, int size) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_KEYWORD_APP + "?" + URI_SESSIONID + "=" + jsessionid;
        if (where != null && where.length() > 0) {
            url = String.valueOf(url) + "&where=" + where;
        }
        if (sort != null && sort.length() > 0) {
            url = String.valueOf(url) + "&sort=" + sort;
        }
        url = url.replace("{keyword}", keyword).replace("{page}", String.valueOf(page)).replace("{size}", String.valueOf(size));
        return url;
    }

    public static String getAppCategorysUrl(String jsessionid) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_CATEGORYS + "?" + URI_SESSIONID + "=" + jsessionid;
        return url;
    }

    public static String getAppByCategoryUrl(String jsessionid, String categoryType, String categoryId, String where, String sort, int page, int size) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_CATEGORY_APP + "?" + URI_SESSIONID + "=" + jsessionid;
        if (where != null && where.length() > 0) {
            url = String.valueOf(url) + "&where=" + where;
        }
        if (sort != null && sort.length() > 0) {
            url = String.valueOf(url) + "&sort=" + sort;
        }
        url = url.replace("{categoryType}", categoryType).replace("{categoryId}", categoryId).replace("{page}", String.valueOf(page)).replace("{size}", String.valueOf(size));
        return url;
    }

    public static String getCheckAppBeforeDownUrl(String jsesssionid, String productId) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_CHECKAPPBEFOREDOWN + "?" + URI_SESSIONID + "=" + jsesssionid;
        url = url.replace("{productId}", productId);
        return url;
    }

    public static String getAppDownUrl(String jsesssionid, String productId) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_DOWNLOADAPP + "?" + URI_SESSIONID + "=" + jsesssionid;
        url = url.replace("{productId}", productId);
        return url;
    }

    public static String getAppInstallUrl(String productId, String developId) {
        if (developId == null) {
            developId = "";
        }
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_INSTALLAPP + "?developId=" + developId;
        url = url.replace("{productId}", productId);
        return url;
    }

    public static String getStartAppErrUrl(String productId, String developId) {
        if (developId == null) {
            developId = "";
        }
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_STARTAPPERR + "?developId=" + developId;
        url = url.replace("{productId}", productId);
        return url;
    }

    public static String getAppTmpSavePath() {
        String tmp = AppInstaller.getInstallPath();
        File file = new File(tmp = String.valueOf(tmp.replace("install", "tmp")) + "/");
        if (!file.exists()) {
            file.mkdirs();
        }
        return tmp;
    }

    public static String getAppLoadSavePath() {
        String path = String.valueOf(AppInstaller.getUploadPath()) + "/";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }

    public static String getSolutionPackages(String jsessionId, String keyword) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_SOLUTIONPACKAGE + "?" + URI_SESSIONID + "=" + jsessionId + "&keyword=" + keyword;
        return url;
    }

    public static String installSolutionPackage(String jsessionId, String spId) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_INSTALLSOLUTIONPACKAGE + "?" + URI_SESSIONID + "=" + jsessionId;
        url = url.replace("{spid}", spId);
        return url;
    }

    public static String getAppDetailUrl(String jsessionId, String appId) {
        String url = String.valueOf(AppPlatformConfig.getAppStoreHost()) + URI_APPSTORE_APPDETAIL + "?" + URI_SESSIONID + "=" + jsessionId;
        url = url.replace("{appId}", appId);
        return url;
    }
}

