/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.appstore.web;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextDepend;
import com.actionsoft.apps.resource.AppTeam;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.appstore.model.APIData;
import com.actionsoft.bpms.commons.appstore.model.AppDownLog;
import com.actionsoft.bpms.commons.appstore.model.AppEntity;
import com.actionsoft.bpms.commons.appstore.util.AppOperateProcessLogs;
import com.actionsoft.bpms.commons.appstore.util.AppOperateThreadTag;
import com.actionsoft.bpms.commons.appstore.util.AppStoreHttpRequestUtil;
import com.actionsoft.bpms.commons.appstore.util.AppStoreJsonUtil;
import com.actionsoft.bpms.commons.appstore.util.AppStoreSolutionPackageInstallState;
import com.actionsoft.bpms.commons.appstore.util.AppStoreStringUtil;
import com.actionsoft.bpms.commons.appstore.util.AppStoreURLCreateUtil;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.emm.mam.apps.MobileAppProfile;
import com.actionsoft.emm.mam.apps.MobileAppsResource;
import com.actionsoft.exception.AppStoreException;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppStoreAppWeb
extends ActionWeb {
    public AppStoreAppWeb(UserContext userContext) {
        super(userContext);
    }

    private static boolean appIsExtPermissions(String appId, Map<String, String> permissions) {
        for (String id : permissions.keySet()) {
            if (!id.equals(appId)) continue;
            return true;
        }
        return false;
    }

    public String getAppsNeedUpgrade(String jsessionid, String isSolution, String appJson) {
        String url = AppStoreURLCreateUtil.getCheckAppsNeedUpgardeUrl(jsessionid);
        String responseStr = null;
        String str = null;
        try {
            HashMap<String, String> parammap = new HashMap<String, String>();
            parammap.put("apps", appJson);
            responseStr = AppStoreHttpRequestUtil.doPost(url, parammap);
            str = this.appCommontUtil(responseStr, isSolution, true);
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u9519\u8bef");
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        return str;
    }

    public String appMsgInit(String jsessionid, String isSolution, int page, int size) {
        return this.appMsgInit(jsessionid, isSolution, page, size, false);
    }

    public String appMsgInit(String jsessionid, String isSolution, int page, int size, boolean isCheckUpdate) {
        String url = AppStoreURLCreateUtil.getAppsByTagUrl(jsessionid, "recommend", page, size);
        String responseStr = null;
        String str = null;
        try {
            responseStr = AppStoreHttpRequestUtil.doGet(url, null);
            str = this.appCommontUtil(responseStr, isSolution, isCheckUpdate);
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u9519\u8bef");
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        return str;
    }

    public String getAppByTag(String jsessionid, String tag, String isSolution, int page, int size) {
        return this.getAppByTag(jsessionid, tag, isSolution, page, size, false);
    }

    public String getAppByTag(String jsessionid, String tag, String isSolution, int page, int size, boolean isCheckUpdate) {
        String url = AppStoreURLCreateUtil.getAppsByTagUrl(jsessionid, tag, page, size);
        String responseStr = null;
        String str = null;
        try {
            responseStr = AppStoreHttpRequestUtil.doGet(url, null);
            str = this.appCommontUtil(responseStr, isSolution, isCheckUpdate);
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u9519\u8bef");
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        return str;
    }

    public String getAppByKeyword(String jsessionid, String keyword, String isSolution, String where, String sort, int page, int size) {
        return this.getAppByKeyword(jsessionid, keyword, isSolution, where, sort, page, size, false);
    }

    public String getAppByKeyword(String jsessionid, String keyword, String isSolution, String where, String sort, int page, int size, boolean isCheckUpdate) {
        String str = null;
        try {
            keyword = URLEncoder.encode(keyword, "UTF-8");
            String url = AppStoreURLCreateUtil.getAppByKeywordUrl(jsessionid, keyword, where, sort, page, size);
            String responseStr = AppStoreHttpRequestUtil.doGet(url, null);
            str = this.appCommontUtil(responseStr, isSolution, isCheckUpdate);
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u9519\u8bef");
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        return str;
    }

    public String getAppByCategory(String storeSid, String categoryType, String categoryId, String isSolution, String where, String sort, int page, int size) {
        return this.getAppByCategory(storeSid, categoryType, categoryId, isSolution, where, sort, page, size, false);
    }

    public String getAppByCategory(String storeSid, String categoryType, String categoryId, String isSolution, String where, String sort, int page, int size, boolean isCheckUpdate) {
        String url = AppStoreURLCreateUtil.getAppByCategoryUrl(storeSid, categoryType, categoryId, where, sort, page, size);
        String responseStr = null;
        String str = null;
        try {
            responseStr = AppStoreHttpRequestUtil.doGet(url, null);
            str = this.appCommontUtil(responseStr, isSolution, isCheckUpdate);
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u9519\u8bef");
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        return str;
    }

    public String getAppCategorys(String storeSid) {
        String url = AppStoreURLCreateUtil.getAppCategorysUrl(storeSid);
        String responseStr = AppStoreHttpRequestUtil.doGet(url, null);
        return responseStr;
    }

    private String appCommontUtil(String responseStr, String isSolution, boolean isUpdateCheck) throws Exception {
        APIData apiData = (APIData)AppStoreJsonUtil.getObject4JsonString(responseStr, APIData.class);
        String result = apiData.getResult();
        AppsAPIManager apiManager = AppsAPIManager.getInstance();
        if ("ok".equals(result)) {
            AppEntity app;
            Object obj = apiData.getData().get("appList");
            String jsonListstr = AppStoreJsonUtil.getJsonString4JavaArray(obj);
            List tempAppList = AppStoreJsonUtil.getList4Json(jsonListstr, AppEntity.class);
            ArrayList<AppEntity> appList = new ArrayList<AppEntity>();
            for (Object e : tempAppList) {
                app = (AppEntity)e;
                if (isUpdateCheck) {
                    if (!AMCAPIManager.isDevelopApp(app.getAppId(), this.getContext().getUID())) continue;
                    try {
                        boolean isUpgrade = apiManager.isUpgrade(app.getAppId(), Double.valueOf(app.getVersion()).doubleValue(), Integer.valueOf(app.getBuildNo()).intValue());
                        if (!isUpgrade) {
                            continue;
                        }
                    }
                    catch (Exception isUpgrade) {
                        // empty catch block
                    }
                }
                appList.add(app);
            }
            for (Object e : appList) {
                app = (AppEntity)e;
                boolean appDevSecurity = true;
                if (this.getContext() != null) {
                    appDevSecurity = AMCAPIManager.isDevelopApp(app.getAppId(), this.getContext().getUID());
                }
                if (isUpdateCheck) {
                    if (!appDevSecurity) {
                        continue;
                    }
                } else {
                    app.setUpdateSec(appDevSecurity ? 1 : 0);
                }
                app.setBanner3(AppStoreURLCreateUtil.getAppPicUrl(app.getAppId(), app.getBanner3()));
                app.setDescription(AppStoreStringUtil.removeHtmlTag(app.getOverView()));
                app.setOverView(AppStoreStringUtil.subString(AppStoreStringUtil.removeHtmlTag(app.getOverView()), 10, "..."));
                if ("yes".equals(isSolution)) {
                    String msg;
                    AppContext appContext = apiManager.getAppContext(app.getAppId());
                    if (apiManager.isInstalled(app.getAppId())) {
                        boolean isUpgrade = false;
                        try {
                            isUpgrade = apiManager.isUpgrade(app.getAppId(), Double.valueOf(app.getVersion()).doubleValue(), Integer.valueOf(app.getBuildNo()).intValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (isUpgrade) {
                            app.setState("upgrade");
                            this.deleteLog(app);
                        } else {
                            app.setState("newest");
                        }
                    } else {
                        if (app.getPdPricing() == "0" || app.getPdPricing() == "0.00" || app.getPdPricing() == "") {
                            app.setState("free");
                        } else {
                            app.setState("try");
                        }
                        this.deleteLog(app);
                    }
                    String platformEnv = app.getPlatformEnv();
                    if (!AppContextDepend.isDependEnvVersion((String)platformEnv)) {
                        msg = "\u5f53\u524d\u5e94\u7528\u4f9d\u8d56\u5e73\u53f0\u7248\u672c[" + platformEnv + "]\uff0c\u8bf7\u5347\u7ea7\u5e73\u53f0";
                        app.setState("env" + msg);
                    }
                    if (AppOperateProcessLogs.get(app.getProductId()) == null) continue;
                    app.setLoadStatus(AppOperateProcessLogs.get(app.getProductId()).getStatus());
                    msg = AppOperateProcessLogs.get(app.getProductId()).getErrorMsg();
                    app.setLoadErrMsg(msg == null ? "" : msg);
                    continue;
                }
                app.setState("other");
            }
            apiData.getData().put("appList", appList);
            apiData.getData().put("isPaaSCloud", AWSServerConf.isPaaSCloud());
            responseStr = AppStoreJsonUtil.getJsonString4JavaPOJO(apiData);
        }
        return responseStr;
    }

    public String getAppDetail(String jsessionId, String appId) {
        String url = AppStoreURLCreateUtil.getAppDetailUrl(jsessionId, appId);
        String responseStr = AppStoreHttpRequestUtil.doGet(url, null);
        return responseStr;
    }

    public String downAppAndOperate(String storeSid, String productId, String optType) {
        APIData resultData = new APIData();
        String responsestr = null;
        boolean isreturn = false;
        AppDownLog tmplog = AppOperateProcessLogs.get(productId);
        if (tmplog != null && ("loding".equals(tmplog.getStatus()) || "insting".equals(tmplog.getStatus()) || "uping".equals(tmplog.getStatus()))) {
            resultData.setResult("warning");
            resultData.setMsg("doing");
            isreturn = true;
        }
        if (!isreturn) {
            try {
                String urlCheckApp = AppStoreURLCreateUtil.getCheckAppBeforeDownUrl(storeSid, productId);
                String checkStr = AppStoreHttpRequestUtil.doGet(urlCheckApp, null);
                APIData checkData = (APIData)AppStoreJsonUtil.getObject4JsonString(checkStr, APIData.class);
                if ("ok".equals(checkData.getResult())) {
                    AppDownLog downLog = new AppDownLog();
                    downLog.setProductId(productId);
                    downLog.setOperateType(optType);
                    downLog.setFilename((String)checkData.getData().get("filename"));
                    downLog.setFilesize((Integer)checkData.getData().get("applength"));
                    downLog.setAppMd5((String)checkData.getData().get("appMd5"));
                    downLog.setVersion((String)checkData.getData().get("version"));
                    downLog.setAppId((String)checkData.getData().get("appId"));
                    downLog.setBuildNo((String)checkData.getData().get("buildNo"));
                    downLog.setStatus("loding");
                    AppOperateProcessLogs.put(productId, downLog);
                    AppOperateThreadTag threadTag = new AppOperateThreadTag(downLog, storeSid);
                    new Thread(threadTag).start();
                    resultData.setResult("ok");
                    resultData.setMsg("\u5e94\u7528\u5b58\u5728");
                } else {
                    resultData.setResult("error");
                    resultData.setMsg(checkData.getMsg());
                }
            }
            catch (AppStoreException e) {
                e.printStackTrace();
                resultData.setResult("error");
                resultData.setMsg(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                resultData.setResult("error");
                resultData.setMsg("\u7cfb\u7edf\u9519\u8bef");
            }
        }
        responsestr = AppStoreJsonUtil.getJsonString4JavaPOJO(resultData);
        return responsestr;
    }

    public String sacnAppDownOperate() {
        ArrayList<AppDownLog> list = new ArrayList<AppDownLog>();
        Set<Map.Entry<String, AppDownLog>> set = AppOperateProcessLogs.entrySet();
        for (Map.Entry<String, AppDownLog> entry : set) {
            list.add(entry.getValue());
        }
        return AppStoreJsonUtil.getJsonString4JavaArray(list);
    }

    public String cancelAppLoad(String productId) {
        String rstr = "";
        AppDownLog lod = AppOperateProcessLogs.get(productId);
        if (lod != null) {
            rstr = AppStoreJsonUtil.getJsonString4JavaPOJO(lod);
            lod.setStatus("cancel");
        }
        return rstr;
    }

    private void deleteLog(AppEntity app) {
        AppDownLog log = AppOperateProcessLogs.get(app.getProductId());
        if (log != null && ("instover".equals(log.getStatus()) || "upover".equals(log.getStatus()) || "cancel".equals(log.getStatus()))) {
            AppOperateProcessLogs.remove(app.getProductId());
        }
    }

    public String getAllSolutionPackages(String storeSid, String keyword, String isSolution) {
        String str = null;
        JSONArray jsonList = new JSONArray();
        try {
            String encodeKeyword = URLEncoder.encode(keyword, "UTF-8");
            String url = AppStoreURLCreateUtil.getSolutionPackages(storeSid, encodeKeyword);
            String responseStr = AppStoreHttpRequestUtil.doGet(url, null);
            APIData apiData = (APIData)AppStoreJsonUtil.getObject4JsonString(responseStr, APIData.class);
            String result = apiData.getResult();
            if ("ok".equals(result)) {
                Object spList = apiData.getData().get("spList");
                jsonList = JSONArray.parseArray((String)JSON.toJSONString((Object)spList));
                int i = 0;
                while (i < jsonList.size()) {
                    JSONObject object = jsonList.getJSONObject(i);
                    JSONArray apps = object.getJSONArray("items");
                    double price = 0.0;
                    if (apps != null) {
                        object.put("appSize", (Object)apps.size());
                        int j = 0;
                        while (j < apps.size()) {
                            JSONObject item = apps.getJSONObject(j);
                            String priceS = item.getString("pdPricing");
                            if (AWSServerConf.isPaaSCloud()) {
                                priceS = item.getString("pricing");
                                price += Double.parseDouble(priceS) * 24.0 * 365.0;
                            } else {
                                price += Double.parseDouble(priceS);
                            }
                            ++j;
                        }
                    } else {
                        object.put("appSize", (Object)0);
                    }
                    DecimalFormat df = new DecimalFormat("###,##0.00");
                    object.put("price", (Object)(String.valueOf(df.format(price)) + (AWSServerConf.isPaaSCloud() ? "\u5143/\u5e74" : "\u5143/\u5b89\u88c5\u7248")));
                    ++i;
                }
            }
            ResponseObject ro = ResponseObject.newOkResponse();
            ro.put("data", jsonList);
            return ro.toString();
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
            ResponseObject ro = ResponseObject.newErrResponse(str);
            return ro.toString();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u9519\u8bef");
            str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
            ResponseObject ro = ResponseObject.newErrResponse(str);
            return ro.toString();
        }
    }

    public String getAllAppsBySolutionPackage(String spId, String obj, String isSolution) {
        JSONArray appJsonArray = JSONArray.parseArray((String)obj);
        String jsonListstr = AppStoreJsonUtil.getJsonString4JavaArray(appJsonArray);
        List appList = AppStoreJsonUtil.getList4Json(jsonListstr, AppEntity.class);
        int i = 0;
        while (i < appList.size()) {
            MobileAppProfile mobile;
            AppEntity app = (AppEntity)appList.get(i);
            app.setBanner1(appJsonArray.getJSONObject(i).containsKey((Object)"banner") ? appJsonArray.getJSONObject(i).getString("banner") : appJsonArray.getJSONObject(i).getString("banner1"));
            app.setBanner3(AppStoreURLCreateUtil.getAppPicUrl(app.getAppId(), appJsonArray.getJSONObject(i).containsKey((Object)"banner1") ? appJsonArray.getJSONObject(i).getString("banner1") : appJsonArray.getJSONObject(i).getString("banner")));
            app.setDescription(AppStoreStringUtil.removeHtmlTag(app.getOverView()));
            app.setOverView(AppStoreStringUtil.subString(AppStoreStringUtil.removeHtmlTag(app.getOverView()), 40, "..."));
            AppContext appContext = SDK.getAppAPI().getAppContext(app.getAppId());
            if (appContext != null && (mobile = MobileAppsResource.getMobileAppProfile((String)appContext.getId())) != null) {
                int deviceType = mobile.getDeviceType();
                int osType = MobileAppsResource.getOsType((MobileAppProfile)mobile);
                app.setOsType(osType == 2 ? "Android" : (osType == 1 ? "iOS" : ""));
            }
            if ("yes".equals(isSolution)) {
                AppsAPIManager apiManager = AppsAPIManager.getInstance();
                if (apiManager.isInstalled(app.getAppId())) {
                    if (apiManager.isUpgrade(app.getAppId(), Double.valueOf(app.getVersion()).doubleValue(), Integer.valueOf(app.getBuildNo()).intValue())) {
                        app.setState("upgrade");
                        this.deleteLog(app);
                    } else {
                        app.setState("newest");
                    }
                } else {
                    if ("\u514d\u8d39".equals(app.getLicenseType())) {
                        app.setState("free");
                    } else {
                        app.setState("try");
                    }
                    this.deleteLog(app);
                }
                if (AppOperateProcessLogs.get(app.getProductId()) != null) {
                    app.setLoadStatus(AppOperateProcessLogs.get(app.getProductId()).getStatus());
                    String msg = AppOperateProcessLogs.get(app.getProductId()).getErrorMsg();
                    app.setLoadErrMsg(msg == null ? "" : msg);
                } else {
                    String platformEnv = app.getPlatformEnv();
                    if (!AppContextDepend.isDependEnvVersion((String)platformEnv)) {
                        String msg = "\u5f53\u524d\u5e94\u7528\u4f9d\u8d56\u5e73\u53f0\u7248\u672c[" + platformEnv + "]\uff0c\u8bf7\u5347\u7ea7\u5e73\u53f0";
                        app.setState("env" + msg);
                    }
                }
            } else {
                app.setState("other");
            }
            ++i;
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        ro.put("appList", appList);
        String installingSpId = AppStoreSolutionPackageInstallState.getInstallSP();
        ro.put("installingSpId", installingSpId);
        ro.put("isPaaSCloud", AWSServerConf.isPaaSCloud());
        return ro.toString();
    }

    public String installSolutionPackage(String storeSid, String spId, String appList) {
        int errNum;
        block19: {
            if (!AppStoreSolutionPackageInstallState.setInstallSP(spId)) {
                ResponseObject ro = ResponseObject.newErrResponse();
                return ro.toString();
            }
            String str = null;
            errNum = 0;
            try {
                String url = AppStoreURLCreateUtil.installSolutionPackage(storeSid, spId);
                String responseStr = AppStoreHttpRequestUtil.doGet(url, null);
                APIData apiData = (APIData)AppStoreJsonUtil.getObject4JsonString(responseStr, APIData.class);
                String result = apiData.getResult();
                if (!"ok".equals(result)) break block19;
                JSONArray appJsonArray = JSONArray.parseArray((String)appList);
                AppsAPIManager apiManager = AppsAPIManager.getInstance();
                LinkedHashMap<String, String> installMap = new LinkedHashMap<String, String>();
                int i = 0;
                while (i < appJsonArray.size()) {
                    JSONObject app = appJsonArray.getJSONObject(i);
                    String appState = app.getString("state");
                    String appId = app.getString("appId");
                    String productId = app.getString("productId");
                    String state = "-1";
                    if (apiManager.isInstalled(appId)) {
                        if (apiManager.isUpgrade(appId, Double.valueOf(app.getString("version")).doubleValue(), Integer.valueOf(app.getString("buildNo")).intValue())) {
                            appState = "upgrade";
                            state = "0";
                        } else {
                            appState = "newest";
                            state = "1";
                        }
                    } else {
                        appState = "\u514d\u8d39".equals(app.getString("licenseType")) ? "free" : "try";
                        state = "0";
                    }
                    app.put("state", (Object)appState);
                    installMap.put(productId, state);
                    ++i;
                }
                AppStoreSolutionPackageInstallState.setApps(spId, installMap);
                AppTeam team = AppPlatformConfig.getAppTeamById((String)AppPlatformConfig.awsteam);
                Map permissions = team.getAppsPermissions();
                int i2 = 0;
                while (i2 < appJsonArray.size()) {
                    JSONObject app = appJsonArray.getJSONObject(i2);
                    String appState = app.getString("state");
                    if ("cancel".equals(AppStoreSolutionPackageInstallState.state)) {
                        ResponseObject ro = ResponseObject.newErrResponse();
                        ro.put("errNum", String.valueOf(appJsonArray.size()));
                        return ro.toString();
                    }
                    if (!"newest".equals(appState)) {
                        String productId = app.getString("productId");
                        try {
                            String urlCheckApp = AppStoreURLCreateUtil.getCheckAppBeforeDownUrl(storeSid, productId);
                            String checkStr = AppStoreHttpRequestUtil.doGet(urlCheckApp, null);
                            APIData checkData = (APIData)AppStoreJsonUtil.getObject4JsonString(checkStr, APIData.class);
                            if ("ok".equals(checkData.getResult()) && !"cancel".equals(AppStoreSolutionPackageInstallState.state)) {
                                String appId;
                                AppDownLog downLog = new AppDownLog();
                                downLog.setProductId(productId);
                                downLog.setOperateType(appState);
                                downLog.setFilename((String)checkData.getData().get("filename"));
                                downLog.setFilesize((Integer)checkData.getData().get("applength"));
                                downLog.setAppMd5((String)checkData.getData().get("appMd5"));
                                downLog.setVersion((String)checkData.getData().get("version"));
                                downLog.setAppId((String)checkData.getData().get("appId"));
                                downLog.setBuildNo((String)checkData.getData().get("buildNo"));
                                downLog.setStatus("loding");
                                AppOperateProcessLogs.put(productId, downLog);
                                AppOperateThreadTag appOperate = new AppOperateThreadTag(downLog, storeSid);
                                appOperate.doOpterate();
                                AppDownLog log = AppOperateProcessLogs.get(productId);
                                if (log != null) {
                                    if ("instover".equals(log.getStatus()) || "upover".equals(log.getStatus())) {
                                        AppStoreSolutionPackageInstallState.setInstallState(spId, productId, "1");
                                    } else {
                                        AppStoreSolutionPackageInstallState.setInstallState(spId, productId, "2");
                                        ++errNum;
                                    }
                                }
                                if (!AppStoreAppWeb.appIsExtPermissions(appId = (String)checkData.getData().get("appId"), permissions)) {
                                    permissions.put(appId, "AB");
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            AppStoreSolutionPackageInstallState.setInstallState(spId, productId, "2");
                            ++errNum;
                        }
                    }
                    ++i2;
                }
                AppStoreSolutionPackageInstallState.emptyInstallSP();
                team.setAppsPermissions(permissions);
                AppPlatformConfig.modifyTeam((AppTeam)team);
            }
            catch (AppStoreException e) {
                APIData apdata = new APIData();
                apdata.setResult("error");
                apdata.setMsg(e.getMessage());
                str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
                AppStoreSolutionPackageInstallState.emptyInstallSP();
                ResponseObject ro = ResponseObject.newErrResponse(str);
                return ro.toString();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                APIData apdata = new APIData();
                apdata.setResult("error");
                apdata.setMsg("\u7cfb\u7edf\u9519\u8bef");
                str = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
                AppStoreSolutionPackageInstallState.emptyInstallSP();
                ResponseObject ro = ResponseObject.newErrResponse(str);
                return ro.toString();
            }
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        ro.put("errNum", String.valueOf(errNum));
        return ro.toString();
    }

    public String sacnSpDownOperate() {
        String spId;
        ArrayList<AppDownLog> list = new ArrayList<AppDownLog>();
        Set<Map.Entry<String, AppDownLog>> set = AppOperateProcessLogs.entrySet();
        for (Map.Entry<String, AppDownLog> entry : set) {
            list.add(entry.getValue());
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        ro.put("appLog", AppStoreJsonUtil.getJsonString4JavaArray(list));
        Map<String, Integer> installedPersent = AppStoreSolutionPackageInstallState.getInstallPersent();
        ro.put("successNum", installedPersent.get("successNum"));
        ro.put("errNum", installedPersent.get("errNum"));
        ro.put("spPersent", installedPersent.get("installedPersent"));
        int spPersent = installedPersent.get("installedPersent");
        if (spPersent == 100) {
            AppStoreSolutionPackageInstallState.emptyInstallSP();
        }
        ro.put("spId", (spId = AppStoreSolutionPackageInstallState.getInstallSP()) == null ? "" : spId);
        return ro.toString();
    }

    public String cancelPackageLoad(String spId, String appList) {
        JSONArray rstr = new JSONArray();
        if (spId.equals(AppStoreSolutionPackageInstallState.spId)) {
            AppStoreSolutionPackageInstallState.state = "cancel";
            if (appList != null && !"".equals(appList)) {
                JSONArray appJsonArray = JSONArray.parseArray((String)appList);
                int i = 0;
                while (i < appJsonArray.size()) {
                    JSONObject object = appJsonArray.getJSONObject(i);
                    String productId = object.getString("productId");
                    AppDownLog lod = AppOperateProcessLogs.get(productId);
                    if (lod != null) {
                        rstr.add((Object)lod);
                        lod.setStatus("cancel");
                    }
                    ++i;
                }
            }
            AppStoreSolutionPackageInstallState.emptyInstallSP();
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        ro.put("logs", rstr.toString());
        return ro.toString();
    }
}

