/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.appstore.web;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.bpms.commons.appstore.model.APIData;
import com.actionsoft.bpms.commons.appstore.util.AppStoreHttpRequestUtil;
import com.actionsoft.bpms.commons.appstore.util.AppStoreJsonUtil;
import com.actionsoft.bpms.commons.appstore.util.AppStoreURLCreateUtil;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UtilSerialize;
import com.actionsoft.exception.AppStoreException;

public class AppStoreLoginWeb
extends ActionWeb {
    public AppStoreLoginWeb(UserContext userContext) {
        super(userContext);
    }

    public String userLogin(String uid, String pwd) {
        String responseStr;
        String url = AppStoreURLCreateUtil.getStoreLoginUrl(uid, pwd);
        try {
            responseStr = AppStoreHttpRequestUtil.doGet(url, null);
            APIData apiData = (APIData)AppStoreJsonUtil.getObject4JsonString(responseStr, APIData.class);
            apiData.getData().put("storehosturl", AppPlatformConfig.getAppStoreHost());
            responseStr = AppStoreJsonUtil.getJsonString4JavaPOJO(apiData);
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            responseStr = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        catch (Exception e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u5f02\u5e38");
            responseStr = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
        }
        return responseStr;
    }

    public String userLogin() {
        String responseStr;
        String uid = "user@awspaas.com";
        String pwd = "awspaas";
        String url = AppStoreURLCreateUtil.getStoreLoginUrl(uid, new MD5().toDigest(pwd));
        try {
            responseStr = AppStoreHttpRequestUtil.doGet(url, null);
            APIData apiData = (APIData)AppStoreJsonUtil.getObject4JsonString(responseStr, APIData.class);
            apiData.getData().put("storehosturl", AppPlatformConfig.getAppStoreHost());
            responseStr = AppStoreJsonUtil.getJsonString4JavaPOJO(apiData);
        }
        catch (AppStoreException e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg(e.getMessage());
            String responseStr2 = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
            ResponseObject ro = ResponseObject.newErrResponse();
            ro.put("dataMsg", UtilSerialize.parseObject(responseStr2));
            return ro.toString();
        }
        catch (Exception e) {
            APIData apdata = new APIData();
            apdata.setResult("error");
            apdata.setMsg("\u7cfb\u7edf\u5f02\u5e38");
            String responseStr3 = AppStoreJsonUtil.getJsonString4JavaPOJO(apdata);
            ResponseObject ro = ResponseObject.newErrResponse();
            ro.put("dataMsg", UtilSerialize.parseObject(responseStr3));
            return ro.toString();
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        ro.put("dataMsg", UtilSerialize.parseObject(responseStr));
        ro.put("uid", uid);
        ro.put("pwd", pwd);
        return ro.toString();
    }

    public String checkService() {
        APIData apiData = new APIData();
        try {
            apiData.setResult("ok");
            apiData.getData().put("service", AppPlatformConfig.isAppStoreService());
            apiData.getData().put("updateCheck", AppPlatformConfig.isAppUpdateCheck());
            apiData.getData().put("storeName", AppPlatformConfig.getAppStoreName());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            apiData.setResult("error");
            apiData.setMsg(e.getMessage());
        }
        return AppStoreJsonUtil.getJsonString4JavaPOJO(apiData);
    }
}

