/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ActivityModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.at.EXPParser;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.commons.at.ExpressionContextImpl;
import com.actionsoft.bpms.commons.at.ExpressionInterface;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSExpressionException;

public abstract class AbstExpression
implements ExpressionInterface {
    private String _expressionValue = "";
    private ExpressionContext _atContext;
    private static final String SIGN = "_MACROS%C1%F5%BD%F0%D6%F9MACROS_";

    public AbstExpression(ExpressionContext atContext, String expressionValue) {
        this._expressionValue = expressionValue;
        this._atContext = atContext;
        ((ExpressionContextImpl)this._atContext).setExpression(expressionValue);
    }

    @Override
    public abstract String execute(String var1) throws AWSExpressionException;

    public ExpressionContext getExpressionContext() {
        return this._atContext;
    }

    public String getParameter(String str, int index) {
        if (str.indexOf("(") == -1 || str.indexOf(")") == -1) {
            return "";
        }
        str = new UtilString(str).replace("\\,", SIGN);
        String strLine = str.substring(str.indexOf("(") + 1, str.lastIndexOf(")"));
        String param = "";
        int i = 1;
        while (i <= index) {
            param = this.findParameter(strLine);
            if (strLine.length() == param.length()) {
                if (i >= index) break;
                param = "";
                break;
            }
            strLine = strLine.substring(param.length() + 1);
            ++i;
        }
        if (param.indexOf("@") > -1) {
            param = EXPParser.executeRule(param, this._atContext);
        }
        char[] cs = param.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < cs.length) {
            if (cs[i2] == '\\') {
                sb.append(cs[++i2]);
            } else {
                sb.append(cs[i2]);
            }
            ++i2;
        }
        param = sb.toString();
        return new UtilString(param).replace(SIGN, ",");
    }

    private String findParameter(String strLine) {
        String param = "";
        int subFunction = 0;
        int i = 0;
        while (i < strLine.length()) {
            char c = strLine.charAt(i);
            if (c == '\\') {
                param = String.valueOf(param) + c + strLine.charAt(++i);
            } else {
                if (c == '(') {
                    ++subFunction;
                } else if (c == ')') {
                    --subFunction;
                }
                if (subFunction == 0 && c == ',') break;
                param = String.valueOf(param) + c;
            }
            ++i;
        }
        return param;
    }

    public boolean isTrue(String str) {
        return (str = str.toUpperCase()).equals("TRUE") || str.equals("ON") || str.equals("1") || str.equals("YES") || str.equals("\u662f");
    }

    public boolean isFalse(String str) {
        return (str = str.toUpperCase()).equals("FALSE") || str.equals("OFF") || str.equals("0") || str.equals("NO") || str.equals("\u5426");
    }

    public void issueWarnLog(String msg) {
        ProcessInstance processInst = this.getExpressionContext().getProcessInstance();
        if (processInst != null) {
            String defId = processInst.getProcessDefId();
            ProcessDefinition def = (ProcessDefinition)ProcessDefCache.getInstance().getModel(defId);
            if (def != null) {
                String appId = def.getAppId();
                AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
                if (app != null) {
                    String ctxInfo = String.valueOf(this._expressionValue) + "\r\n";
                    ctxInfo = String.valueOf(ctxInfo) + msg + "\r\n\r\n";
                    if (this.getExpressionContext().getUserContext() != null) {
                        ctxInfo = String.valueOf(ctxInfo) + "operator:" + this.getExpressionContext().getUserContext().getUserName() + "\r\n";
                    }
                    ctxInfo = String.valueOf(ctxInfo) + "processName:" + def.getName() + "\r\n";
                    ctxInfo = String.valueOf(ctxInfo) + "processInstId:" + processInst.getId() + "\r\n";
                    ActivityModel activity = (ActivityModel)this.getExpressionContext().getActivityModel();
                    if (activity != null) {
                        ctxInfo = String.valueOf(ctxInfo) + "activityName:" + activity.getName() + "\r\n";
                    }
                    AppsLogger.warn((AppContext)app, (String)ctxInfo);
                }
            }
        }
    }
}

