/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at;

import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.commons.at.ExpressionInterface;
import com.actionsoft.bpms.commons.at.ExpressionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class EXPParser {
    public static final String ERROR = "[Formula Error]";
    private static List<String> SYNTAXLIST = new ArrayList<String>();

    protected static void putSyntaxKey(String key) {
        SYNTAXLIST.add(key);
        Collections.sort(SYNTAXLIST, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).length() - ((String)o1).length();
            }
        });
    }

    protected static void removeSyntaxKey(String key) {
        SYNTAXLIST.remove(key);
        Collections.sort(SYNTAXLIST, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).length() - ((String)o1).length();
            }
        });
    }

    protected static String executeRule(String str, ExpressionContext atContext) {
        StringBuilder sb = new StringBuilder();
        int s = EXPParser.parseRuleStart(str, -1);
        int ae = 0;
        while (s != -1) {
            int ruleStart = str.lastIndexOf(64, s);
            int ruleEnd = EXPParser.parseRuleEnd(str, s);
            if (ruleEnd == -1) break;
            String formula = str.substring(ruleStart, ruleEnd);
            sb.append(String.valueOf(str.substring(ae, ruleStart)) + EXPParser.getFormulaValue(formula, atContext));
            ae = ruleEnd;
            s = EXPParser.parseRuleStart(str, ruleEnd);
        }
        sb.append(str.substring(ae));
        return sb.toString();
    }

    private static String getFormulaValue(String formula, ExpressionContext atContext) {
        String oldFormula = formula;
        ExpressionInterface expression = ExpressionManager.getInstance(atContext, formula.toLowerCase());
        String result = expression.execute(formula);
        return formula.equals(result) ? oldFormula : result;
    }

    private static int parseRuleEnd(String exp, int s) {
        if (exp.length() == s + 1) {
            return s + 1;
        }
        if (exp.charAt(s + 1) != '(') {
            return s + 1;
        }
        int left = 1;
        int i = s + 2;
        while (i < exp.length()) {
            if (exp.charAt(i) == '\\') {
                ++i;
            } else {
                if (exp.charAt(i) == ')' && --left == 0) {
                    return i + 1;
                }
                if (exp.charAt(i) == '(') {
                    ++left;
                }
            }
            ++i;
        }
        return -1;
    }

    private static int parseRuleStart(String exp, int start) {
        int s = exp.indexOf(64, start);
        if (s != -1) {
            for (String pre : SYNTAXLIST) {
                if (!exp.toLowerCase().startsWith(pre, s)) continue;
                return s + pre.length() - 1;
            }
            return EXPParser.parseRuleStart(exp, s + 1);
        }
        return -1;
    }
}

