/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.AtFormulaPluginProfile;
import com.actionsoft.bpms.commons.at.ConfigExpressionModel;
import com.actionsoft.bpms.commons.at.EXPParser;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.commons.at.ExpressionInterface;
import com.actionsoft.bpms.commons.at.impl.NoneExpressionImpl;
import com.actionsoft.bpms.util.ClassReflect;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExpressionManager {
    private static LinkedHashMap<String, ConfigExpressionModel> _atList = new LinkedHashMap();

    public static ExpressionInterface getInstance(ExpressionContext atContext, String value) {
        String tempvalue = value.substring(value.indexOf("@") + 1, value.length());
        ConfigExpressionModel configExpressionModel = _atList.get(tempvalue);
        if (configExpressionModel != null) {
            Constructor<ExpressionInterface> cons = null;
            try {
                cons = configExpressionModel.getCons();
                if (cons != null) {
                    Object[] params = new Object[]{atContext, value};
                    ExpressionInterface at = cons.newInstance(params);
                    return at;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            String tempvalue2 = "";
            if (value.indexOf("(") != -1) {
                tempvalue2 = value.substring(value.indexOf("@") + 1, value.indexOf("(", value.indexOf("@")));
            } else if (value.indexOf("<") != -1) {
                tempvalue2 = value.substring(value.indexOf("@") + 1, value.indexOf("<"));
            }
            configExpressionModel = _atList.get(tempvalue2);
            if (configExpressionModel != null) {
                Constructor<ExpressionInterface> cons = null;
                try {
                    cons = configExpressionModel.getCons();
                    if (cons != null) {
                        Object[] params = new Object[]{atContext, value};
                        ExpressionInterface at = cons.newInstance(params);
                        return at;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            } else {
                return new NoneExpressionImpl(atContext, value);
            }
        }
        return new NoneExpressionImpl(atContext, value);
    }

    public static Map<String, ConfigExpressionModel> getAtList() {
        return _atList;
    }

    public static List<String> getGroupList() {
        ArrayList<String> groups = new ArrayList<String>();
        for (ConfigExpressionModel atModel : _atList.values()) {
            if (groups.contains(atModel.getGroupName())) continue;
            groups.add(atModel.getGroupName());
        }
        return groups;
    }

    public static List<ConfigExpressionModel> getListByGroup(String groupName) {
        ArrayList<ConfigExpressionModel> list = new ArrayList<ConfigExpressionModel>();
        for (ConfigExpressionModel atModel : _atList.values()) {
            if (!groupName.equalsIgnoreCase(atModel.getGroupName())) continue;
            list.add(atModel);
        }
        return list;
    }

    public static boolean registerPlugin(AppContext app, AtFormulaPluginProfile plugin) {
        ConfigExpressionModel atModel = new ConfigExpressionModel();
        atModel.setAppContext(plugin.getAppContext());
        atModel.setDesc(plugin.getDesc());
        atModel.setId(plugin.getId());
        atModel.setGroupName(plugin.getGroupName());
        atModel.setImplementsClass(plugin.getClazzName());
        atModel.setSyntax(plugin.getSyntax());
        atModel.setTitle(plugin.getTitle());
        atModel.setContextNeed(plugin.getContextNeed());
        Class[] parameterTypes = new Class[]{ExpressionContext.class, String.class};
        Constructor cons = null;
        try {
            cons = ClassReflect.getConstructor(atModel.getImplementsClass(), parameterTypes, app);
        }
        catch (Exception e) {
            AppsLogger.err((AppContext)plugin.getAppContext(), (String)("@\u516c\u5f0f\u5b9e\u73b0\u7c7b\u52a0\u8f7d\u5f02\u5e38[" + atModel.getImplementsClass() + "][" + e.toString() + "]"), (String)"\u68c0\u67e5\u9519\u8bef\u65e5\u5fd7", (Exception)e);
            e.printStackTrace(System.err);
            return false;
        }
        atModel.setCons(cons);
        if (cons == null && !atModel.getImplementsClass().equals("")) {
            AppsLogger.err((AppContext)plugin.getAppContext(), (String)("@\u516c\u5f0f\u52a0\u8f7d\u53d1\u751f\u672a\u77e5\u5f02\u5e38[" + atModel.getImplementsClass() + "]"));
            return false;
        }
        _atList.put(atModel.getId().toLowerCase(), atModel);
        EXPParser.putSyntaxKey(ExpressionManager.getSyntaxKey(atModel.getSyntax()));
        return true;
    }

    public static boolean destoryPlugin(AppContext app, AtFormulaPluginProfile plugin) {
        _atList.remove(plugin.getId().toLowerCase());
        EXPParser.removeSyntaxKey(ExpressionManager.getSyntaxKey(plugin.getSyntax()));
        return true;
    }

    private static String getSyntaxKey(String str) {
        int param = str.indexOf(40);
        str = (param != -1 ? str.substring(0, param) : str).toLowerCase();
        str = str.trim();
        return str;
    }
}

