/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.app;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.RequestContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.actionsoft.sdk.local.SDK;

public class PropertyExpression
extends AbstExpression {
    public PropertyExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String name = this.getParameter(expression, 1).trim();
        String appId = this.getParameter(expression, 2).trim();
        if (UtilString.isEmpty(appId) || "appId".equals(appId)) {
            appId = this.getAppId();
        }
        try {
            return SDK.getRuleAPI().executeAtScript(SDK.getAppAPI().getProperty(appId, name), this.getExpressionContext());
        }
        catch (AWSException e) {
            return "";
        }
    }

    private String getAppId() {
        ExpressionContext ec = this.getExpressionContext();
        if (ec != null && ec.getProcessDefinition() != null) {
            return ec.getProcessDefinition().getAppId();
        }
        RequestContext r = DispatcherRequest.getContext();
        if (r != null) {
            return r.getAppContext().getId();
        }
        return "";
    }
}

