/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.date;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.util.UtilDate;
import java.util.Calendar;
import java.util.Date;

public class Date2ChineseExpression
extends AbstExpression {
    public Date2ChineseExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String date = this.getParameter(expression, 1).trim();
        return Date2ChineseExpression.date2Upper(new Date(UtilDate.getTimes(date)));
    }

    private static String date2Upper(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        int year = ca.get(1);
        int month = ca.get(2) + 1;
        int day = ca.get(5);
        return String.valueOf(Date2ChineseExpression.numToUpper(year)) + "\u5e74" + Date2ChineseExpression.monthToUppder(month) + "\u6708" + Date2ChineseExpression.dayToUppder(day) + "\u65e5";
    }

    private static String numToUpper(int num) {
        String[] u = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        char[] str = String.valueOf(num).toCharArray();
        String rstr = "";
        int i = 0;
        while (i < str.length) {
            rstr = String.valueOf(rstr) + u[Integer.parseInt(String.valueOf(str[i]))];
            ++i;
        }
        return rstr;
    }

    private static String monthToUppder(int month) {
        if (month < 10) {
            return Date2ChineseExpression.numToUpper(month);
        }
        if (month == 10) {
            return "\u5341";
        }
        return "\u5341" + Date2ChineseExpression.numToUpper(month - 10);
    }

    private static String dayToUppder(int day) {
        if (day < 20) {
            return Date2ChineseExpression.monthToUppder(day);
        }
        char[] str = String.valueOf(day).toCharArray();
        if (str[1] == '0') {
            return String.valueOf(Date2ChineseExpression.numToUpper(Integer.parseInt(String.valueOf(str[0])))) + "\u5341";
        }
        return String.valueOf(Date2ChineseExpression.numToUpper(Integer.parseInt(String.valueOf(str[0])))) + "\u5341" + Date2ChineseExpression.numToUpper(Integer.parseInt(String.valueOf(str[1])));
    }
}

