/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.date;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.util.UtilDate;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class PreDateExpression
extends AbstExpression {
    public PreDateExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String date = this.getParameter(expression, 1).trim();
        if (date == null || date.trim().length() == 0) {
            Calendar calendar = UtilDate.getCalendar();
            calendar.set(6, calendar.get(6) - 1);
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd");
            return datetimeFormat.format(calendar.getTime());
        }
        Calendar calendar = UtilDate.getCalendar(date);
        if (calendar == null) {
            return "";
        }
        calendar.set(6, calendar.get(6) - 1);
        if (date.indexOf(":") > -1) {
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return datetimeFormat.format(calendar.getTime());
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd");
        return datetimeFormat.format(calendar.getTime());
    }
}

