/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.db;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserMapModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import java.util.List;

public class SqlClauseOfManagerExpression
extends AbstExpression {
    public SqlClauseOfManagerExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String fieldName = this.getParameter(expression, 1);
        String isSubDepartment = this.getParameter(expression, 2);
        if (UtilString.isEmpty(fieldName)) {
            this.issueWarnLog("Context initialization failed, fieldName is null!");
            return "";
        }
        UserContext me = this.getExpressionContext().getUserContext();
        if (me == null) {
            this.issueWarnLog("Context initialization failed, UserContext is null!");
            return "";
        }
        if (UtilString.isEmpty(isSubDepartment)) {
            isSubDepartment = "false";
        }
        StringBuilder sqlClause = new StringBuilder();
        UserModel userModel = me.getUserModel();
        if (userModel.isManager()) {
            if (sqlClause.length() > 0) {
                sqlClause.append(" OR ");
            }
            sqlClause.append(fieldName).append("='").append(userModel.getDepartmentId()).append("'");
            if (this.isTrue(isSubDepartment)) {
                this.fetchDept(sqlClause, userModel.getDepartmentId(), fieldName);
            }
        }
        List mapList = UserMapCache.getMapListOfUser((String)userModel.getUID());
        int i = 0;
        while (i < mapList.size()) {
            UserMapModel mapModel = (UserMapModel)mapList.get(i);
            if (mapModel.isManager()) {
                if (sqlClause.length() > 0) {
                    sqlClause.append(" OR ");
                }
                sqlClause.append(fieldName).append("='").append(mapModel.getDepartmentId()).append("'");
                this.fetchDept(sqlClause, mapModel.getDepartmentId(), fieldName);
            }
            ++i;
        }
        if (sqlClause.length() > 0) {
            sqlClause.insert(0, "(").append(")");
        }
        return sqlClause.toString();
    }

    private void fetchDept(StringBuilder sqlClause, String departmentId, String fieldName) {
        if (DepartmentCache.isExistSubModel((String)departmentId)) {
            List subList = DepartmentCache.getSubDepartments((String)departmentId);
            int i = 0;
            while (i < subList.size()) {
                DepartmentModel departmentModel = (DepartmentModel)subList.get(i);
                if (sqlClause.length() > 0) {
                    sqlClause.append(" OR ");
                }
                sqlClause.append(fieldName).append("='").append(departmentModel.getId()).append("'");
                this.fetchDept(sqlClause, departmentModel.getId(), fieldName);
                ++i;
            }
        }
    }
}

