/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.db;

import com.actionsoft.bpms.cc.Adapter;
import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlSetExpression
extends AbstExpression {
    public SqlSetExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String sql = this.getParameter(expression, 1).trim();
        String separator = this.getParameter(expression, 2);
        String cc = this.getParameter(expression, 3).trim();
        if (UtilString.isEmpty(sql)) {
            this.issueWarnLog("Context initialization failed, sql is null!");
            return "";
        }
        if (!sql.toLowerCase().startsWith("select ")) {
            this.issueWarnLog("Context initialization failed, sql was invalidated!");
            return "";
        }
        Connection conn = null;
        Adapter.DB jdbc = null;
        try {
            if (UtilString.isEmpty(cc)) {
                conn = DBSql.open();
            } else {
                jdbc = Adapter.DB.binding((String)cc);
                conn = jdbc.open();
            }
            List<String> list = DBSql.query(conn, sql, new Mapper(), new Object[0]);
            if (list == null) {
                return "";
            }
            if (separator == null || separator.length() == 0) {
                separator = ",";
            }
            String string = UtilString.join(list, separator);
            return string;
        }
        catch (Exception e) {
            System.err.println("Exception @sqlSet(" + sql + ")");
            this.issueWarnLog("Exception @sqlSet(" + sql + ")");
            return "";
        }
        finally {
            if (UtilString.isEmpty(cc)) {
                DBSql.close(conn);
            } else {
                Adapter.DB.close((Connection)conn);
            }
        }
    }

    private class Mapper
    implements RowMapper<String> {
        private Mapper() {
        }

        public String mapRow(ResultSet rset, int rowNum) throws SQLException {
            try {
                return rset.getString(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
    }
}

