/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.form;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.util.Map;

public class FormExpression
extends AbstExpression {
    public static final String CURRENT_DATA = "currentDATA";

    public FormExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        Map<String, Object> ext;
        String boName = this.getParameter(expression, 1).toUpperCase().trim();
        String fieldName = this.getParameter(expression, 2).toUpperCase().trim();
        String processInstId = this.getParameter(expression, 3).trim();
        if (UtilString.isEmpty(boName)) {
            this.issueWarnLog("Context initialization failed, boName is null!");
            return "";
        }
        if (UtilString.isEmpty(fieldName)) {
            this.issueWarnLog("Context initialization failed, fieldName is null!");
            return "";
        }
        ProcessInstance processInst = this.getExpressionContext().getProcessInstance();
        if (processInst == null && UtilString.isEmpty(processInstId)) {
            this.issueWarnLog("Context initialization failed, processInstId is null!");
            return "";
        }
        if (UtilString.isEmpty(processInstId)) {
            processInstId = processInst.getId();
        }
        if ((ext = this.getExpressionContext().getExtParam()) != null && ext.containsKey(CURRENT_DATA)) {
            Map current = (Map)ext.get(CURRENT_DATA);
            return String.valueOf(current.get(fieldName));
        }
        BO bo = SDK.getBOAPI().query(boName).detailByBindId(processInstId);
        String value = null;
        if (bo != null) {
            value = (String)bo.get(fieldName, String.class);
        }
        return value == null ? "" : value;
    }
}

