/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.form;

import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilNumber;
import com.actionsoft.bpms.util.UtilString;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public final class GridHelper {
    public static String VALUE_TYPE_FIRST = "first";
    public static String VALUE_TYPE_LAST = "last";
    public static String VALUE_TYPE_SUM = "sum";
    public static String VALUE_TYPE_AVG = "avg";
    public static String VALUE_TYPE_MAX = "max";
    public static String VALUE_TYPE_MIN = "min";
    public static String VALUE_TYPE_COUNT = "count";
    public static String VALUE_TYPE_SET = "set";
    private static GridHelper helper = new GridHelper();

    private GridHelper() {
    }

    public static GridHelper getInstance() {
        return helper;
    }

    public String rowValue(BOModel metaDataModel, BOItemModel boItemModel, String valueType, String sqlClause, String processInstId, String boId) {
        String rowValue = "";
        if (!UtilString.isEmpty(sqlClause)) {
            sqlClause = " AND (" + sqlClause + ") ";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("BINDID", processInstId);
        if (valueType.equalsIgnoreCase(VALUE_TYPE_FIRST)) {
            String sql = "SELECT " + boItemModel.getName() + " FROM " + metaDataModel.getName() + " WHERE BINDID=:BINDID " + sqlClause + " ORDER BY CREATEDATE ASC";
            rowValue = this.typeValue(metaDataModel, boItemModel, sql, boItemModel.getName(), param);
        } else if (valueType.equalsIgnoreCase(VALUE_TYPE_LAST)) {
            String sql = "SELECT " + boItemModel.getName() + " FROM " + metaDataModel.getName() + " WHERE BINDID=:BINDID " + sqlClause + " ORDER BY CREATEDATE DESC";
            rowValue = this.typeValue(metaDataModel, boItemModel, sql, boItemModel.getName(), param);
        } else if (valueType.equalsIgnoreCase(VALUE_TYPE_COUNT)) {
            String sql = "SELECT COUNT(ID) AS C FROM " + metaDataModel.getName() + " WHERE BINDID=:BINDID " + sqlClause;
            rowValue = Long.toString(DBSql.getLong(sql, "C", param));
        } else if (valueType.equalsIgnoreCase(VALUE_TYPE_SUM)) {
            String sql = "SELECT SUM(" + boItemModel.getName() + ") AS S FROM " + metaDataModel.getName() + " WHERE BINDID=:BINDID " + sqlClause;
            rowValue = GridHelper.getValue(sql, "S", boItemModel, param);
        } else if (valueType.equalsIgnoreCase(VALUE_TYPE_AVG)) {
            String sql = "SELECT AVG(" + boItemModel.getName() + ") AS A FROM " + metaDataModel.getName() + " WHERE BINDID=:BINDID " + sqlClause;
            rowValue = GridHelper.getValue(sql, "A", boItemModel, param);
        } else if (valueType.equalsIgnoreCase(VALUE_TYPE_MAX)) {
            String sql = "SELECT MAX(" + boItemModel.getName() + ") AS M FROM " + metaDataModel.getName() + " WHERE BINDID=:BINDID " + sqlClause;
            rowValue = this.typeValue(metaDataModel, boItemModel, sql, "M", param);
        } else if (valueType.equalsIgnoreCase(VALUE_TYPE_MIN)) {
            String sql = "SELECT MIN(" + boItemModel.getName() + ") AS M FROM " + metaDataModel.getName() + " WHERE BINDID=:BINDID " + sqlClause;
            rowValue = this.typeValue(metaDataModel, boItemModel, sql, "M", param);
        }
        return rowValue == null ? "" : rowValue;
    }

    private static String getValue(String sql, String field, BOItemModel boItemModel, Map<String, Object> param) {
        int point = GridHelper.getPoint(boItemModel);
        if (point == 0) {
            return Long.toString(DBSql.getLong(sql, field, param));
        }
        double num = DBSql.getDouble(sql, field, param);
        BigDecimal bigDecimal = new BigDecimal(num);
        return UtilNumber.fixPoint(bigDecimal.toString(), point);
    }

    private static int getPoint(BOItemModel boItemModel) {
        String len = boItemModel.getLength();
        int point = 0;
        if (len.indexOf(",") > -1) {
            String p = len.substring(len.indexOf(",") + 1);
            try {
                point = Integer.parseInt(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return point;
    }

    private String typeValue(BOModel metaDataModel, BOItemModel boItemModel, String sql, String fn, Map<String, Object> param) {
        String rowValue = null;
        if (boItemModel.getColumnType().equals("DATE")) {
            rowValue = UtilDate.dateFormat(DBSql.getTimestamp(sql, fn, param));
        } else if (boItemModel.getColumnType().equals("DATE") && boItemModel.getComponentId().equals("AWSUI.DateTime")) {
            rowValue = UtilDate.datetimeFormat(DBSql.getTimestamp(sql, fn, param));
        } else if (boItemModel.getColumnType().equals("NUMBER")) {
            rowValue = DBSql.getString(sql, fn, param);
            if (UtilString.isEmpty(rowValue)) {
                rowValue = "0";
            }
        } else {
            rowValue = DBSql.getString(sql, fn, param);
        }
        return rowValue;
    }
}

