/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.org;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.commons.at.impl.org.OrgContextHelper;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserMapModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DepartmentManagerExpression
extends AbstExpression {
    public DepartmentManagerExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String isIgnoreMe = this.getParameter(expression, 1).trim();
        String contextType = this.getParameter(expression, 2).trim();
        String contextId = this.getParameter(expression, 3).trim();
        DepartmentModel department = OrgContextHelper.getInstance().getDepartment(this.getExpressionContext(), contextType, contextId);
        if (department != null) {
            HashSet<String> ms = new HashSet<String>();
            this.queryManagers(ms, department.getId(), isIgnoreMe);
            return UtilString.join(ms, " ");
        }
        this.issueWarnLog("Not find! contextType[" + contextType + "],contextId[" + contextId + "]");
        return "";
    }

    private void queryManagers(Collection<String> ms, String departmentId, String isIgnoreMe) {
        DepartmentModel d;
        UserContext me = this.getExpressionContext().getUserContext();
        List list = SDK.getORGAPI().getManagersByDepartment(departmentId);
        boolean isIgnore = false;
        if (!UtilString.isEmpty(isIgnoreMe) && this.isTrue(isIgnoreMe)) {
            isIgnore = true;
            if (me == null) {
                this.issueWarnLog("Context initialization failed, UserContext object is null!");
                return;
            }
        }
        for (UserModel user : list) {
            if (isIgnore && user.getUID().equals(me.getUID())) continue;
            ms.add(user.getUID());
        }
        List users = UserMapCache.getMapListOfDepartment((String)departmentId);
        if (users != null) {
            for (UserMapModel u : users) {
                if (!u.isManager() || isIgnore && u.getUID().equals(me.getUID())) continue;
                ms.add(u.getUID());
            }
        }
        if (ms.isEmpty() && (d = DepartmentCache.getModel((String)departmentId)) != null && !d.isRoot()) {
            this.queryManagers(ms, d.getParentDepartmentId(), isIgnoreMe);
        }
    }
}

