/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.org;

import com.actionsoft.bpms.bpmn.engine.dao.ProcessRuntimeDaoFactory;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.TaskInstance;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.org.cache.CompanyCache;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSExpressionException;

public final class OrgContextHelper {
    private static OrgContextHelper helper = new OrgContextHelper();
    public static String CONTEXT_TYPE_ORG = "org";
    public static String CONTEXT_TYPE_PROCESS = "process";
    public static String CONTEXT_TYPE_TASKOWNER = "taskOwner";
    public static String CONTEXT_TYPE_TASKTARGET = "taskTarget";

    private OrgContextHelper() {
    }

    public static OrgContextHelper getInstance() {
        return helper;
    }

    public CompanyModel getCompany(ExpressionContext context, String contextType, String contextId) throws AWSExpressionException {
        if (UtilString.isEmpty(contextType)) {
            contextType = CONTEXT_TYPE_ORG;
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_PROCESS)) {
            if (UtilString.isEmpty(contextId)) {
                ProcessInstance processInst = context.getProcessInstance();
                if (processInst == null) {
                    return null;
                }
                return CompanyCache.getModel((String)processInst.getCreateUserOrgId());
            }
            ProcessInstance processInst = ProcessRuntimeDaoFactory.createProcessInstance().getInstance(contextId);
            if (processInst == null) {
                return null;
            }
            return CompanyCache.getModel((String)processInst.getCreateUserOrgId());
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_TASKOWNER)) {
            if (UtilString.isEmpty(contextId)) {
                TaskInstance taskInst = context.getTaskInstance();
                if (taskInst == null) {
                    return null;
                }
                DepartmentModel deptModel = DepartmentCache.getModel((String)taskInst.getOwnerDepartmentId());
                if (deptModel != null) {
                    return CompanyCache.getModel((String)deptModel.getCompanyId());
                }
            } else {
                TaskInstance taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(contextId);
                if (taskInst == null) {
                    return null;
                }
                DepartmentModel deptModel = DepartmentCache.getModel((String)taskInst.getOwnerDepartmentId());
                if (deptModel != null) {
                    return CompanyCache.getModel((String)deptModel.getCompanyId());
                }
            }
        } else {
            if (contextType.equalsIgnoreCase(CONTEXT_TYPE_TASKTARGET)) {
                if (UtilString.isEmpty(contextId)) {
                    TaskInstance taskInst = context.getTaskInstance();
                    if (taskInst == null) {
                        return null;
                    }
                    return CompanyCache.getModel((String)taskInst.getTargetCompanyId());
                }
                TaskInstance taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(contextId);
                if (taskInst == null) {
                    return null;
                }
                return CompanyCache.getModel((String)taskInst.getTargetCompanyId());
            }
            if (contextType.equalsIgnoreCase(CONTEXT_TYPE_ORG)) {
                if (UtilString.isEmpty(contextId)) {
                    UserContext user = context.getUserContext();
                    if (user == null) {
                        return null;
                    }
                    return user.getCompanyModel();
                }
                return CompanyCache.getModel((String)contextId);
            }
        }
        return null;
    }

    public DepartmentModel getDepartment(ExpressionContext context, String contextType, String contextId) throws AWSExpressionException {
        if (UtilString.isEmpty(contextType)) {
            contextType = CONTEXT_TYPE_ORG;
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_PROCESS)) {
            if (UtilString.isEmpty(contextId)) {
                ProcessInstance processInst = context.getProcessInstance();
                if (processInst == null) {
                    return null;
                }
                return DepartmentCache.getModel((String)processInst.getCreateUserDeptId());
            }
            ProcessInstance processInst = ProcessRuntimeDaoFactory.createProcessInstance().getInstance(contextId);
            if (processInst == null) {
                return null;
            }
            return DepartmentCache.getModel((String)processInst.getCreateUserDeptId());
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_TASKOWNER)) {
            if (UtilString.isEmpty(contextId)) {
                TaskInstance taskInst = context.getTaskInstance();
                if (taskInst == null) {
                    return null;
                }
                return DepartmentCache.getModel((String)taskInst.getOwnerDepartmentId());
            }
            TaskInstance taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(contextId);
            if (taskInst == null) {
                return null;
            }
            return DepartmentCache.getModel((String)taskInst.getOwnerDepartmentId());
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_TASKTARGET)) {
            if (UtilString.isEmpty(contextId)) {
                TaskInstance taskInst = context.getTaskInstance();
                if (taskInst == null) {
                    return null;
                }
                return DepartmentCache.getModel((String)taskInst.getTargetDepartmentId());
            }
            TaskInstance taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(contextId);
            if (taskInst == null) {
                return null;
            }
            return DepartmentCache.getModel((String)taskInst.getTargetDepartmentId());
        }
        if (UtilString.isEmpty(contextId)) {
            UserContext user = context.getUserContext();
            if (user == null) {
                return null;
            }
            return user.getDepartmentModel();
        }
        return DepartmentCache.getModel((String)contextId);
    }

    public RoleModel getRole(ExpressionContext context, String contextType, String contextId) throws AWSExpressionException {
        if (UtilString.isEmpty(contextType)) {
            contextType = CONTEXT_TYPE_ORG;
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_PROCESS)) {
            if (UtilString.isEmpty(contextId)) {
                ProcessInstance processInst = context.getProcessInstance();
                if (processInst == null) {
                    return null;
                }
                return RoleCache.getModel((String)processInst.getCreateUserRoleId());
            }
            ProcessInstance processInst = ProcessRuntimeDaoFactory.createProcessInstance().getInstance(contextId);
            if (processInst == null) {
                return null;
            }
            return RoleCache.getModel((String)processInst.getCreateUserRoleId());
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_TASKOWNER)) {
            if (UtilString.isEmpty(contextId)) {
                TaskInstance taskInst = context.getTaskInstance();
                if (taskInst == null) {
                    return null;
                }
                if (taskInst.isRoot()) {
                    return RoleCache.getModel((String)taskInst.getTargetRoleId());
                }
                taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(taskInst.getParentTaskInstId());
                if (taskInst == null) {
                    return null;
                }
                return RoleCache.getModel((String)taskInst.getTargetRoleId());
            }
            TaskInstance taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(contextId);
            if (taskInst == null) {
                return null;
            }
            if (taskInst.isRoot()) {
                return RoleCache.getModel((String)taskInst.getTargetRoleId());
            }
            taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(taskInst.getParentTaskInstId());
            if (taskInst == null) {
                return null;
            }
            return RoleCache.getModel((String)taskInst.getTargetRoleId());
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_TASKTARGET)) {
            if (UtilString.isEmpty(contextId)) {
                TaskInstance taskInst = context.getTaskInstance();
                if (taskInst == null) {
                    return null;
                }
                return RoleCache.getModel((String)taskInst.getTargetRoleId());
            }
            TaskInstance taskInst = ProcessRuntimeDaoFactory.createTaskInstance().getInstance(contextId);
            if (taskInst == null) {
                return null;
            }
            return RoleCache.getModel((String)taskInst.getTargetRoleId());
        }
        if (UtilString.isEmpty(contextId)) {
            UserContext user = context.getUserContext();
            if (user == null) {
                return null;
            }
            return user.getRoleModel();
        }
        return RoleCache.getModel((String)contextId);
    }
}

