/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.org;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.util.UtilSerialize;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;

public class UserExpression
extends AbstExpression {
    public UserExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String key = this.getParameter(expression, 1).trim();
        String uidAliasName = this.getParameter(expression, 2).trim();
        String delimiter = this.getParameter(expression, 3).trim();
        if (UtilString.isEmpty(uidAliasName)) {
            if (this.getExpressionContext().getUserContext() == null) {
                this.issueWarnLog("Context initialization failed, UserContext object is null!");
                return "";
            }
            UserModel userModel = this.getExpressionContext().getUserContext().getUserModel();
            return this.getUserInfo(userModel, key);
        }
        if (UtilString.isEmpty(delimiter)) {
            delimiter = " ";
        }
        List list = SDK.getORGAPI().getUsersByUIDs(uidAliasName);
        StringBuilder sb = new StringBuilder();
        for (UserModel user : list) {
            sb.append(String.valueOf(this.getUserInfo(user, key)) + delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    private String getUserInfo(UserModel userModel, String key) {
        if (UtilString.isEmpty(key)) {
            key = "uID;cacheLoginFailTimes;cachePauseTime;closed;departmentId;email;ext1;ext2;ext3;ext4;ext5;manager;mobile;officeFax;officeTel;orderIndex;outerId;password;photoLastModified;positionLayer;positionName;positionNo;preSpell;reportTo;roleId;sessionTime;singleLogin;uniqueId;userIp;userName;userNameAlias;userNo;wechat;workStatus;workcanlendar;";
        }
        JSONObject json = JSON.parseObject((String)UtilSerialize.toJSONString(userModel));
        if (key.indexOf(";") == -1) {
            return json.containsKey((Object)key) ? json.getString(key) : "";
        }
        String[] arr = key.split(";");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arr.length) {
            if (json.containsKey((Object)arr[i])) {
                sb.append(json.getString(arr[i])).append(";");
            }
            ++i;
        }
        if (sb.toString().endsWith(";")) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

