/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.org;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.util.UtilString;
import java.util.ArrayList;
import java.util.List;

public class UserManagerByUIDExpression
extends AbstExpression {
    public UserManagerByUIDExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String includeSelf;
        String delimiter;
        String type;
        String uid = this.getParameter(expression, 1).trim();
        if (UtilString.isEmpty(uid)) {
            uid = this.getExpressionContext().getUserContext().getUID();
        }
        if (UtilString.isEmpty(type = this.getParameter(expression, 2).trim())) {
            type = "one";
        }
        if (UtilString.isEmpty(delimiter = this.getParameter(expression, 3).trim())) {
            delimiter = " ";
        }
        if (UtilString.isEmpty(includeSelf = this.getParameter(expression, 4).trim())) {
            includeSelf = "1";
        }
        boolean isAll = "all".equals(type);
        UserModel userModel = UserCache.getModel((String)uid);
        if (userModel != null && !userModel.isClosed()) {
            ArrayList<String> uids = new ArrayList<String>();
            this.findManager(userModel.getDepartmentId(), isAll, uids, !"1".equals(includeSelf), uid);
            StringBuffer userid = new StringBuffer();
            for (String u : uids) {
                userid.append(u).append(delimiter);
            }
            if (userid.length() > 0) {
                userid.deleteCharAt(userid.length() - 1);
            }
            return userid.toString();
        }
        return "";
    }

    private void findManager(String deptId, boolean isAll, List<String> uids, boolean isExcludeSelf, String selfuid) {
        DepartmentModel dept = DepartmentCache.getModel((String)deptId);
        if (dept != null) {
            List listManager = UserCache.getUserManager((String)deptId, null, null, (boolean)true);
            for (UserModel u : listManager) {
                if (isExcludeSelf && u.getUID().equals(selfuid)) continue;
                uids.add(u.getUID());
                if (isAll) continue;
                return;
            }
            if (!"0".equals(dept.getParentDepartmentId())) {
                this.findManager(dept.getParentDepartmentId(), isAll, uids, isExcludeSelf, selfuid);
            }
        }
    }
}

