/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.process;

import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ActivityModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessElement;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessNode;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.HistoryTaskInstance;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.TaskInstance;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSExpressionException;
import com.actionsoft.sdk.local.SDK;

public final class ProcessContextHelper {
    private static ProcessContextHelper helper = new ProcessContextHelper();
    public static String CONTEXT_TYPE_ID = "id";
    public static String CONTEXT_TYPE_BKEY = "businessKey";

    private ProcessContextHelper() {
    }

    public static ProcessContextHelper getInstance() {
        return helper;
    }

    public ProcessInstance getProcessInstance(ExpressionContext context, String contextType, String contextId) throws AWSExpressionException {
        if (UtilString.isEmpty(contextType)) {
            ProcessInstance processInst = context.getProcessInstance();
            if (processInst == null) {
                return null;
            }
            return processInst;
        }
        if (UtilString.isEmpty(contextId)) {
            return null;
        }
        if (contextType.equalsIgnoreCase(CONTEXT_TYPE_ID)) {
            return SDK.getProcessAPI().getInstanceById(contextId);
        }
        return SDK.getProcessAPI().getInstanceByBusinessKey(contextId);
    }

    public TaskInstance getTaskInstance(ExpressionContext context, String taskInstId) throws AWSExpressionException {
        if (UtilString.isEmpty(taskInstId)) {
            TaskInstance taskInst = context.getTaskInstance();
            if (taskInst == null) {
                return null;
            }
            return taskInst;
        }
        if (taskInstId.equals("-1")) {
            return null;
        }
        return SDK.getTaskAPI().getTaskInstance(taskInstId);
    }

    public HistoryTaskInstance getHistoryTaskInstance(ExpressionContext context, String taskInstId) throws AWSExpressionException {
        if (UtilString.isEmpty(taskInstId)) {
            TaskInstance taskInst = context.getTaskInstance();
            if (taskInst == null) {
                return null;
            }
            if (taskInst instanceof HistoryTaskInstance) {
                return (HistoryTaskInstance)taskInst;
            }
            if (taskInst.getControlState().equals("active")) {
                return null;
            }
            return SDK.getTaskAPI().getTaskInstanceOfHistory(taskInst.getId());
        }
        if (taskInstId.equals("-1")) {
            return null;
        }
        return SDK.getTaskAPI().getTaskInstanceOfHistory(taskInstId);
    }

    public ProcessDefinition getProcessDefinition(ExpressionContext context, String contextType, String contextId) throws AWSExpressionException {
        if (UtilString.isEmpty(contextType)) {
            ProcessDefinition processDef = context.getProcessDefinition();
            if (processDef != null) {
                return processDef;
            }
            ProcessInstance processInst = context.getProcessInstance();
            if (processInst == null) {
                return null;
            }
            return (ProcessDefinition)ProcessDefCache.getInstance().getModel(processInst.getProcessDefId());
        }
        if (UtilString.isEmpty(contextId)) {
            return null;
        }
        ProcessInstance processInst = null;
        processInst = contextType.equalsIgnoreCase(CONTEXT_TYPE_ID) ? SDK.getProcessAPI().getInstanceById(contextId) : SDK.getProcessAPI().getInstanceByBusinessKey(contextId);
        if (processInst != null) {
            return (ProcessDefinition)ProcessDefCache.getInstance().getModel(processInst.getProcessDefId());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProcessElement getActivityModel(ExpressionContext context, String taskInstId) throws AWSExpressionException {
        if (UtilString.isEmpty(taskInstId)) {
            ProcessElement activityModel = context.getActivityModel();
            if (activityModel != null) return activityModel;
            TaskInstance taskInst = context.getTaskInstance();
            if (taskInst == null) {
                return null;
            }
            ProcessDefinition processDef = context.getProcessDefinition();
            if (processDef == null) {
                processDef = (ProcessDefinition)ProcessDefCache.getInstance().getModel(taskInst.getProcessDefId());
            }
            if (processDef == null) return null;
            return processDef.findProcessNode(taskInst.getActivityDefId());
        }
        if (taskInstId.equals("-1")) {
            return null;
        }
        TaskInstance taskInst = SDK.getTaskAPI().getTaskInstance(taskInstId);
        if (taskInst == null) return null;
        ProcessDefinition processDef = (ProcessDefinition)ProcessDefCache.getInstance().getModel(taskInst.getProcessDefId());
        if (processDef == null) return null;
        ProcessNode processNode = processDef.findProcessNode(taskInst.getActivityDefId());
        if (processNode == null) return null;
        if (!(processNode instanceof ActivityModel)) return null;
        return (ActivityModel)processNode;
    }
}

