/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.process.runtime;

import com.actionsoft.bpms.bpmn.engine.ProcessAPIManager;
import com.actionsoft.bpms.bpmn.engine.TaskAPIManager;
import com.actionsoft.bpms.bpmn.engine.model.run.TaskCommentModel;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.TaskInstance;
import com.actionsoft.bpms.client.process.exec.UserTaskHistoryOpinionWeb;
import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.commons.at.impl.process.ProcessContextHelper;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.alibaba.fastjson.JSONArray;
import java.util.List;

public class ProcessCommentExpression
extends AbstExpression {
    public ProcessCommentExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        if (this.getExpressionContext().getProcessInstance() == null || this.getExpressionContext().getProcessDefinition() == null || this.getExpressionContext().getTaskInstance() == null) {
            return "";
        }
        String processInstId = this.getExpressionContext().getProcessInstance().getId();
        String activityId = this.getParameter(expression, 1).trim();
        String policy = this.getParameter(expression, 2).trim().toLowerCase();
        String contextType = this.getParameter(expression, 3).trim();
        String contextId = this.getParameter(expression, 4).trim();
        UserContext me = this.getExpressionContext().getUserContext();
        ProcessInstance processInst = null;
        if (!UtilString.isEmpty(contextType)) {
            processInst = ProcessContextHelper.getInstance().getProcessInstance(this.getExpressionContext(), contextType, contextId);
            processInstId = processInst.getId();
        }
        List opinionLists = null;
        opinionLists = processInst != null ? ProcessAPIManager.getInstance().getComments(processInst) : ProcessAPIManager.getInstance().getComments(processInstId);
        if (opinionLists != null) {
            for (TaskCommentModel opinionModel : opinionLists) {
                if (opinionModel.getActionName() == null && opinionModel.getActionName().equals("")) {
                    opinionModel.setActionName("");
                }
                UtilString us1 = new UtilString(opinionModel.getMsg());
                opinionModel.setMsg(us1.replace("__eol__", "<br>"));
                JSONArray files = new UserTaskHistoryOpinionWeb().getCommentFilesJson(me, opinionModel.getTaskInstId(), opinionModel.getId());
                TaskInstance taskInst = TaskAPIManager.getInstance().getInstance(opinionModel.getTaskInstId());
                if (taskInst == null || !activityId.equals(taskInst.getActivityDefId())) continue;
                String[] arr = policy.split("\\|");
                String value = "";
                String[] stringArray = arr;
                int n = arr.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    String val = "";
                    if (str.toLowerCase().equals("time")) {
                        val = UtilDate.datetimeFormat(opinionModel.getCreateDate());
                    }
                    if (str.toLowerCase().equals("menuname")) {
                        val = I18nRes.findValue("_bpm.portal", opinionModel.getActionName());
                    }
                    if (str.toLowerCase().equals("comment")) {
                        val = opinionModel.getMsg();
                    }
                    if (str.toLowerCase().equals("file")) {
                        val = files.size() > 0 ? files.toString() : "";
                    }
                    value = UtilString.isEmpty(value) ? val : String.valueOf(value) + "|" + val;
                    ++n2;
                }
                return value;
            }
        }
        return "";
    }
}

