/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.impl.sequence;

import com.actionsoft.bpms.commons.at.AbstExpression;
import com.actionsoft.bpms.commons.at.ExpressionContext;
import com.actionsoft.bpms.commons.at.impl.str.LpadExpression;
import com.actionsoft.bpms.util.Sequence;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import java.sql.Timestamp;

public class SequenceYearExpression
extends AbstExpression {
    public SequenceYearExpression(ExpressionContext atContext, String expressionValue) {
        super(atContext, expressionValue);
    }

    @Override
    public String execute(String expression) {
        String varName = this.getParameter(expression, 1).trim();
        String padLen = this.getParameter(expression, 2).trim();
        String padStr = this.getParameter(expression, 3).trim();
        if (UtilString.isEmpty(varName) && this.getExpressionContext().getProcessInstance() == null) {
            this.issueWarnLog("Context initialization failed, varName is null!");
            return "";
        }
        long current = System.currentTimeMillis();
        String year = UtilDate.yearFormat(new Timestamp(current));
        String key = varName;
        if (UtilString.isEmpty(key)) {
            key = this.getExpressionContext().getProcessInstance().getProcessGroupId();
        }
        key = String.valueOf(key) + year;
        long sequenceValue = Sequence.nextValue("AT_" + key);
        if (!UtilString.isEmpty(padLen)) {
            return String.valueOf(year) + LpadExpression.lpad(Long.toString(sequenceValue), padLen, padStr);
        }
        return String.valueOf(year) + Long.toString(sequenceValue);
    }
}

