/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.web;

import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.commons.at.ConfigExpressionModel;
import com.actionsoft.bpms.commons.at.ExpressionManager;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpressionEditorLeftWeb {
    private UserContext _me;

    public ExpressionEditorLeftWeb(UserContext me) {
        this._me = me;
    }

    public String getWeb() {
        StringBuilder treeHtml = new StringBuilder();
        treeHtml.append("<script>\n");
        treeHtml.append("d=new dTree('d');");
        int treeId = 1;
        treeHtml.append("d.add(0,-1,'-[AWS\u516c\u5f0f\u5217\u8868]');");
        List<String> atGroupList = ExpressionManager.getGroupList();
        Map<String, ConfigExpressionModel> atList = ExpressionManager.getAtList();
        for (String groupName : atGroupList) {
            groupName = groupName.replace("-", "\uff0d");
            treeHtml.append("d.add(").append(treeId++).append(",0,'").append(groupName).append("','');");
            int nowTreeId = treeId;
            for (ConfigExpressionModel configExpressionModel : atList.values()) {
                if (!configExpressionModel.getGroupName().equals(groupName)) continue;
                String tempsyntax = new UtilString(configExpressionModel.getSyntax()).replace("<", "&lt;");
                tempsyntax = new UtilString(configExpressionModel.getSyntax()).replace(">", "&gt;");
                treeHtml.append("d.add(").append(treeId++).append(',').append(nowTreeId - 1).append(",'<span onclick=startEditor(\"" + tempsyntax + "\",\"" + configExpressionModel.getDesc() + "\"); style=\"cursor:pointer;cursor:hand;\">").append(String.valueOf(configExpressionModel.getId()) + "[" + configExpressionModel.getTitle() + "]").append("</span>','');");
            }
        }
        treeHtml.append("document.write(d);");
        treeHtml.append("</script>");
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("flag1", treeHtml.toString());
        macroLibraries.put("sid", "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n");
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.at.editor.left.htm", macroLibraries);
    }

    public String getATCommandToJSON(String filter) {
        StringBuilder atTree = new StringBuilder();
        atTree.append('[');
        List<String> atGroupList = ExpressionManager.getGroupList();
        Map<String, ConfigExpressionModel> atList = ExpressionManager.getAtList();
        String selectTip = "<br><font color=#008800>\uff08\u5f53\u60a8\u9009\u62e9tablename\u65f6\uff0c\u53ef\u4ee5\u8f93\u5165\u8868\u540d\u5bf9\u4e0b\u62c9\u5185\u5bb9\u8fdb\u884c\u8fc7\u6ee4\uff01\uff09</font>";
        if ("@".equals(filter)) {
            int i = 0;
            for (String groupName : atGroupList) {
                groupName = groupName.replace("-", "\uff0d");
                atTree.append("{'text':'" + groupName + "','iconCls':'groupCls','id':'Root-" + i + "','draggable':'false','children':[");
                int ii = 0;
                for (ConfigExpressionModel model : atList.values()) {
                    if (model.getGroupName().equals(groupName)) {
                        String tempsyntax = new UtilString(model.getSyntax()).replace("<", "&lt;");
                        tempsyntax = new UtilString(model.getSyntax()).replace(">", "&gt;");
                        if ("@getform(tablename,fieldname)".equals(tempsyntax.toLowerCase())) {
                            atTree.append("{'text':'" + this.getTableAndFieldForGetfrom(tempsyntax) + "','qtip':'" + model.getDesc() + selectTip + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                        } else if ("@getsubform(tablename,fieldname,position)".equals(tempsyntax.toLowerCase())) {
                            atTree.append("{'text':'" + this.getTableAndFieldForGetsubfrom(tempsyntax) + "','qtip':'" + model.getDesc() + selectTip + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                        } else if ("@sum(tablename,fieldname,format)".equals(tempsyntax.toLowerCase())) {
                            atTree.append("{'text':'" + this.getTableAndFieldForSum(tempsyntax) + "','qtip':'" + model.getDesc() + selectTip + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                        } else if (tempsyntax.toLowerCase().indexOf("sequence:(#") > -1) {
                            atTree.append("{'text':'" + this.getTableAndFieldForSequence(tempsyntax) + "','qtip':'" + model.getDesc() + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                        } else {
                            atTree.append("{'text':'" + tempsyntax + "','qtip':'" + model.getDesc() + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                        }
                    }
                    ++ii;
                }
                if (atTree.lastIndexOf(",") > -1) {
                    atTree.setLength(atTree.length() - 1);
                }
                atTree.append("]},");
                ++i;
            }
        } else {
            int ii = 0;
            while (ii < atList.size()) {
                ConfigExpressionModel model = atList.get(ii);
                String tempsyntax = new UtilString(model.getSyntax()).replace("<", "&lt;");
                tempsyntax = new UtilString(model.getSyntax()).replace(">", "&gt;");
                if (tempsyntax.toLowerCase().indexOf(filter.toLowerCase()) > -1) {
                    if ("@getform(tablename,fieldname)".equals(tempsyntax.toLowerCase())) {
                        atTree.append("{'text':'" + this.getTableAndFieldForGetfrom(tempsyntax) + "','qtip':'" + model.getDesc() + selectTip + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                    } else if ("@getsubform(tablename,fieldname,position)".equals(tempsyntax.toLowerCase())) {
                        atTree.append("{'text':'" + this.getTableAndFieldForGetsubfrom(tempsyntax) + "','qtip':'" + model.getDesc() + selectTip + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                    } else if ("@sum(tablename,fieldname,format)".equals(tempsyntax.toLowerCase())) {
                        atTree.append("{'text':'" + this.getTableAndFieldForSum(tempsyntax) + "','qtip':'" + model.getDesc() + selectTip + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                    } else if (tempsyntax.toLowerCase().indexOf("sequence:(#") > -1) {
                        atTree.append("{'text':'" + this.getTableAndFieldForSequence(tempsyntax) + "','qtip':'" + model.getDesc() + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                    } else {
                        atTree.append("{'text':'" + tempsyntax + "','qtip':'" + model.getDesc() + "','iconCls':'atIcon','id':'sub-" + ii + "','draggable':'false','leaf':'true'},");
                    }
                }
                ++ii;
            }
        }
        if (atTree.lastIndexOf(",") > -1) {
            atTree.setLength(atTree.length() - 1);
        }
        atTree.append(']');
        return atTree.toString();
    }

    private String getTableAndFieldForSequence(String tempsyntax) {
        String pre = tempsyntax.substring(0, tempsyntax.indexOf("#") + 1);
        StringBuilder sb = new StringBuilder();
        sb.append(pre);
        sb.append("<input type=text id=sequence onclick=stopBubble(this,event) style=height:20px;width:100px;>)");
        return sb.toString();
    }

    private String getTableAndFieldForGetfrom(String tempsyntax) {
        String pre = tempsyntax.substring(0, tempsyntax.indexOf("(") + 1);
        StringBuilder sb = new StringBuilder();
        sb.append(pre);
        Map tables = BOCache.getInstance().getList();
        sb.append("<select id=table_1 onclick=stopBubble(this,event) onchange=setFields(this) onmouseover=stopEdit(this)  onkeydown=selectKeyDown(this) onkeypress=selectKeyPress(this) onmouseout=outFocus(this) class=atSelect><option value=tablename>tablename</option>");
        if (!tables.isEmpty()) {
            for (Map boMap : tables.values()) {
                for (BOModel table : boMap.values()) {
                    sb.append("<option value=" + table.getName() + " metaDataId=" + table.getId() + ">" + table.getName() + "</option>");
                }
            }
        }
        sb.append("</select>");
        sb.append("<font size=3><b>,</b></font>");
        sb.append("<select id=field_1 onclick=stopBubble(this,event) ><option value=fieldname>fieldname</option></select></span>");
        sb.append(')');
        return sb.toString();
    }

    private String getTableAndFieldForGetsubfrom(String tempsyntax) {
        String pre = tempsyntax.substring(0, tempsyntax.indexOf("(") + 1);
        StringBuilder sb = new StringBuilder();
        sb.append(pre);
        Map tables = BOCache.getInstance().getList();
        sb.append("<select id=table_2 onclick=stopBubble(this,event) onchange=setFields(this) onmouseover=stopEdit(this) onkeydown=selectKeyDown(this) onkeypress=selectKeyPress(this) onmouseout=outFocus(this) class=atSelect><option value=tablename>tablename</option>");
        if (tables != null) {
            for (Map boMap : tables.values()) {
                for (BOModel table : boMap.values()) {
                    sb.append("<option value=" + table.getName() + " metaDataId=" + table.getId() + ">" + table.getName() + "</option>");
                }
            }
        }
        sb.append("</select>");
        sb.append("<font size=3><b>,</b></font>");
        sb.append("<select id=field_2 onclick=stopBubble(this,event) ><option value=fieldname>fieldname</option></select>");
        sb.append("<font size=3><b>,</b></font><select id=subFormPosition onclick=stopBubble(this,event)><option value=position>position</option><option value=first>first</option><option value=last>last</option></select>");
        sb.append(')');
        return sb.toString();
    }

    private String getTableAndFieldForSum(String tempsyntax) {
        String pre = tempsyntax.substring(0, tempsyntax.indexOf("(") + 1);
        StringBuilder sb = new StringBuilder();
        sb.append(pre);
        Map tables = BOCache.getInstance().getList();
        sb.append("<select id=table_3 onclick=stopBubble(this,event) onchange=setFields(this) onmouseover=stopEdit(this) onkeydown=selectKeyDown(this) onkeypress=selectKeyPress(this) onmouseout=outFocus(this) class=atSelect><option value=tablename>tablename</option>");
        if (tables != null) {
            for (Map boMap : tables.values()) {
                for (BOModel table : boMap.values()) {
                    sb.append("<option value=" + table.getName() + " metaDataId=" + table.getId() + ">" + table.getName() + "</option>");
                }
            }
        }
        sb.append("</select>");
        sb.append("<font size=3><b>,</b></font>");
        sb.append("<select id=field_3 onclick=stopBubble(this,event) ><option value=fieldname>fieldname</option></select>");
        sb.append("<font size=3><b>,</b></font><select id=sumPosition onclick=stopBubble(this,event)><option value=format>format</option><option value=1>\u5927\u5199\u6570\u5b57</option><option value=2>\u666e\u901a\u6570\u5b57</option></select>");
        sb.append(')');
        return sb.toString();
    }

    public String getFieldsOfTable(String metaDataId) {
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(metaDataId);
        StringBuilder fields = new StringBuilder();
        List fd = BOCache.getInstance().getEntityBOItemList(boModel);
        fields.append("'fieldname',");
        if (!fd.isEmpty()) {
            for (BOItemModel model : fd) {
                fields.append("'" + model.getName() + "',");
            }
        }
        if (fields.lastIndexOf(",") > -1) {
            fields.setLength(fields.length() - 1);
        }
        return fields.toString();
    }
}

