/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.at.web;

import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.at.ConfigExpressionModel;
import com.actionsoft.bpms.commons.at.ExpressionManager;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.xmetadata.XCacheModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UUIDGener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpressionEditorWeb {
    private UserContext _me;

    public ExpressionEditorWeb(UserContext me) {
        this._me = me;
    }

    public String getWeb(String targetName, String targetValue) {
        String expressionEditorText = "<textarea name='expressionEditor' class ='actionsoftInput' cols='76' rows='8' WRAP='soft' ONSELECT=\"storeCaret(this);\" ONCLICK=\"storeCaret(this);\" ONKEYUP=\"storeCaret(this);\">" + targetValue + "</textarea>";
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("expressionEditor", expressionEditorText);
        macroLibraries.put("target", targetName);
        macroLibraries.put("sid", "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n");
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.at.editor.page.htm", macroLibraries);
    }

    public String getUI() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sessionId", this._me.getSessionId());
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.at.editor.UI.htm", macroLibraries);
    }

    public String getBOJson(String appId) {
        JSONArray boJson = new JSONArray();
        Map boModels = BOCache.getInstance().getList();
        for (Map map : boModels.values()) {
            for (BOModel model : map.values()) {
                if (!AMCAPIManager.isXModelAccess((XCacheModel)model, this._me.getUID())) continue;
                boJson.add((Object)ExpressionEditorWeb.toCBBItem(model.getName(), model.getName()));
            }
        }
        return boJson.toString();
    }

    private static JSONObject toCBBItem(String title, String v) {
        JSONObject jo = new JSONObject();
        jo.put("value", (Object)v);
        jo.put("text", (Object)title);
        return jo;
    }

    public String getBOFieldsByBoName(String boName) {
        JSONArray boJson = new JSONArray();
        BOModel boModel = BOCache.getInstance().getModelByEntityName(boName);
        if (boModel != null) {
            for (BOItemModel model : boModel.getBoItems()) {
                boJson.add((Object)ExpressionEditorWeb.toCBBItem(model.getName(), model.getName()));
            }
        }
        return boJson.toString();
    }

    public String getExpJson() {
        List<String> atGroupList = ExpressionManager.getGroupList();
        ArrayList expList = new ArrayList();
        int i = 0;
        int leng = atGroupList.size();
        while (i < leng) {
            HashMap<String, Object> groupMap = new HashMap<String, Object>();
            String id = UUIDGener.getUUID();
            groupMap.put("id", id);
            groupMap.put("name", atGroupList.get(i).toString());
            groupMap.put("open", true);
            groupMap.put("iconOpen", "../commons/js/jquery/scripts/ui/at/img/green_yes.gif");
            expList.add(groupMap);
            List<ConfigExpressionModel> atList = ExpressionManager.getListByGroup(atGroupList.get(i));
            int j = 0;
            int jleng = atList.size();
            while (j < jleng) {
                ConfigExpressionModel atmodel = atList.get(j);
                HashMap<String, String> AtMap = new HashMap<String, String>();
                AtMap.put("id", UUIDGener.getUUID());
                AtMap.put("pid", id);
                AtMap.put("key", atmodel.getId());
                AtMap.put("name", atmodel.getSyntax());
                AtMap.put("desc", atmodel.getDesc());
                AtMap.put("icon", "../commons/js/jquery/scripts/ui/at/img/function.gif");
                expList.add(AtMap);
                ++j;
            }
            ++i;
        }
        return JSONArray.parseArray((String)JSON.toJSONString(expList)).toString();
    }
}

