/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.bigtext;

import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.commons.bigtext.BigText;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.file.ReadDCFile;
import com.actionsoft.bpms.server.fs.file.WriteDCFile;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.exception.AWSException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class WorkFlowBigText
implements BigText {
    private DCContext dc;

    public DCContext getDc() {
        return this.dc;
    }

    public WorkFlowBigText(String processDefId, String groupValue, String fileValue, String fileName) {
        ProcessDefinition processDef = (ProcessDefinition)ProcessDefCache.getInstance().getModel(processDefId);
        if (processDef == null) {
            return;
        }
        String appId = processDef.getAppId();
        DCPluginProfile df = DCProfileManager.getDCProfile(appId, "-processbo-");
        this.dc = new DCContext(null, df, appId, groupValue, fileValue, fileName);
    }

    public WorkFlowBigText(String processDefId, String processInstId, String boId, BOItemModel item) {
        this(processDefId, processInstId, boId, item.getId());
    }

    public WorkFlowBigText(String processDefId, String processInstId, BOItemModel item) {
        this(processDefId, processDefId, processInstId, item.getId());
    }

    @Override
    public boolean setBigText(String text) {
        if (text == null) {
            text = "";
        }
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (Exception e) {
            bis = new ByteArrayInputStream(text.getBytes());
        }
        return WriteDCFile.getInstance().write(bis, this.dc);
    }

    @Override
    public String getBigText() {
        InputStream is = ReadDCFile.getInstance().read(this.dc);
        if (is == null) {
            return "";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            UtilIO.copy(is, bos);
        }
        catch (Exception e) {
            throw new AWSException("\u8bfbBO\u5927\u6587\u672c\u5b57\u6bb5\u53d1\u751f\u9519\u8bef", e);
        }
        try {
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(bos.toByteArray());
        }
    }
}

