/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.apps.lifecycle.log.RoundQueue;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.bpmn.engine.core.EngineDebug;
import com.actionsoft.bpms.commons.cache.CacheComparator;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.cache.CacheObject;
import com.actionsoft.bpms.commons.cache.CacheValuesIterator;
import com.actionsoft.bpms.commons.cache.EvictionPolicy;
import com.actionsoft.bpms.commons.cache.Indexs;
import com.actionsoft.bpms.commons.cache.LfuPolicy;
import com.actionsoft.bpms.commons.cache.LruPolicy;
import com.actionsoft.bpms.commons.cache.Policy;
import com.actionsoft.bpms.commons.cache.Replicate;
import com.actionsoft.bpms.commons.cache.ReplicateActionListener;
import com.actionsoft.bpms.commons.cache.ReplicateListener;
import com.actionsoft.bpms.commons.cache.SelectableConcurrentHashMap;
import com.actionsoft.bpms.commons.cache.replicate.DefReplicateActionDestroy;
import com.actionsoft.bpms.commons.cache.replicate.DefReplicateActionInit;
import com.actionsoft.bpms.commons.cache.replicate.DefReplicateActionPut;
import com.actionsoft.bpms.commons.cache.replicate.DefReplicateActionRemove;
import com.actionsoft.bpms.commons.cache.replicate.Element;
import com.actionsoft.bpms.commons.cluster.Message;
import com.actionsoft.bpms.commons.cluster.loadbalancer.ClusterAPI;
import com.actionsoft.bpms.commons.cluster.loadbalancer.NodeModel;
import com.actionsoft.bpms.commons.session.cache.SessionCache;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.ExceptionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.commons.collections4.IteratorUtils;

public abstract class Cache<K extends Serializable, V extends Serializable>
implements ReplicateListener,
Replicate {
    public static final String ACTION_PUT = "put";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_INIT = "init";
    public static final String ACTION_DESTROY = "destroy";
    protected Map<String, ReplicateActionListener> replicateActions = new HashMap<String, ReplicateActionListener>();
    protected CachePluginProfile configuration;
    protected SelectableConcurrentHashMap<K, V> store;
    protected Indexs<K, V> indexs;
    private Policy policy = null;
    static final Random RANDOM = new Random();
    static final int DEFAULT_SAMPLE_SIZE = 30;
    private static final int MAX_EVICTION_RATIO = 5;
    private long updateTime = -1L;
    private RoundQueue<String> opsTrace = new RoundQueue(10);
    private boolean isPurge = false;
    private ScheduledExecutorService _schedulePrune;

    public Cache(CachePluginProfile configuration) {
        this.configuration = configuration;
        this.store = new SelectableConcurrentHashMap(100, 0L);
        this.indexs = new Indexs(this);
        this.policy = this.determineEvictionPolicy();
        this.initReplicateActions();
    }

    protected abstract void load();

    protected void registeReplicateActionListener(ReplicateActionListener replicateAction) {
        if (this.replicateActions.containsKey(replicateAction.getName())) {
            EngineDebug.warn((Object)("[cache=" + this.getConfiguration().getName() + "] Action[" + replicateAction.getName() + ":" + this.replicateActions.get(replicateAction.getName()).getClass().getName() + "] Override By " + replicateAction.getClass().getName()));
        }
        this.replicateActions.put(replicateAction.getName(), replicateAction);
    }

    protected void unRegisteReplicateActionListener(String action) {
        this.replicateActions.remove(action);
    }

    private void initReplicateActions() {
        this.registeReplicateActionListener(new DefReplicateActionPut(this));
        this.registeReplicateActionListener(new DefReplicateActionInit(this));
        this.registeReplicateActionListener(new DefReplicateActionDestroy(this));
        this.registeReplicateActionListener(new DefReplicateActionRemove(this));
    }

    protected void finalize() throws Throwable {
        this.stopService();
        super.finalize();
    }

    protected Policy determineEvictionPolicy() {
        EvictionPolicy policySelection = this.configuration.getEvictionPolicy();
        if (policySelection.equals(EvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (!policySelection.equals(EvictionPolicy.FIFO)) {
            if (policySelection.equals(EvictionPolicy.LFU)) {
                return new LfuPolicy();
            }
            if (policySelection.equals(EvictionPolicy.CLOCK)) {
                return null;
            }
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    protected void registeIndex(Class<? extends CacheIndex<K, V>> c, CacheIndex<K, V> index) {
        index.setIndexs(this.indexs);
        this.indexs.addIndex(c, index);
    }

    protected void removeIndexByKey(Class<? extends CacheIndex<K, V>> c, K k) {
        this.indexs.get(c).removeByIndex(k);
    }

    protected Iterator<V> getByIndex(Class<? extends CacheIndex<K, V>> c, K k) {
        return this.indexs.get(c).get(k);
    }

    protected Iterator<V> getByIndex(Class<? extends CacheIndex<K, V>> c, K k, Comparator<V> comparator) {
        return this.indexs.get(c).getSorted(k, comparator);
    }

    protected V getByIndexSingle(Class<? extends CacheIndex<K, V>> c, K k) {
        Iterator<V> it = this.getByIndex(c, k);
        if (it.hasNext()) {
            return (V)((Serializable)it.next());
        }
        return null;
    }

    public void put(K key, V object) {
        this.put(key, object, this.getConfiguration().getTimeToLiveSeconds());
    }

    public void put(K key, V object, boolean notifyCluster) {
        long ttl = this.getConfiguration().getTimeToLiveSeconds();
        this.put(key, object, ttl, notifyCluster);
    }

    public void put(K key, V object, long timeout) {
        this.put(key, object, timeout, true);
    }

    public void put(K key, V object, long timeout, boolean notifyCluster) {
        if (key == null) {
            return;
        }
        CacheObject<K, V> co = new CacheObject<K, V>(key, object, timeout);
        this.checkCapacity(co);
        CacheObject<K, V> ov = this.store.put(key, co);
        if (ov != null && !UtilString.isEmpty(this.indexs.getIndexs())) {
            this.indexs.remove(ov);
        }
        this.indexs.put(co);
        this.setPurgeStat(timeout > 0L);
        this.setUpdateTime();
        this.addOpsTrace("add", key);
        if (notifyCluster) {
            Element e = new Element();
            e.k = key;
            e.v = object;
            this.replicate(ACTION_PUT, e);
        }
    }

    public void reload() {
        this.reload(true);
    }

    public void reload(boolean notifyCluster) {
        this.doReload();
        if (notifyCluster) {
            this.replicate(ACTION_INIT);
        }
    }

    protected void doReload() {
        Cache<?, ?> c = null;
        try {
            c = CacheManager.getInstance().load(this.getConfiguration());
            if (c != null) {
                c.destroy(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this.destroy(true);
    }

    public void destroy(boolean notifyCluster) {
        this.store.clear();
        this.indexs.clear();
        if (notifyCluster) {
            this.replicate(ACTION_DESTROY);
        }
    }

    public V get(K key) {
        if (key == null) {
            return null;
        }
        CacheObject<K, V> co = this.store.get(key);
        if (co == null) {
            return null;
        }
        if (this.isExpired(co)) {
            this.remove(key);
            return null;
        }
        co.updateAccessStatistics();
        return (V)((Serializable)co.getObject());
    }

    public Set<K> keys() {
        return this.store.keySet();
    }

    public void purge() {
        this.isPurge = false;
        if (SessionCache.class.getName().equals(this.getConfiguration().getName())) {
            Iterator<Map.Entry<K, CacheObject<K, V>>> it = this.store.entrySet().iterator();
            HashSet<Serializable> rs = new HashSet<Serializable>();
            while (it.hasNext()) {
                Map.Entry<K, CacheObject<K, V>> entry = it.next();
                CacheObject<K, V> v = entry.getValue();
                boolean expire = this.isExpired(v);
                if (!expire) continue;
                rs.add((Serializable)entry.getKey());
            }
            for (Serializable k : rs) {
                this.store.remove(k);
            }
        }
    }

    public Iterator<V> iterator() {
        return this.iteratorSorted(null);
    }

    public Stream<V> stream() {
        Iterator iterator = this.iterator();
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public Iterator<V> iteratorSorted(Comparator<V> comparator) {
        Collection<CacheObject<K, V>> c = this.store.values();
        if (comparator != null) {
            ArrayList<CacheObject<K, V>> tmp = new ArrayList<CacheObject<K, V>>(c);
            Collections.sort(tmp, new CacheComparator(comparator));
            return new CacheValuesIterator(this, tmp.iterator());
        }
        return new CacheValuesIterator(this, c.iterator());
    }

    public void remove(K key) {
        this.remove(key, true);
    }

    public void remove(K key, boolean notifyCluster) {
        CacheObject<K, V> co = this.store.remove(key);
        this.indexs.remove(co);
        this.addOpsTrace("del", key);
        if (notifyCluster) {
            this.replicate(ACTION_REMOVE, (Serializable)key);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void replicate(String action, Serializable param) {
        block5: {
            if (this.replicateActions.get(action) == null) {
                EngineDebug.warn((Object)("[cache=" + this.getConfiguration().getName() + "] Not Implements Action[" + action + "] , replicate ignore"));
            } else {
                block6: {
                    cacheMessage = new Message();
                    cacheMessage.setType(Message.MESSAGE_CACHE);
                    cacheMessage.getProperties().put("name", this.getConfiguration().getName());
                    cacheMessage.getProperties().put("action", action);
                    cacheMessage.getProperties().put("param", param);
                    try {
                        ClusterAPI.send((Message)cacheMessage);
                        break block5;
                    }
                    catch (ChannelException e) {
                        sb = new StringBuilder();
                        sb.append(String.valueOf(ExceptionUtil.getMessage(e)) + "\n");
                        fs = e.getFaultyMembers();
                        if (fs == null) break block6;
                        var10_7 = fs;
                        var9_8 = fs.length;
                        var8_9 = 0;
                        ** while (var8_9 < var9_8)
                    }
lbl-1000:
                    // 1 sources

                    {
                        f = var10_7[var8_9];
                        m = f.getMember();
                        ex = f.getCause();
                        sb.append(String.valueOf(NodeModel.getByMember((Member)m).getId()) + "=" + ExceptionUtil.getMessage(ex) + "\n");
                        ++var8_9;
                        continue;
                    }
                }
                throw new AWSException("\u7f13\u5b58[name=" + this.getConfiguration().getName() + ",action=" + action + "]\u540c\u6b65\u5f02\u5e38,info = " + sb, e);
            }
        }
    }

    @Override
    public void onReplicate(String action, Object param) {
        ReplicateActionListener replicateAction = this.replicateActions.get(action);
        if (replicateAction != null) {
            replicateAction.onReplicate(param);
        } else {
            EngineDebug.warn((Object)("[cache=" + this.getConfiguration().getName() + "] Not Implements Action[" + action + "]"));
        }
    }

    public int size() {
        return this.store.size();
    }

    public Map<Class<? extends CacheIndex<K, V>>, CacheIndex<K, V>> getIndexs() {
        return this.indexs.getIndexs();
    }

    public static <T> List<T> iteratorToList(Iterator<T> it) {
        return IteratorUtils.toList(it);
    }

    public CachePluginProfile getConfiguration() {
        return this.configuration;
    }

    private void startService() {
        if (this._schedulePrune != null) {
            try {
                this._schedulePrune.shutdownNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._schedulePrune = Executors.newSingleThreadScheduledExecutor();
        this._schedulePrune.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void stopService() {
        if (this._schedulePrune != null) {
            try {
                try {
                    this._schedulePrune.shutdownNow();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._schedulePrune = null;
                }
            }
            finally {
                this._schedulePrune = null;
            }
        }
    }

    private void replicate(String action) {
        this.replicate(action, (Serializable)((Object)""));
    }

    private void checkCapacity(CacheObject<K, V> co) {
        if (this.getConfiguration().getMaxElements() > 0 && this.getConfiguration().getEvictionPolicy() != EvictionPolicy.CLOCK) {
            int evict = Math.min(this.store.quickSize() - this.getConfiguration().getMaxElements(), 5);
            int i = 0;
            while (i < evict) {
                CacheObject<K, V> o = this.findEvictionCandidate(co);
                this.remove((Serializable)o.key, true);
                ++i;
            }
        }
    }

    private CacheObject<K, V> findEvictionCandidate(CacheObject<K, V> elementJustAdded) {
        Serializable objectKey = elementJustAdded != null ? (Serializable)elementJustAdded.key : null;
        List elements = this.sampleElements(objectKey);
        return this.policy.selectedBasedOnPolicy(elements, objectKey, (Serializable)elementJustAdded.getObject());
    }

    private List<CacheObject<K, V>> sampleElements(K keyHint) {
        int size = Cache.calculateSampleSize(this.store.quickSize());
        return this.store.getRandomValues(size, keyHint);
    }

    private static int calculateSampleSize(int populationSize) {
        if (populationSize < 30) {
            return populationSize;
        }
        return 30;
    }

    protected boolean isExpired(CacheObject<K, V> co) {
        long t = System.currentTimeMillis();
        if (this.getConfiguration().getTimeToIdleSeconds() > 0L && t - co.getLastAccess() > this.getConfiguration().getTimeToIdleSeconds() * 1000L) {
            return true;
        }
        if (co.ttl == 0L) {
            return false;
        }
        return t - co.updateTime > co.ttl;
    }

    protected void setUpdateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    public boolean isPurge() {
        return this.isPurge;
    }

    private void setPurgeStat(boolean p) {
        if (p && !this.isPurge()) {
            this.isPurge = true;
        }
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void addOpsTrace(String op, K key) {
        this.getOpsTrace().add((Object)(String.valueOf(UtilDate.timeFormat(new Date(), "mm:ss")) + "|" + op + "|" + key));
    }

    public RoundQueue<String> getOpsTrace() {
        return this.opsTrace;
    }
}

