/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.bpms.commons.cache.Cache;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.wstone.jmx.Impact;
import org.wstone.jmx.ManagedOperation;

public class CacheMBean<K extends Serializable, V extends Serializable> {
    private Cache<K, V> cache;

    public CacheMBean(Cache<K, V> cache) {
        this.cache = cache;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName("com.actionsoft.cache:type=" + this.cache.getConfiguration().getName());
    }

    @ManagedOperation(description="\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f", impact=Impact.READ)
    public String getConfig() {
        return ToStringBuilder.reflectionToString((Object)this.cache.getConfiguration(), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @ManagedOperation(description="\u83b7\u53d6\u7f13\u5b58\u5bf9\u8c61\u4e2a\u6570", impact=Impact.READ)
    public int size() {
        return this.cache.size();
    }

    @ManagedOperation(description="\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f", impact=Impact.READ)
    public String getIndexInfo() {
        Set s = this.cache.indexs.indexs.keySet();
        HashMap<String, String> s1 = new HashMap<String, String>();
        if (s != null) {
            for (Class cls : s) {
                s1.put(cls.getName(), "");
            }
        }
        return JSONArray.parseArray((String)JSON.toJSONString(s1.keySet())).toString();
    }

    @ManagedOperation(description="\u83b7\u53d6\u540c\u6b65\u52a8\u4f5c", impact=Impact.READ)
    public String getReplicateInfo() {
        Set<String> s = this.cache.replicateActions.keySet();
        return JSONArray.parseArray((String)JSON.toJSONString(s)).toString();
    }

    @ManagedOperation(description="\u67e5\u627e\u7f13\u5b58\u5bf9\u8c61", impact=Impact.READ)
    public String getObject(String name, String v) {
        Field f = null;
        try {
            Iterator<V> iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                Object o;
                Serializable obj = (Serializable)iterator.next();
                if (v == null || "".equals(v)) {
                    return ToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
                }
                if (f == null) {
                    Field[] fs = obj.getClass().getDeclaredFields();
                    if (fs != null) {
                        Field[] fieldArray = fs;
                        int n = fs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Field field = fieldArray[n2];
                            if (!Modifier.isStatic(field.getModifiers()) && Pattern.compile(name, 2).matcher(field.getName()).find()) {
                                f = field;
                                break;
                            }
                            ++n2;
                        }
                        if (f == null) {
                            return "\u5c5e\u6027" + name + "\u4e0d\u5b58\u5728";
                        }
                    }
                    f.setAccessible(true);
                }
                if ((o = f.get(obj)) == null || !Pattern.compile(v, 2).matcher(String.valueOf(o)).find()) continue;
                return ToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "\u672a\u627e\u5230\u67e5\u627e\u7684\u7f13\u5b58\u5bf9\u8c61";
    }
}

