/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.AWSPlugin;
import com.actionsoft.apps.resource.plugin.meta.PluginMetas;
import com.actionsoft.apps.resource.plugin.profile.AWSPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheMBean;
import com.actionsoft.bpms.server.AWSMBeanServer;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.exception.ExceptionUtil;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class CacheManager
implements AWSPlugin {
    private static Map<String, Cache<?, ?>> initializingCaches = new ConcurrentHashMap();
    private static volatile CacheManager singleton;
    private static Logger logger;

    static {
        logger = LogAPI.getLogger(CacheManager.class);
        long inteval = 14400000L;
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (SDK.getPlatformAPI().getAWSServer().isServiceReady()) {
                    for (Map.Entry o : initializingCaches.entrySet()) {
                        CachePluginProfile cp = ((Cache)o.getValue()).getConfiguration();
                        if (cp.getTimeToIdleSeconds() <= 0L && !((Cache)o.getValue()).isPurge()) continue;
                        try {
                            ((Cache)o.getValue()).purge();
                        }
                        catch (Exception e) {
                            System.err.println("purge\uff1a" + ((Cache)o.getValue()).getConfiguration().getName() + "\u51fa\u9519");
                            e.printStackTrace();
                        }
                    }
                }
            }
        }, 14400000L, 14400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheManager getInstance() {
        if (singleton != null) return singleton;
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton != null) return singleton;
            singleton = new CacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static <T extends Cache<?, ?>> T getCache(Class<T> cls) {
        return (T)CacheManager.getCache(cls.getName());
    }

    public static Cache<?, ?> getCache(String clazz) {
        Cache<?, ?> cache = initializingCaches.get(clazz);
        return cache;
    }

    public static void setCache(Cache<?, ?> c) {
        Cache<?, ?> old = initializingCaches.put(c.getConfiguration().getName(), c);
        if (old != null) {
            old.destroy(false);
        }
    }

    public boolean registerPlugin(AppContext app, AWSPluginProfile plugin) {
        if (!(plugin instanceof CachePluginProfile)) {
            AppsLogger.err((AppContext)app, (String)("\u6ce8\u518c" + PluginMetas.getName((AWSPluginProfile)plugin) + "[" + plugin.getClazzName() + "]\u5931\u8d25\uff0c\u539f\u56e0\u662f\u8be5Profile\u4e0d\u662fCachePluginProfile\u5b9e\u73b0\u7c7b"));
            return false;
        }
        CachePluginProfile c = (CachePluginProfile)plugin;
        if (initializingCaches.containsKey(c.getName())) {
            AppsLogger.err((AppContext)app, (String)("\u6ce8\u518c" + PluginMetas.getName((AWSPluginProfile)plugin) + "[" + plugin.getClazzName() + "]\u5931\u8d25\uff0c\u539f\u56e0\u662f\u8be5Profile[name=" + c.getName() + "]\u5df2\u7ecf\u6ce8\u518c"));
            return false;
        }
        try {
            this.load(c);
        }
        catch (Exception e) {
            this.destoryPlugin(app, plugin);
            AppsLogger.err((AppContext)app, (String)("\u6ce8\u518c" + PluginMetas.getName((AWSPluginProfile)plugin) + "[" + plugin.getClazzName() + "]\u5931\u8d25"));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<?, ?> load(CachePluginProfile c) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, InstantiationException, IllegalAccessException {
        String string = "CacheManager-" + c.getName();
        synchronized (string) {
            AppContext app = c.getAppContext();
            Cache cache = (Cache)ClassReflect.getInstance(c.getClazzName(), new Class[]{CachePluginProfile.class}, new Object[]{c}, app);
            Cache pv = initializingCaches.put(c.getName(), cache);
            try {
                cache.load();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("[" + app.getName() + "][" + c.getName() + "]\u7f13\u5b58load\u51fa\u9519\uff0c" + ExceptionUtil.getMessage(e));
            }
            CacheMBean cm = new CacheMBean(cache);
            try {
                AWSMBeanServer.unregisterMBean((ObjectName)cm.getObjectName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                AWSMBeanServer.registerMBean(cm, (ObjectName)cm.getObjectName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return pv;
        }
    }

    public boolean destoryPlugin(AppContext app, AWSPluginProfile plugin) {
        CachePluginProfile c = (CachePluginProfile)plugin;
        Cache<?, ?> cache = initializingCaches.remove(c.getName());
        try {
            AWSMBeanServer.unregisterMBean((ObjectName)new CacheMBean(cache).getObjectName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cache != null) {
            cache.destroy(false);
        }
        return true;
    }
}

