/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class CacheObject<K, V> {
    private static final AtomicLongFieldUpdater<CacheObject> HIT_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(CacheObject.class, "hitCount");
    public volatile long hitCount;
    final K key;
    final V cachedObject;
    long updateTime;
    long lastAccess;
    long ttl;

    public CacheObject(K key, V object, long ttl) {
        this.key = key;
        this.cachedObject = object;
        this.ttl = ttl * 1000L;
        this.updateTime = System.currentTimeMillis();
    }

    public V getObject() {
        return this.cachedObject;
    }

    public void updateAccessStatistics() {
        this.lastAccess = System.currentTimeMillis();
        HIT_COUNT_UPDATER.incrementAndGet(this);
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    final long getHitCount() {
        return this.hitCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.cachedObject != null && o instanceof CacheObject) {
            return this.cachedObject.equals(((CacheObject)o).cachedObject);
        }
        return false;
    }

    public int hashCode() {
        return this.cachedObject == null ? 0 : this.cachedObject.hashCode();
    }

    public String toString() {
        return this.key + "=" + this.cachedObject;
    }
}

