/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheObject;
import java.util.Iterator;

public class CacheValuesIterator<V>
implements Iterator<V> {
    private Iterator<CacheObject<?, V>> iterator;
    private CacheObject<?, V> nextValue;
    private Cache cache;

    CacheValuesIterator(Cache c, Iterator<CacheObject<?, V>> iterator) {
        this.cache = c;
        this.iterator = iterator;
        this.nextValue();
    }

    private void nextValue() {
        while (this.iterator.hasNext()) {
            this.nextValue = this.iterator.next();
            if (this.cache.isExpired(this.nextValue)) continue;
            return;
        }
        this.nextValue = null;
    }

    @Override
    public boolean hasNext() {
        return this.nextValue != null;
    }

    @Override
    public V next() {
        Object cachedObject = this.nextValue.cachedObject;
        this.nextValue();
        return cachedObject;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

