/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.UtilIO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FastFiles
extends Cache<String, byte[]> {
    public FastFiles(CachePluginProfile configuration) {
        super(configuration);
    }

    public static byte[] getFile(String id) throws IOException {
        byte[] b = (byte[])FastFiles.get().get(id);
        if (b == null) {
            File f = new File(id);
            FileInputStream input = null;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                input = new FileInputStream(f);
                UtilIO.copy(input, os);
                FastFiles.putFile(id, os.toByteArray());
                os = null;
                byte[] byArray = FastFiles.getFile(id);
                return byArray;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return b;
    }

    private static void putFile(String id, byte[] bytes) {
        FastFiles.get().put(id, bytes, true);
    }

    public static void removeFile(String id) {
        FastFiles.get().remove(id, true);
    }

    public static FastFiles get() {
        return CacheManager.getCache(FastFiles.class);
    }

    @Override
    protected void load() {
    }
}

