/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheObject;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Indexs<K extends Serializable, V extends Serializable> {
    protected Map<Class<? extends CacheIndex<K, V>>, CacheIndex<K, V>> indexs;
    protected Cache<K, V> cache;

    public Indexs(Cache<K, V> cache) {
        this.cache = cache;
        this.indexs = new ConcurrentHashMap<Class<? extends CacheIndex<K, V>>, CacheIndex<K, V>>();
    }

    public void addIndex(Class<? extends CacheIndex<K, V>> c, CacheIndex<K, V> index) {
        this.indexs.put(c, index);
        index.init();
    }

    public void put(CacheObject<K, V> co) {
        for (CacheIndex<K, V> index : this.indexs.values()) {
            index.put(co);
        }
    }

    public void remove(CacheObject<K, V> co) {
        if (co != null) {
            for (CacheIndex<K, V> index : this.indexs.values()) {
                index.remove(co);
            }
        }
    }

    public void removeByIndex(K k) {
        if (k != null) {
            for (CacheIndex<K, V> index : this.indexs.values()) {
                index.removeByIndex(k);
            }
        }
    }

    public CacheIndex<K, V> get(Class<? extends CacheIndex<K, V>> target) {
        return this.indexs.get(target);
    }

    public Map<Class<? extends CacheIndex<K, V>>, CacheIndex<K, V>> getIndexs() {
        return this.indexs;
    }

    public void clear() {
        for (CacheIndex<K, V> index : this.indexs.values()) {
            index.clear();
        }
    }
}

