/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.bpms.commons.cache.CacheComparator;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheObject;
import com.actionsoft.bpms.commons.cache.CacheValuesIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ListValueIndexAbs<K extends Serializable, V extends Serializable>
extends CacheIndex<K, V> {
    private static final Object PRESENT = new Object();
    private Map<K, Map<CacheObject<K, V>, Object>> _cacheMap = new ConcurrentHashMap<K, Map<CacheObject<K, V>, Object>>(1024);

    @Override
    public void init() {
        Iterator iterator = this.indexs.cache.store.values().iterator();
        CacheObject nextValue = null;
        while (iterator.hasNext()) {
            nextValue = iterator.next();
            this.put(nextValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAdd(K key, CacheObject<K, V> co) {
        if (key == null) {
            throw new IllegalArgumentException("\u5b58\u5728\u7d22\u5f15\u503c\u4e3a\u7a7a\u7684\u7f13\u5b58\u5bf9\u8c61[" + co.getObject() + "]\uff0c\u8bf7\u68c0\u67e5\u6216\u6539\u53d8\u7d22\u5f15\u5b9e\u73b0");
        }
        Map<CacheObject<CacheObject<K, V>, Object>, Object> list = this._cacheMap.get(key);
        if (list == null) {
            ListValueIndexAbs listValueIndexAbs = this;
            synchronized (listValueIndexAbs) {
                if (list == null) {
                    list = new ConcurrentHashMap<CacheObject<K, V>, Object>(64);
                    this._cacheMap.put(key, list);
                }
            }
        }
        list.put(co, PRESENT);
    }

    protected void processRemove(K key, CacheObject<K, V> co) {
        Map<CacheObject<K, V>, Object> list = this._cacheMap.get(key);
        if (list != null) {
            list.remove(co);
        }
    }

    @Override
    public void removeByIndex(K k) {
        Map<CacheObject<K, V>, Object> list = this._cacheMap.remove(k);
        if (list != null) {
            list.clear();
        }
    }

    @Override
    public Iterator<V> getSorted(K key, Comparator<V> comparator) {
        Collection<Object> tmp;
        Map<CacheObject<K, V>, Object> list = this._cacheMap.get(key);
        Collection<Object> collection = tmp = list == null ? Collections.EMPTY_LIST : list.keySet();
        if (list != null) {
            if (comparator != null) {
                tmp = new ArrayList<Object>(tmp);
                Collections.sort((List)tmp, new CacheComparator(comparator));
            }
            for (CacheObject cacheObject : tmp) {
                cacheObject.updateAccessStatistics();
            }
        }
        return new CacheValuesIterator(this.indexs.cache, tmp.iterator());
    }

    @Override
    public void clear() {
        this._cacheMap.clear();
    }
}

