/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.bpms.commons.cache.CacheObject;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SelectableConcurrentHashMap<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MAX_SEGMENTS = 65536;
    private static final int RETRIES_BEFORE_LOCK = 2;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment[] segments;
    private final Random rndm = new Random();
    private volatile long maxSize;
    private Set<K> keySet;
    private Set<Map.Entry<K, CacheObject<K, V>>> entrySet;
    private Collection<CacheObject<K, V>> values;

    public SelectableConcurrentHashMap(int concurrency, long maximumSize) {
        this(16, 0.75f, concurrency, maximumSize);
    }

    public SelectableConcurrentHashMap(int initialCapacity, float loadFactor, int concurrency, long maximumSize) {
        int c;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrency <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrency > 65536) {
            concurrency = 65536;
        }
        int sshift = 0;
        int ssize = 1;
        while (ssize < concurrency) {
            ++sshift;
            ssize <<= 1;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        int cap = 1;
        while (cap < c) {
            cap <<= 1;
        }
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = this.createSegment(cap, loadFactor);
            ++i;
        }
        this.maxSize = maximumSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public List<CacheObject<K, V>> getRandomValues(int size, Object keyHint) {
        ArrayList<CacheObject<K, V>> sampled = new ArrayList<CacheObject<K, V>>(size * 2);
        int randomHash = this.rndm.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift & this.segmentMask : SelectableConcurrentHashMap.hash(keyHint.hashCode()) >>> this.segmentShift & this.segmentMask;
        int segmentIndex = segmentStart;
        do {
            int tableStart;
            HashEntry[] table = this.segments[segmentIndex].table;
            int tableIndex = tableStart = randomHash & table.length - 1;
            do {
                HashEntry e = table[tableIndex];
                while (e != null) {
                    CacheObject value = e.value;
                    if (value != null) {
                        sampled.add(value);
                    }
                    e = e.next;
                }
                if (sampled.size() < size) continue;
                return sampled;
            } while ((tableIndex = tableIndex + 1 & table.length - 1) != tableStart);
        } while ((segmentIndex = segmentIndex + 1 & this.segmentMask) != segmentStart);
        return sampled;
    }

    public Object storedObject(CacheObject<K, V> e) {
        return new HashEntry<Object, V>(null, 0, null, e, 0L);
    }

    public int quickSize() {
        Segment[] segments = this.segments;
        long sum = 0L;
        Segment[] segmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment seg = segmentArray[n2];
            sum += (long)seg.count;
            ++n2;
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public boolean isEmpty() {
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        int i = 0;
        while (i < segments.length) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
            ++i;
        }
        if (mcsum != 0) {
            i = 0;
            while (i < segments.length) {
                if (segments[i].count != 0 || mc[i] != segments[i].modCount) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public int size() {
        segments = this.segments;
        k = 0;
        while (k < 2) {
            mc = new int[segments.length];
            check = 0L;
            sum = 0L;
            mcsum = 0;
            i = 0;
            while (i < segments.length) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                ++i;
            }
            if (mcsum != 0) {
                i = 0;
                while (i < segments.length) {
                    check += (long)segments[i].count;
                    if (mc[i] != segments[i].modCount) {
                        check = -1L;
                        break;
                    }
                    ++i;
                }
            }
            if (check == sum) {
                if (sum > 0x7FFFFFFFL) {
                    return 0x7FFFFFFF;
                }
                return (int)sum;
            }
            ++k;
        }
        sum = 0L;
        i = 0;
        while (i < segments.length) {
            segments[i].readLock().lock();
            ++i;
        }
        try {
            i = 0;
            while (i < segments.length) {
                sum += (long)segments[i].count;
                ++i;
            }
        }
        finally {
            i = 0;
            ** while (i < segments.length)
        }
lbl-1000:
        // 1 sources

        {
            segments[i].readLock().unlock();
            ++i;
            continue;
        }
lbl49:
        // 1 sources

        if (sum > 0x7FFFFFFFL) {
            return 0x7FFFFFFF;
        }
        return (int)sum;
    }

    public ReentrantReadWriteLock lockFor(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash);
    }

    public ReentrantReadWriteLock[] locks() {
        return this.segments;
    }

    public CacheObject<K, V> get(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    public boolean containsKey(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        segments = this.segments;
        mc = new int[segments.length];
        k = 0;
        while (k < 2) {
            sum = false;
            mcsum = 0;
            i = 0;
            while (i < segments.length) {
                c = segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                if (segments[i].containsValue(value)) {
                    return true;
                }
                ++i;
            }
            cleanSweep = true;
            if (mcsum != 0) {
                i = 0;
                while (i < segments.length) {
                    c = segments[i].count;
                    if (mc[i] != segments[i].modCount) {
                        cleanSweep = false;
                        break;
                    }
                    ++i;
                }
            }
            if (cleanSweep) {
                return false;
            }
            ++k;
        }
        i = 0;
        while (i < segments.length) {
            segments[i].readLock().lock();
            ++i;
        }
        try {
            i = 0;
            while (i < segments.length) {
                if (segments[i].containsValue(value)) {
                }
                ++i;
            }
        }
        finally {
            i = 0;
            ** while (i < segments.length)
        }
lbl-1000:
        // 1 sources

        {
            segments[i].readLock().unlock();
            ++i;
            continue;
        }
lbl51:
        // 1 sources

        return true;
    }

    public CacheObject<K, V> put(K key, CacheObject<K, V> element) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, element, 0L, false, true);
    }

    public CacheObject<K, V> putIfAbsent(K key, CacheObject<K, V> element, long sizeOf) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, element, sizeOf, true, true);
    }

    public CacheObject<K, V> remove(Object key) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(Object key, Object value) {
        int hash = SelectableConcurrentHashMap.hash(key.hashCode());
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    public void clear() {
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i].clear();
            ++i;
        }
    }

    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection<CacheObject<K, V>> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<Map.Entry<K, CacheObject<K, V>>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    protected Segment createSegment(int initialCapacity, float lf) {
        return new Segment(initialCapacity, lf);
    }

    private Segment getRandomSegment() {
        int randomHash = this.rndm.nextInt();
        return this.segments[randomHash >>> this.segmentShift & this.segmentMask];
    }

    protected final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    protected final List<Segment> segments() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    protected static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final class EntryIterator
    extends HashEntryIterator
    implements Iterator<Map.Entry<K, CacheObject<K, V>>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, CacheObject<K, V>> next() {
            HashEntry entry = this.nextEntry();
            final Object key = entry.key;
            final CacheObject value = entry.value;
            return new Map.Entry<K, CacheObject<K, V>>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public CacheObject<K, V> getValue() {
                    return value;
                }

                @Override
                public CacheObject<K, V> setValue(CacheObject<K, V> value2) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, CacheObject<K, V>>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, CacheObject<K, V>>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            CacheObject v = SelectableConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SelectableConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            for (Map.Entry object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            for (Map.Entry object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    public static class HashEntry<K, V> {
        public final K key;
        public final int hash;
        public final HashEntry<K, V> next;
        public volatile CacheObject<K, V> value;
        public volatile long sizeOf;
        public volatile boolean accessed = true;

        protected HashEntry(K key, int hash, HashEntry<K, V> next, CacheObject<K, V> value, long sizeOf) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
            this.sizeOf = sizeOf;
        }
    }

    abstract class HashEntryIterator
    extends HashIterator {
        private HashEntry myNextEntry;

        public HashEntryIterator() {
            this.myNextEntry = this.advanceToNextEntry();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        @Override
        public HashEntry nextEntry() {
            if (this.myNextEntry == null) {
                throw new NoSuchElementException();
            }
            HashEntry entry = this.myNextEntry;
            this.myNextEntry = this.advanceToNextEntry();
            return entry;
        }

        @Override
        public boolean hasNext() {
            return this.myNextEntry != null;
        }

        private HashEntry advanceToNextEntry() {
            HashEntry myEntry = null;
            while (super.hasNext()) {
                myEntry = super.nextEntry();
                if (myEntry != null) break;
                myEntry = null;
            }
            return myEntry;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = SelectableConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        /*
         * Unable to fully structure code
         */
        final void advance() {
            if (this.nextEntry == null || (this.nextEntry = this.nextEntry.next) == null) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
lbl5:
                // 2 sources

                ** while (this.nextTableIndex >= 0)
            }
lbl6:
            // 3 sources

            while (this.nextSegmentIndex >= 0) {
                seg = SelectableConcurrentHashMap.access$0(SelectableConcurrentHashMap.this)[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                j = this.currentTable.length - 1;
                while (j >= 0) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry != null) {
                        this.nextTableIndex = j - 1;
                        return;
                    }
                    --j;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            SelectableConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    class KeyIterator
    extends HashEntryIterator
    implements Iterator<Object> {
        KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().key;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SelectableConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return SelectableConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    public class Segment
    extends ReentrantReadWriteLock {
        private static final int MAX_EVICTION = 5;
        protected volatile int count;
        int modCount;
        int threshold;
        protected volatile HashEntry[] table;
        final float loadFactor;
        private Iterator<HashEntry> evictionIterator;

        protected Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new HashEntry[initialCapacity]);
        }

        protected void preRemove(HashEntry e) {
        }

        protected void postInstall(Object key, CacheObject<K, V> value) {
        }

        void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        protected HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        private HashEntry removeAndGetFirst(HashEntry e, HashEntry first) {
            this.preRemove(e);
            HashEntry newFirst = e.next;
            HashEntry p = first;
            while (p != e) {
                newFirst = this.relinkHashEntry(p, newFirst);
                p = p.next;
            }
            return newFirst;
        }

        protected HashEntry createHashEntry(Object key, int hash, HashEntry next, CacheObject<K, V> value, long sizeOf) {
            return new HashEntry(key, hash, next, value, sizeOf);
        }

        protected HashEntry relinkHashEntry(HashEntry e, HashEntry next) {
            return new HashEntry(e.key, e.hash, next, e.value, e.sizeOf);
        }

        protected void clear() {
            ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
            writeLock.lock();
            try {
                if (this.count != 0) {
                    HashEntry[] tab = this.table;
                    int i = 0;
                    while (i < tab.length) {
                        tab[i] = null;
                        ++i;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                this.evictionIterator = null;
            }
            finally {
                writeLock.unlock();
            }
        }

        CacheObject<K, V> remove(Object key, int hash, Object value) {
            ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
            writeLock.lock();
            try {
                HashEntry first;
                int c = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                CacheObject oldValue = null;
                if (e != null) {
                    CacheObject v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        tab[index] = this.removeAndGetFirst(e, first);
                        this.count = c;
                        if (this.evictionIterator != null && this.evictionIterator.next() == e) {
                            this.evictionIterator.next();
                        }
                    }
                }
                CacheObject cacheObject = oldValue;
                return cacheObject;
            }
            finally {
                writeLock.unlock();
            }
        }

        protected CacheObject<K, V> put(Object key, int hash, CacheObject<K, V> value, long sizeOf, boolean onlyIfAbsent, boolean fire) {
            CacheObject[] evicted = new CacheObject[5];
            ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
            writeLock.lock();
            try {
                CacheObject oldValue;
                HashEntry first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value;
                        e.sizeOf = sizeOf;
                        if (fire) {
                            this.postInstall(key, value);
                        }
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index] = this.createHashEntry(key, hash, first, value, sizeOf);
                    this.count = c;
                    if (fire) {
                        this.postInstall(key, value);
                    }
                }
                CacheObject cacheObject = oldValue;
                return cacheObject;
            }
            finally {
                writeLock.unlock();
            }
        }

        CacheObject<K, V> get(Object key, int hash) {
            ReentrantReadWriteLock.ReadLock readLock = this.readLock();
            readLock.lock();
            try {
                if (this.count != 0) {
                    HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && key.equals(e.key)) {
                            e.accessed = true;
                            CacheObject cacheObject = e.value;
                            return cacheObject;
                        }
                        e = e.next;
                    }
                }
                return null;
            }
            finally {
                readLock.unlock();
            }
        }

        boolean containsKey(Object key, int hash) {
            ReentrantReadWriteLock.ReadLock readLock = this.readLock();
            readLock.lock();
            try {
                if (this.count != 0) {
                    HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && key.equals(e.key)) {
                            return true;
                        }
                        e = e.next;
                    }
                }
                return false;
            }
            finally {
                readLock.unlock();
            }
        }

        boolean containsValue(Object value) {
            ReentrantReadWriteLock.ReadLock readLock = this.readLock();
            readLock.lock();
            try {
                if (this.count != 0) {
                    HashEntry[] tab = this.table;
                    int len = tab.length;
                    int i = 0;
                    while (i < len) {
                        HashEntry e = tab[i];
                        while (e != null) {
                            CacheObject v = e.value;
                            if (value.equals(v)) {
                                return true;
                            }
                            e = e.next;
                        }
                        ++i;
                    }
                }
                return false;
            }
            finally {
                readLock.unlock();
            }
        }

        protected Iterator<HashEntry> iterator() {
            return new SegmentIterator(this);
        }

        void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            int i = 0;
            while (i < oldCapacity) {
                HashEntry e = oldTable[i];
                if (e != null) {
                    HashEntry next = e.next;
                    int idx = e.hash & sizeMask;
                    if (next == null) {
                        newTable[idx] = e;
                    } else {
                        int k;
                        HashEntry lastRun = e;
                        int lastIdx = idx;
                        HashEntry last = next;
                        while (last != null) {
                            k = last.hash & sizeMask;
                            if (k != lastIdx) {
                                lastIdx = k;
                                lastRun = last;
                            }
                            last = last.next;
                        }
                        newTable[lastIdx] = lastRun;
                        HashEntry p = e;
                        while (p != lastRun) {
                            k = p.hash & sizeMask;
                            HashEntry n = newTable[k];
                            newTable[k] = this.relinkHashEntry(p, n);
                            p = p.next;
                        }
                    }
                }
                ++i;
            }
            this.table = newTable;
            if (this.evictionIterator != null) {
                this.evictionIterator = this.iterator();
            }
        }

        Iterator<HashEntry> getEvictionIterator() {
            return this.evictionIterator;
        }
    }

    class SegmentIterator
    implements Iterator<HashEntry> {
        int nextTableIndex = -1;
        HashEntry<K, V>[] currentTable;
        HashEntry<K, V> nextEntry;
        private final Segment seg;

        private SegmentIterator(Segment memoryStoreSegment) {
            this.seg = memoryStoreSegment;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public HashEntry next() {
            if (this.nextEntry == null) {
                return null;
            }
            HashEntry lastReturned = this.nextEntry;
            this.advance();
            return lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        /*
         * Unable to fully structure code
         */
        final void advance() {
            if (this.nextEntry == null || (this.nextEntry = this.nextEntry.next) == null) ** GOTO lbl5
            return;
lbl-1000:
            // 1 sources

            {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
lbl5:
                // 2 sources

                ** while (this.nextTableIndex >= 0)
            }
lbl6:
            // 1 sources

            if (this.seg.count != 0) {
                this.currentTable = this.seg.table;
                j = this.currentTable.length - 1;
                while (j >= 0) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry != null) {
                        this.nextTableIndex = j - 1;
                        return;
                    }
                    --j;
                }
            }
        }
    }

    final class ValueIterator
    extends HashEntryIterator
    implements Iterator<CacheObject<K, V>> {
        ValueIterator() {
        }

        @Override
        public CacheObject<K, V> next() {
            return this.nextEntry().value;
        }
    }

    final class Values
    extends AbstractCollection<CacheObject<K, V>> {
        Values() {
        }

        @Override
        public Iterator<CacheObject<K, V>> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SelectableConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SelectableConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return SelectableConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            SelectableConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            for (CacheObject object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList c = new ArrayList();
            for (CacheObject object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }
}

