/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.cache;

import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheObject;
import com.actionsoft.bpms.commons.cache.CacheValuesIterator;
import com.actionsoft.bpms.commons.cache.IndexSigleKey;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SingleValueIndex<K extends Serializable, V extends Serializable>
extends CacheIndex<K, V>
implements IndexSigleKey<K, V> {
    private Map<K, CacheObject<K, V>> _cacheMap = new ConcurrentHashMap<K, CacheObject<K, V>>(1024);

    @Override
    public void init() {
        Iterator iterator = this.indexs.cache.store.values().iterator();
        CacheObject nextValue = null;
        while (iterator.hasNext()) {
            nextValue = iterator.next();
            this.put(nextValue);
        }
    }

    public Collection<K> keys(V t) {
        return null;
    }

    @Override
    public void put(CacheObject<K, V> co) {
        this._cacheMap.put((Serializable)this.key((Serializable)co.getObject()), co);
    }

    @Override
    public void remove(CacheObject<K, V> co) {
        this._cacheMap.remove(this.key((Serializable)co.getObject()));
    }

    @Override
    public void removeByIndex(K k) {
        this._cacheMap.remove(k);
    }

    @Override
    public Iterator<V> getSorted(K key, Comparator<V> comparator) {
        CacheObject<K, V> co = this._cacheMap.get(key);
        Iterator it = null;
        if (co != null) {
            co.updateAccessStatistics();
            it = Arrays.asList(co).iterator();
        } else {
            it = Collections.EMPTY_LIST.iterator();
        }
        return new CacheValuesIterator(this.indexs.cache, it);
    }

    @Override
    public void clear() {
        this._cacheMap.clear();
    }
}

