/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.formfile;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bpmn.engine.dao.ProcessRuntimeDaoFactory;
import com.actionsoft.bpms.bpmn.engine.model.run.TaskCommentTempModel;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.TaskInstance;
import com.actionsoft.bpms.commons.formfile.FileJsonValueProcessor;
import com.actionsoft.bpms.commons.formfile.ImageMarkLogoUtil;
import com.actionsoft.bpms.commons.formfile.dao.FormFileDao;
import com.actionsoft.bpms.commons.formfile.model.FormFileModel;
import com.actionsoft.bpms.commons.formfile.model.delegate.FormFile;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.server.fs.file.ReadDCFile;
import com.actionsoft.bpms.util.AES;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilImage;
import com.actionsoft.bpms.util.UtilSerialize;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class FormFileUtil {
    private static FormFileUtil helper = new FormFileUtil();
    private static String[] exts = new String[]{".doc", ".docx", ".wps", ".rtf", ".ppt", ".pptx", ".dps", ".pdf", ".txt", ".java", ".js", ".css", ".sh", ".bat", ".html", ".htm"};

    private FormFileUtil() {
    }

    public static FormFileUtil getInstance() {
        return helper;
    }

    public static int encryptFile(DCContext context, String path, String realPath) {
        int fileSize;
        block12: {
            fileSize = 0;
            String password = DCUtil.getSecurityKey(path);
            FileOutputStream out = null;
            FileInputStream in = null;
            File inFile = new File(realPath);
            File outFile = new File(path);
            try {
                try {
                    int len;
                    in = new FileInputStream(inFile);
                    out = new FileOutputStream(outFile);
                    fileSize = len = in.available();
                    if (len > 0) {
                        AES.encrypt((InputStream)in, (OutputStream)out, (String)password);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    try {
                        in.close();
                        in = null;
                        out.close();
                        out = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    inFile.delete();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    in = null;
                    out.close();
                    out = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                inFile.delete();
                throw throwable;
            }
            try {
                in.close();
                in = null;
                out.close();
                out = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            inFile.delete();
        }
        return fileSize / 1024;
    }

    public static File getTempThumbImageFile(DCContext dcContext, String origImgFileName) {
        File tempFile;
        block22: {
            String postfix = "";
            int postfixIdx = origImgFileName.lastIndexOf(".");
            if (postfixIdx != -1) {
                postfix = origImgFileName.substring(postfixIdx, origImgFileName.length());
            }
            ByteArrayInputStream data = (ByteArrayInputStream)ReadDCFile.getInstance().read(dcContext);
            OutputStream dos = null;
            FileOutputStream os = null;
            tempFile = null;
            try {
                try {
                    tempFile = File.createTempFile(origImgFileName, postfix);
                    int readSize = 0;
                    os = new FileOutputStream(tempFile);
                    dos = new DataOutputStream(os);
                    byte[] bytes = new byte[1024];
                    readSize = data.read(bytes);
                    while (readSize > 0) {
                        dos.write(bytes);
                        readSize = data.read(bytes);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (dos != null) {
                        try {
                            dos.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (os == null) break block22;
                    try {
                        os.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return tempFile;
    }

    public String getFileIcon(String fileName) {
        return UtilFile.getFileSuffixIcon(fileName);
    }

    public String getFileSize(long fileSize) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileSize < 1024L ? String.valueOf(df.format((double)fileSize)) + "B" : (fileSize < 0x100000L ? String.valueOf(df.format((double)fileSize / 1024.0)) + "KB" : (fileSize < 0x40000000L ? String.valueOf(df.format((double)fileSize / 1048576.0)) + "MB" : String.valueOf(df.format((double)fileSize / 1.073741824E9)) + "GB"));
        return fileSizeString;
    }

    public JSONObject getFileModelJSONObject(UserContext userContext, FormFile fileModel, String repositoryName, String clazz, String groupValue, String fileValue) {
        SerializeFilter[] filters = new SerializeFilter[]{new FileJsonValueProcessor()};
        JSONObject file = UtilSerialize.parseObject(JSONObject.toJSONString((Object)fileModel, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]));
        DCContext dcContext = new DCContext(userContext, DCProfileManager.getDCProfile(fileModel.getAppId(), repositoryName), fileModel.getAppId(), groupValue, fileValue, fileModel.getFileName());
        String downLoadUrl = dcContext.getDownloadURL();
        if (userContext.isMobileClient()) {
            downLoadUrl = this.getFileUrlForMobile(dcContext.getFileName(), userContext, dcContext);
        }
        file.put("downloadUrl", (Object)downLoadUrl);
        file.put("removeUrl", (Object)("<a href='#'  " + Html.toHtmlJSEvent("onclick", "AWSFormOpinionList.removeFile", new Object[]{fileModel.getId(), fileModel.getAppId(), fileModel.getBoId(), fileValue, fileModel.getFileName()}) + "><img src='../apps/_bpm.portal/img/cancel.png' title=\"" + I18nRes.findValue("_bpm.platform", "\u5220\u9664") + "\" />"));
        return file;
    }

    public JSONObject getFileModelJSONObjectPreview(UserContext userContext, FormFile fileModel, String repositoryName, String groupValue, String fileValue) {
        SerializeFilter[] filters = new SerializeFilter[]{new FileJsonValueProcessor()};
        JSONObject file = UtilSerialize.parseObject(JSONObject.toJSONString((Object)fileModel, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]));
        String fileName = fileModel.getFileName();
        StringBuilder fileInfo = new StringBuilder();
        String imgIcon = FormFileUtil.getInstance().getFileIcon(fileName);
        fileInfo.append("<img border=0 width='20' src='").append(imgIcon).append("' align='absmiddle'>&nbsp;");
        DCContext dcContext = new DCContext(userContext, DCProfileManager.getDCProfile(fileModel.getAppId(), repositoryName), fileModel.getAppId(), groupValue, fileValue, fileName);
        String downloadBtn = "";
        String downLoadUrl = dcContext.getDownloadURL();
        String titleText = "";
        String waterMarkFlag = FormFileUtil.getInstance().getPictureFlag(fileModel.getExt1(), "1");
        if (!repositoryName.equals("!form-comment-file-")) {
            titleText = waterMarkFlag.equals("1") ? String.valueOf(titleText) + I18nRes.findValue("_bpm.platform", "\u6709\u6c34\u5370") : String.valueOf(titleText) + I18nRes.findValue("_bpm.platform", "\u65e0\u6c34\u5370");
            String compressFlag = FormFileUtil.getInstance().getPictureFlag(fileModel.getExt1(), "2");
            titleText = compressFlag.equals("1") ? String.valueOf(titleText) + "&nbsp;&nbsp;" + I18nRes.findValue("_bpm.platform", "\u5df2\u538b\u7f29") : String.valueOf(titleText) + "&nbsp;&nbsp;" + I18nRes.findValue("_bpm.platform", "\u672a\u538b\u7f29");
        }
        if (userContext != null && userContext.isMobileClient()) {
            downLoadUrl = this.getFileUrlForMobilePreview(dcContext.getFileName(), userContext, dcContext);
            downloadBtn = "<a target=_blank href=\"" + downLoadUrl + " \"><span style='color:blue'>" + fileName + "</span></a>";
        } else {
            AppAPI appAPI = SDK.getAppAPI();
            AppContext appCtx = appAPI.getAppContext("com.actionsoft.apps.addons.onlinedoc");
            boolean canPreviewOfficeFlag = appCtx != null && SDK.getAppAPI().isActive(appCtx);
            canPreviewOfficeFlag = canPreviewOfficeFlag ? this.isSupportFormat(fileModel, appCtx, userContext) : false;
            String subfix = "";
            String extension = "";
            if (fileName.indexOf(".") > -1) {
                extension = fileName.substring(fileName.lastIndexOf("."), fileName.length());
            }
            if (!UtilString.isEmpty(extension) && extension.length() > 0) {
                subfix = extension.substring(1);
            }
            if (canPreviewOfficeFlag) {
                JSONObject groupValueJson = new JSONObject();
                groupValueJson.put("processInstId", (Object)fileModel.getProcessInstId());
                groupValueJson.put("taskInstId", (Object)fileModel.getTaskInstId());
                groupValueJson.put("boId", (Object)fileModel.getBoId());
                groupValueJson.put("formFileId", (Object)groupValue);
                groupValueJson.put("boItemName", (Object)fileModel.getBoItemName());
                downloadBtn = "<span style='color:blue;cursor:pointer;white-space: normal;' title='" + titleText + "' " + Html.toHtmlJSEvent("onclick", "AWSFile.officeFilePreview", new Object[]{downLoadUrl, fileModel.getFileName(), groupValueJson, repositoryName, fileModel.getAppId(), fileValue, 0, 1, 1, 2}) + ">" + fileName + "</span>";
            } else {
                downloadBtn = "<a target=_blank href=\"" + downLoadUrl + " \"><span style='color:blue;white-space: normal;' title='" + titleText + "'>" + fileName + "</span></a>";
            }
        }
        file.put("downloadBtn", (Object)fileInfo.append(downloadBtn));
        file.put("removeUrl", (Object)("<a href='#'  " + Html.toHtmlJSEvent("onclick", "AWSFormOpinionList.removeFile", new Object[]{fileModel.getId(), fileModel.getAppId(), fileModel.getBoId(), fileValue, fileModel.getFileName()}) + "><img src='../apps/_bpm.portal/img/cancel.png' title=\"" + I18nRes.findValue("_bpm.platform", "\u5220\u9664") + "\" />"));
        return file;
    }

    private boolean isSupportFormat(FormFile ff, AppContext appCtx, UserContext me) {
        String[] fs;
        String[] stringArray = fs = this.getSupportType(me, appCtx).split(",");
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (ff.getFileName().endsWith(f)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getSupportType(UserContext ctx, AppContext appCtx) {
        String support = "";
        AppAPI appAPI = SDK.getAppAPI();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sid", ctx.getSessionId());
        ResponseObject responseObject = appAPI.callASLP(appCtx, "aslp://com.actionsoft.apps.addons.onlinedoc/getSupportType", params);
        if (responseObject != null && responseObject.isOk() && responseObject.toJsonObject().get("data") != null) {
            support = responseObject.toJsonObject().getJSONObject("data").optString("supportType");
        }
        return support;
    }

    protected boolean isMobileWeb(UserContext me) {
        return me != null && me.getDeviceType().equalsIgnoreCase("weixin") || me.getDeviceType().equalsIgnoreCase("mobileweb");
    }

    protected boolean isMobileAndroid(UserContext me) {
        String userAgent;
        return me.isMobileClient() && (userAgent = DispatcherRequest.getContext().getUserAgent()).toLowerCase().contains("android");
    }

    private boolean matchExt(String fileName) {
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (fileName.endsWith(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getFileUrlForMobilePreview(String fileName, UserContext me, DCContext dcContext) {
        if (this.isMobileWeb(me) || this.isMobileAndroid(me)) {
            if (SDK.getAppAPI().isActive("com.actionsoft.apps.addons.onlinedoc")) {
                if (this.matchExt(fileName)) {
                    String url;
                    AppAPI appAPI = SDK.getAppAPI();
                    String sourceAppId = "_bpm.platform";
                    String formFileId = dcContext.getGroupValue();
                    FormFile formFielModel = (FormFile)new FormFileDao().queryById(formFileId);
                    boolean isEncrypt = FormFileUtil.getInstance().isEncrypt(formFielModel.getBoItemName(), formFielModel.getBoName());
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("sid", me.getSessionId());
                    params.put("fileNameOriginal", fileName);
                    params.put("sourceDc", dcContext);
                    params.put("isCopy", false);
                    params.put("isPrint", false);
                    params.put("isEncrypt", isEncrypt);
                    params.put("isDownload", false);
                    params.put("isShowDefaultToolbar", false);
                    ResponseObject responseObject = appAPI.callASLP(appAPI.getAppContext(sourceAppId), "aslp://com.actionsoft.apps.addons.onlinedoc/filePreview", params);
                    if (responseObject != null && responseObject.isOk() && !UtilString.isEmpty(url = responseObject.get("url").toString())) {
                        if (url.startsWith("./w")) {
                            url = String.valueOf(SDK.getConfAPI().getMobileUrl()) + "/r" + url.substring(1);
                        }
                        return String.valueOf(url) + "&openNewWebview=true";
                    }
                }
            } else if (SDK.getAppAPI().isActive("com.actionsoft.apps.poi.converter") && (fileName.endsWith(".doc") || fileName.endsWith(".docx") || fileName.endsWith(".ppt") || fileName.endsWith(".pptx") || fileName.endsWith(".xls") || fileName.endsWith(".xlsx") || fileName.endsWith(".pdf"))) {
                String url;
                String aslp = "aslp://com.actionsoft.apps.poi.converter/fileToHTML";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("dcContext", dcContext.toJson());
                params.put("sid", me.getSessionId());
                ResponseObject ro = SDK.getAppAPI().callASLP(SDK.getAppAPI().getAppContext("com.actionsoft.apps.poi.converter"), aslp, params);
                if (ro.isOk() && !UtilString.isEmpty(url = (String)ro.get("url"))) {
                    return String.valueOf(url) + "&openNewWebview=true";
                }
            }
        }
        return String.valueOf(dcContext.getDownloadURL()) + "&mobileAttachment=true";
    }

    private String getFileUrlForMobile(String fileName, UserContext me, DCContext dcContext) {
        AppContext appContext = SDK.getAppAPI().getAppContext("com.actionsoft.apps.poi.converter");
        if (appContext != null && (fileName.endsWith(".doc") || fileName.endsWith(".docx") || fileName.endsWith(".ppt") || fileName.endsWith(".pptx") || fileName.endsWith(".xls") || fileName.endsWith(".xlsx") || fileName.endsWith(".pdf"))) {
            String url;
            String aslp = "aslp://com.actionsoft.apps.poi.converter/fileToHTML";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dcContext", dcContext.toJson());
            params.put("sid", me.getSessionId());
            ResponseObject ro = SDK.getAppAPI().callASLP(SDK.getAppAPI().getAppContext("com.actionsoft.apps.poi.converter"), aslp, params);
            if (ro.isOk() && !UtilString.isEmpty(url = (String)ro.get("url"))) {
                return url;
            }
        }
        return String.valueOf(dcContext.getDownloadURL()) + "&mobileAttachment=true";
    }

    public FormFileModel createFormFileModel(UserContext me, String appId, String fileName, String boItemName, long fileSize, String boId, String processId, String taskId, int cnt, String groupValue, String fileValue, String repositoryName) {
        FormFileModel fileModel = new FormFileModel();
        fileModel.setAppId(appId);
        fileModel.setBoItemName(boItemName);
        fileModel.setFileSize(fileSize);
        fileModel.setFileName(fileName);
        fileModel.setBoId(boId);
        fileModel.setCreateDate(new Timestamp(new Date().getTime()));
        fileModel.setRemark("");
        fileModel.setCreateUser(me.getUserName());
        fileModel.setExt1("");
        fileModel.setTaskInstId(taskId);
        fileModel.setProcessInstId(processId);
        FormFileDao fileDao = new FormFileDao();
        int flag = fileDao.insert(fileModel);
        if (flag > 0) {
            return fileModel;
        }
        return null;
    }

    public String removeFile(UserContext me, String id, String appId, String boDefId, String boItemName, String fileName) {
        return this.removeFile(me, id, appId, boDefId, boItemName, fileName, null);
    }

    public String removeFile(UserContext me, String id, String appId, String boDefId, String boItemName, String fileName, Connection conn) {
        ResponseObject object = ResponseObject.newOkResponse();
        FormFileDao dao = new FormFileDao();
        FormFile formFile = (FormFile)dao.queryById(conn, id);
        if (formFile != null) {
            String processInstId = formFile.getProcessInstId();
            String boId = formFile.getBoId();
            List list = dao.query(conn, "PROCESSINSTID=? AND FILENAME=? AND BOID=? AND BOFIELDNAME=?", processInstId, fileName, boId, boItemName).list();
            MD5 md5 = new MD5();
            for (FormFile formFileModel : list) {
                id = formFileModel.getId();
                if (formFileModel != null) {
                    dao.delete(conn, id);
                }
                BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
                String repository = "!form-ui-file-";
                if (boItemName.equals("__AWSCommentFile__")) {
                    repository = "!form-comment-file-";
                }
                DCContext dcContext = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, id, boItemName, fileName);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boDefId", boDefId);
                params.put("boItemName", boItemName);
                dcContext.setExtParams(params);
                dcContext.delete();
                DCContext dcContext2 = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, id, boItemName, String.valueOf(md5.toDigest(fileName)) + "picturelogo_thum.jpg");
                dcContext2.setExtParams(params);
                if (dcContext2.existFile()) {
                    dcContext2.delete();
                }
                object.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
            }
        }
        return object.toString();
    }

    public String updateFileValue(UserContext me, String uuId, String extkey, String value) {
        ResponseObject object = ResponseObject.newOkResponse();
        FormFileDao fileDao = new FormFileDao();
        fileDao.update(uuId, extkey, value);
        object.msg(I18nRes.findValue("_bpm.platform", "\u4fdd\u5b58\u6210\u529f"));
        return object.toString();
    }

    public String updatePictureFlag(String extVal, String key, String value) {
        String[] arr = extVal.split(",");
        if (!UtilString.isEmpty(key) && key.equals("1")) {
            if (arr.length == 2 && arr[0].length() == 2) {
                String status = this.toReplace(arr[0], value, 0);
                extVal = String.valueOf(status) + "," + arr[1];
            }
        } else if (!UtilString.isEmpty(key) && key.equals("2")) {
            if (arr.length == 2 && arr[0].length() == 2) {
                String status = this.toReplace(arr[0], value, 1);
                extVal = String.valueOf(status) + "," + arr[1];
            }
        } else if (!UtilString.isEmpty(key) && key.equals("3") && arr.length == 2) {
            extVal = String.valueOf(arr[0]) + "," + value;
        }
        return extVal;
    }

    public String getPictureFlag(String extVal, String key) {
        String value = "";
        String[] arr = extVal.split(",");
        if (!UtilString.isEmpty(key) && key.equals("1")) {
            if (arr.length == 2 && arr[0].length() == 2) {
                value = arr[0].substring(0, 1);
            }
        } else if (!UtilString.isEmpty(key) && key.equals("2")) {
            if (arr.length == 2 && arr[0].length() == 2) {
                value = arr[0].substring(1);
            }
        } else if (!UtilString.isEmpty(key) && key.equals("3") && arr.length == 2) {
            value = arr[1];
        }
        return value;
    }

    public String toReplace(String status, String s, int index) {
        StringBuffer bstatus = new StringBuffer("");
        if (s != null && !"".equals(s) && index >= 0 && index <= 1) {
            if (status == null || "".equals(status)) {
                status = "00";
            }
            String ptemp = status.substring(0, index);
            String ntemp = "";
            if (index != 1) {
                ntemp = status.substring(index + 1 == 2 ? index : index + 1);
            }
            bstatus.append(ptemp);
            bstatus.append(s);
            bstatus.append(ntemp);
            status = bstatus.toString();
        }
        return status;
    }

    public String addWaterMark(UserContext me, String id, String appId, String boDefId, String boItemName, String fileName, String waterMarkFontColor, Integer waterMarkFontSize, String waterMarkPosition) {
        ResponseObject result = ResponseObject.newOkResponse();
        MD5 md5 = new MD5();
        String repository = "!form-ui-file-";
        DCContext originalDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, id, boItemName, fileName);
        if (!originalDc.isCloud()) {
            result.put("isCloud", false);
            String path = originalDc.getPath();
            BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
            boolean isEncrypt = FormFileUtil.getInstance().isEncrypt(boItemName, boModel.getName());
            String logoPathStr = FormFileUtil.getInstance().getWaterMarkPathByComponentSetting(boItemName, boModel.getName());
            String targetFileName = String.valueOf(md5.toDigest(fileName)) + "picturelogo_thum.jpg";
            String targetFilePath = String.valueOf(path) + targetFileName;
            String sourcePath = String.valueOf(path) + originalDc.getFileName();
            DCContext thumDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, id, boItemName, targetFileName);
            if (this.existFormUiFile(thumDc, isEncrypt)) {
                sourcePath = targetFilePath;
                originalDc.setFileName(targetFileName);
            }
            try {
                DCUtil.getInstance();
                String origImgFileName = DCUtil.encryptFileName(originalDc.getFileName());
                File tempFile = FormFileUtil.getTempThumbImageFile(originalDc, origImgFileName);
                sourcePath = tempFile.getPath();
                if (!UtilString.isEmpty(logoPathStr)) {
                    String logoContentStr = SDK.getRuleAPI().executeAtScript("@loadFile(" + appId + "," + logoPathStr + ")");
                    if (!UtilString.isEmpty(logoContentStr)) {
                        AppContext app = SDK.getAppAPI().getAppContext(appId);
                        String appPath = app.getPath();
                        String waterMarkPath = String.valueOf(appPath) + logoPathStr;
                        ImageMarkLogoUtil.markImageByIcon(waterMarkPath, sourcePath, targetFilePath, -1, -1, waterMarkPosition);
                    } else {
                        if (UtilString.isEmpty(waterMarkFontSize)) {
                            waterMarkFontSize = 20;
                        }
                        FormFileDao fileDao = new FormFileDao();
                        FormFile ff = (FormFile)fileDao.queryById(id);
                        String taskInstId = ff.getTaskInstId();
                        String processInstId = ff.getProcessInstId();
                        String atgstr = SDK.getRuleAPI().executeAtScript(logoPathStr, me, processInstId, taskInstId, null);
                        ImageMarkLogoUtil.markImageByText(atgstr, sourcePath, targetFilePath, waterMarkFontColor, waterMarkFontSize, waterMarkPosition);
                    }
                }
                if (isEncrypt) {
                    DCUtil.getInstance();
                    String newFileName = DCUtil.encryptFileName(targetFileName);
                    String path1 = String.valueOf(path) + newFileName;
                    FormFileUtil.encryptFile(thumDc, path1, targetFilePath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String pictureLogoThumDownLoadUrl = thumDc.getDownloadURL();
            result.put("pictureLogoThumDownLoadUrl", pictureLogoThumDownLoadUrl);
            FormFileDao dao = new FormFileDao();
            FormFileModel formFileModel = (FormFileModel)dao.queryById(id);
            if (formFileModel != null) {
                String extVal = "10,610";
                if (!UtilString.isEmpty(formFileModel.getExt1())) {
                    extVal = formFileModel.getExt1();
                }
                extVal = this.updatePictureFlag(extVal, "1", "1");
                this.updateFileValue(me, id, "EXT1", extVal);
            }
        } else {
            result.put("isCloud", true);
            result.put("msg", I18nRes.findValue("_bpm.platform", "\u4e91\u6587\u6863\u4e0d\u652f\u6301\u538b\u7f29"));
        }
        return result.toString();
    }

    public String compressFile(UserContext me, String id, String appId, String boDefId, String boItemName, String fileName, String compressWidth) {
        ResponseObject result = ResponseObject.newOkResponse();
        MD5 md5 = new MD5();
        try {
            String fixedCompressWidth = "610";
            BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
            String compressDefWidth = FormFileUtil.getInstance().fixedCompressWidth(boItemName, boModel.getName());
            if (!UtilString.isEmpty(compressDefWidth)) {
                fixedCompressWidth = compressDefWidth;
            }
            if (!UtilString.isEmpty(compressWidth)) {
                fixedCompressWidth = compressWidth;
            }
            boolean isEncrypt = FormFileUtil.getInstance().isEncrypt(boItemName, boModel.getName());
            String repository = "!form-ui-file-";
            DCContext originalDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, id, boItemName, fileName);
            if (!originalDc.isCloud()) {
                result.put("isCloud", false);
                String path = originalDc.getPath();
                String origImgFileName = originalDc.getFileName();
                String targetFileName = String.valueOf(md5.toDigest(fileName)) + "picturelogo_thum.jpg";
                String targetFilePath = String.valueOf(path) + targetFileName;
                File originalFile = FormFileUtil.getTempThumbImageFile(originalDc, origImgFileName);
                DCContext thumDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, id, boItemName, targetFileName);
                String srcFilePath = originalFile.getPath();
                if (this.existFormUiFile(thumDc, isEncrypt)) {
                    File targetFile = FormFileUtil.getTempThumbImageFile(thumDc, thumDc.getFileName());
                    srcFilePath = targetFile.getPath();
                }
                String srcFilePathName = srcFilePath;
                if (fixedCompressWidth.contains("%")) {
                    NumberFormat nf = NumberFormat.getPercentInstance();
                    Number m = nf.parse(fixedCompressWidth);
                    float fWidth = m.floatValue();
                    UtilImage.zoom(srcFilePathName, targetFilePath, fWidth);
                } else {
                    UtilImage.zoomW(srcFilePathName, targetFilePath, Integer.parseInt(fixedCompressWidth));
                }
                if (isEncrypt) {
                    DCUtil.getInstance();
                    String newFileName = DCUtil.encryptFileName(targetFileName);
                    String path1 = String.valueOf(path) + newFileName;
                    FormFileUtil.encryptFile(thumDc, path1, targetFilePath);
                }
                String pictureLogoThumDownLoadUrl = thumDc.getDownloadURL();
                result.put("pictureLogoThumDownLoadUrl", pictureLogoThumDownLoadUrl);
                FormFileDao dao = new FormFileDao();
                FormFileModel formFileModel = (FormFileModel)dao.queryById(id);
                if (formFileModel != null) {
                    String extVal = "01,610";
                    if (!UtilString.isEmpty(formFileModel.getExt1())) {
                        extVal = formFileModel.getExt1();
                    }
                    extVal = this.updatePictureFlag(extVal, "2", "1");
                    extVal = this.updatePictureFlag(extVal, "3", String.valueOf(fixedCompressWidth));
                    this.updateFileValue(me, id, "EXT1", extVal);
                }
            } else {
                result.put("isCloud", true);
                result.put("msg", I18nRes.findValue("_bpm.platform", "\u4e91\u6587\u6863\u4e0d\u652f\u6301\u538b\u7f29"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.err(e);
        }
        return result.toString();
    }

    public String compressFileUtil(UserContext me, String appId, String boDefId, String boItemName, String groupValue, String repository, String fileValue, String fileName, String compressWidth) {
        ResponseObject result = ResponseObject.newOkResponse();
        MD5 md5 = new MD5();
        try {
            int compressConWidth;
            int fixedCompressWidth = 610;
            BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
            String compressDefWidth = FormFileUtil.getInstance().fixedCompressWidth(boItemName, boModel.getName());
            if (!UtilString.isEmpty(compressDefWidth)) {
                fixedCompressWidth = Integer.parseInt(compressDefWidth);
            }
            if (!UtilString.isEmpty(compressWidth) && (compressConWidth = Integer.parseInt(compressWidth)) <= fixedCompressWidth) {
                fixedCompressWidth = compressConWidth;
            }
            if (UtilString.isEmpty(repository)) {
                repository = "-form-ui-editor-";
            }
            boolean isEncrypt = FormFileUtil.getInstance().isEncrypt(boItemName, boModel.getName());
            DCContext originalDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, groupValue, fileValue, fileName);
            String pictureLogoThumDownLoadUrl = originalDc.getDownloadURL();
            if (!originalDc.isCloud()) {
                String path = originalDc.getPath();
                String origImgFileName = originalDc.getFileName();
                String targetFileName = String.valueOf(md5.toDigest(fileName)) + "picturelogo_thum.jpg";
                String targetFilePath = String.valueOf(path) + targetFileName;
                File originalFile = FormFileUtil.getTempThumbImageFile(originalDc, origImgFileName);
                DCContext thumDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, groupValue, fileValue, targetFileName);
                if (this.existFormUiFile(thumDc, isEncrypt)) {
                    File targetFile = FormFileUtil.getTempThumbImageFile(thumDc, thumDc.getFileName());
                    UtilImage.zoomW(targetFile.getPath(), targetFilePath, fixedCompressWidth);
                } else {
                    UtilImage.zoomW(originalFile.getPath(), targetFilePath, fixedCompressWidth);
                }
                if (isEncrypt) {
                    DCUtil.getInstance();
                    String newFileName = DCUtil.encryptFileName(targetFileName);
                    String path1 = String.valueOf(path) + newFileName;
                    FormFileUtil.encryptFile(thumDc, path1, targetFilePath);
                }
                pictureLogoThumDownLoadUrl = thumDc.getDownloadURL();
            }
            result.put("pictureLogoThumDownLoadUrl", pictureLogoThumDownLoadUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public String addWaterMarkUtil(UserContext me, String appId, String boDefId, String boItemName, String groupValue, String repository, String fileValue, String fileName, String waterMarkFontColor, Integer waterMarkFontSize, String waterMarkPosition) {
        ResponseObject result = ResponseObject.newOkResponse();
        MD5 md5 = new MD5();
        if (UtilString.isEmpty(repository)) {
            repository = "-form-ui-editor-";
        }
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
        boolean isEncrypt = FormFileUtil.getInstance().isEncrypt(boItemName, boModel.getName());
        DCContext originalDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, groupValue, fileValue, fileName);
        String path = originalDc.getPath();
        String logoPathStr = FormFileUtil.getInstance().getWaterMarkPathByComponentSetting(boItemName, boModel.getName());
        String targetFileName = String.valueOf(md5.toDigest(fileName)) + "picturelogo_thum.jpg";
        String targetFilePath = String.valueOf(path) + targetFileName;
        String sourcePath = String.valueOf(path) + originalDc.getFileName();
        DCContext thumDc = new DCContext(me, DCProfileManager.getDCProfile(appId, repository), appId, groupValue, fileValue, targetFileName);
        if (this.existFormUiFile(thumDc, isEncrypt)) {
            sourcePath = targetFilePath;
            originalDc.setFileName(targetFileName);
        }
        try {
            DCUtil.getInstance();
            String origImgFileName = DCUtil.encryptFileName(originalDc.getFileName());
            File tempFile = FormFileUtil.getTempThumbImageFile(originalDc, origImgFileName);
            sourcePath = tempFile.getPath();
            if (!UtilString.isEmpty(logoPathStr)) {
                String logoContentStr = SDK.getRuleAPI().executeAtScript("@loadFile(" + appId + "," + logoPathStr + ")");
                if (!UtilString.isEmpty(logoContentStr)) {
                    AppContext app = SDK.getAppAPI().getAppContext(appId);
                    String appPath = app.getPath();
                    String waterMarkPath = String.valueOf(appPath) + logoPathStr;
                    ImageMarkLogoUtil.markImageByIcon(waterMarkPath, sourcePath, targetFilePath, -1, -1, waterMarkPosition);
                } else {
                    if (UtilString.isEmpty(waterMarkFontSize)) {
                        waterMarkFontSize = 20;
                    }
                    String taskInstId = groupValue;
                    TaskInstance ti = SDK.getTaskAPI().getInstanceById(taskInstId);
                    String processInstId = ti.getProcessInstId();
                    String atstr = SDK.getRuleAPI().executeAtScript(logoPathStr, me, processInstId, taskInstId, null);
                    ImageMarkLogoUtil.markImageByText(atstr, sourcePath, targetFilePath, waterMarkFontColor, waterMarkFontSize, waterMarkPosition);
                }
            }
            if (isEncrypt) {
                DCUtil.getInstance();
                String newFileName = DCUtil.encryptFileName(targetFileName);
                String path1 = String.valueOf(path) + newFileName;
                FormFileUtil.encryptFile(thumDc, path1, targetFilePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String pictureLogoThumDownLoadUrl = thumDc.getDownloadURL();
        result.put("pictureLogoThumDownLoadUrl", pictureLogoThumDownLoadUrl);
        return result.toString();
    }

    public boolean existFormUiFile(DCContext context, boolean isEncrypt) {
        if (UtilString.isEmpty(context.getFileName())) {
            return false;
        }
        String realPath = String.valueOf(context.getPath()) + context.getFileName();
        if (isEncrypt) {
            DCUtil.getInstance();
            String newFileName = DCUtil.encryptFileName(context.getFileName());
            realPath = String.valueOf(context.getPath()) + newFileName;
        }
        File file = new File(realPath);
        return file.exists();
    }

    public String previewFile(UserContext me, String repositoryName, String appId, String groupValue, String fileValue, String fileName, String editType, String copyType, String printType, String localType, boolean isEncrypt) {
        ResponseObject result = ResponseObject.newOkResponse();
        JSONObject groupValueObj = JSONObject.parseObject((String)groupValue);
        if (SDK.getAppAPI().isActive("com.actionsoft.apps.addons.onlinedoc")) {
            AppAPI appAPI = SDK.getAppAPI();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sid", me.getSessionId());
            params.put("fileNameOriginal", fileName);
            List<FormFile> formFiles = null;
            FormFileDao dao = new FormFileDao();
            if ("__AWSCommentFile__".equals(fileValue)) {
                repositoryName = "!form-comment-file-";
                isEncrypt = true;
                JSONObject processParams = JSONObject.parseObject((String)groupValue);
                TaskCommentTempModel taskCommentTempModel = ProcessRuntimeDaoFactory.createTaskCommentTemp().getInstanceByTask(processParams.getString("taskInstId"));
                formFiles = taskCommentTempModel != null ? dao.queryByBoFieldName(taskCommentTempModel.getId(), processParams.getString("boItemName")) : dao.queryCommentFiles(processParams.getString("taskInstId"), processParams.getString("boId"));
            } else {
                String boId = groupValueObj.getString("boId");
                formFiles = dao.queryByBoFieldName(boId, fileValue);
                if (formFiles.size() > 0) {
                    isEncrypt = FormFileUtil.getInstance().isEncrypt(fileValue, formFiles.get(0).getBoName());
                }
            }
            DCContext sourceDc = null;
            for (FormFile ff : formFiles) {
                if (!ff.getId().equals(groupValueObj.getString("formFileId"))) continue;
                sourceDc = "__AWSCommentFile__".equals(fileValue) ? new DCContext(me, DCProfileManager.getDCProfile(appId, repositoryName), appId, ff.getId(), fileValue, fileName) : SDK.getBOAPI().getFileDCContext(ff, repositoryName);
            }
            params.put("sourceDc", sourceDc);
            params.put("isShowDefaultToolbar", true);
            params.put("isCopy", "1".equals(copyType));
            params.put("isPrint", "1".equals(printType));
            params.put("isDownload", "2".equals(localType));
            params.put("isEncrypt", isEncrypt);
            params.put("isShowBackbtn", false);
            ResponseObject responseObject = appAPI.callASLP(SDK.getAppAPI().getAppContext("com.actionsoft.apps.addons.onlinedoc"), "aslp://com.actionsoft.apps.addons.onlinedoc/filePreview", params);
            if (responseObject != null) {
                if (responseObject.isOk()) {
                    String url = responseObject.get("url").toString();
                    result.put("url", url);
                } else {
                    result = ResponseObject.newErrResponse(I18nRes.findValue("_bpm.platform", "\u6587\u6863\u9884\u89c8\u670d\u52a1\u4e0d\u53ef\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
                }
            }
        } else {
            result = ResponseObject.newErrResponse(I18nRes.findValue("_bpm.platform", "\u6587\u6863\u9884\u89c8\u670d\u52a1\u4e0d\u53ef\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return result.toString();
    }

    private void deleteDir(File fDir) {
        if (fDir.getName().equals("!form-ui-file-") || fDir.getName().equals("!form-comment-file-")) {
            return;
        }
        File pDir = fDir.getParentFile();
        if (fDir.getName().equals("!form-ui-file-") || fDir.getName().equals("!form-comment-file-")) {
            return;
        }
        if (fDir.list() != null && fDir.list().length == 0) {
            fDir.delete();
        }
        this.deleteDir(pDir);
    }

    public String addComment(UserContext me, String uuId, String remark) {
        ResponseObject object = ResponseObject.newOkResponse();
        FormFileDao fileDao = new FormFileDao();
        try {
            fileDao.update(uuId, remark);
            object.msg(I18nRes.findValue("_bpm.platform", "\u4fdd\u5b58\u6210\u529f"));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage().indexOf("Data too long") > 0) {
                object.err(I18nRes.findValue("_bpm.platform", "\u5907\u6ce8\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7\u4e2a\u5b57\u7b26"));
            }
            object.err(I18nRes.findValue("_bpm.platform", "\u4fdd\u5b58\u5931\u8d25"));
        }
        return object.toString();
    }

    public boolean isEncrypt(String boItemName, String boName) {
        BOItemModel boItemModel = BOCache.getInstance().getBOItemModelByBOName(boName, boItemName);
        if (boItemModel == null) {
            return true;
        }
        String componentSetting = boItemModel.getComponentSetting();
        JSONObject object = null;
        object = !UtilString.isEmpty(componentSetting) && !"\"\"".equals(componentSetting) ? UtilSerialize.parseObject(componentSetting) : new JSONObject();
        boolean isEncrypt = object.get((Object)"isEncrypt") == null ? true : object.getBooleanValue("isEncrypt");
        return isEncrypt;
    }

    public String fixedCompressWidth(String boItemName, String boName) {
        BOItemModel boItemModel = BOCache.getInstance().getBOItemModelByBOName(boName, boItemName);
        if (boItemModel == null) {
            return "";
        }
        String componentSetting = boItemModel.getComponentSetting();
        JSONObject object = null;
        object = !UtilString.isEmpty(componentSetting) && !"\"\"".equals(componentSetting) ? UtilSerialize.parseObject(componentSetting) : new JSONObject();
        String fixedCompressWidth = object.getString("compressFlag");
        return fixedCompressWidth;
    }

    public String getWaterMarkPathByComponentSetting(String boItemName, String boName) {
        BOItemModel boItemModel = BOCache.getInstance().getBOItemModelByBOName(boName, boItemName);
        if (boItemModel == null) {
            return "";
        }
        String componentSetting = boItemModel.getComponentSetting();
        JSONObject object = null;
        object = !UtilString.isEmpty(componentSetting) && !"\"\"".equals(componentSetting) ? UtilSerialize.parseObject(componentSetting) : new JSONObject();
        String waterMarkPath = object.getString("waterMarkFlag");
        return waterMarkPath;
    }

    public String downLoadBatchFiles(UserContext me, String formFileIds) {
        ResponseObject rs = ResponseObject.newOkResponse();
        if (!UtilString.isEmpty(formFileIds)) {
            List<String> formFileId = Arrays.asList(formFileIds.split(","));
            ArrayList<DCContext> list = new ArrayList<DCContext>();
            FormFileDao dao = new FormFileDao();
            for (String id : formFileId) {
                FormFile formFile = (FormFile)dao.queryById(id);
                list.add(SDK.getBOAPI().getFileDCContext(formFile));
            }
            try {
                long times = System.currentTimeMillis();
                DCPluginProfile dcProfile = DCProfileManager.getDCProfile("_bpm.platform", "tmp");
                String zipName = String.valueOf(times) + ".zip";
                DCContext zipDcContext = new DCContext(me, dcProfile, "_bpm.platform", "grouppackage", "zip" + times, zipName);
                String targetDir = zipDcContext.getPath();
                rs = DCUtil.downloadPackage(me, list, targetDir, zipName, "tmp");
            }
            catch (Exception e) {
                rs = ResponseObject.newErrResponse();
            }
        }
        return rs.toString();
    }
}

