/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.formfile;

import com.actionsoft.bpms.util.UtilString;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ImageMarkLogoUtil {
    private static float alpha = 1.0f;
    private static int positionWidth = 50;
    private static int positionHeight = 50;
    private static Font font = new Font("\u5b8b\u4f53", 1, 30);
    private static Color color = Color.white;

    public static void setImageMarkOptions(float alpha, int positionWidth, int positionHeight, Font font, Color color) {
        if (alpha != 0.0f) {
            ImageMarkLogoUtil.alpha = alpha;
        }
        if (positionWidth != 0) {
            ImageMarkLogoUtil.positionWidth = positionWidth;
        }
        if (positionHeight != 0) {
            ImageMarkLogoUtil.positionHeight = positionHeight;
        }
        if (font != null) {
            ImageMarkLogoUtil.font = font;
        }
        if (color != null) {
            ImageMarkLogoUtil.color = color;
        }
    }

    public static void markImageByIcon(String iconPath, String srcImgPath, String targerPath, int positionWidth, int positionHeight, String waterMarkPosition) {
        ImageMarkLogoUtil.markImageByIcon(iconPath, srcImgPath, targerPath, null, positionWidth, positionHeight, waterMarkPosition);
    }

    public static void markImageByIcon(String iconPath, String srcImgPath, String targerPath, Integer degree, int positionWidth, int positionHeight, String waterMarkPosition) {
        OutputStream os = null;
        try {
            try {
                int logoHeight;
                int logoWidth;
                BufferedImage srcImg = ImageIO.read(new File(srcImgPath));
                BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
                Graphics2D g = buffImg.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
                if (degree != null) {
                    g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
                }
                ImageIcon imgIcon = new ImageIcon(iconPath);
                Image img = imgIcon.getImage();
                BufferedImage buffIconImg = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                if (!UtilString.isEmpty(positionWidth) && positionWidth == -1) {
                    logoWidth = buffIconImg.getWidth();
                    positionWidth = buffImg.getWidth() - logoWidth;
                }
                if (!UtilString.isEmpty(positionHeight) && positionHeight == -1) {
                    logoHeight = buffIconImg.getHeight();
                    positionHeight = buffImg.getHeight() - logoHeight;
                }
                if ("lefttop".equals(waterMarkPosition)) {
                    positionWidth = 0;
                    positionHeight = 0;
                } else if ("leftbottom".equals(waterMarkPosition)) {
                    positionWidth = 0;
                    logoHeight = buffIconImg.getHeight();
                    positionHeight = buffImg.getHeight() - logoHeight;
                } else if ("righttop".equals(waterMarkPosition)) {
                    logoWidth = buffIconImg.getWidth();
                    positionWidth = buffImg.getWidth() - logoWidth;
                    positionHeight = 0;
                } else {
                    logoWidth = buffIconImg.getWidth();
                    positionWidth = buffImg.getWidth() - logoWidth;
                    int logoHeight2 = buffIconImg.getHeight();
                    positionHeight = buffImg.getHeight() - logoHeight2;
                }
                g.drawImage(img, positionWidth, positionHeight, null);
                g.setComposite(AlphaComposite.getInstance(3));
                g.dispose();
                os = new FileOutputStream(targerPath);
                ImageIO.write((RenderedImage)buffImg, "JPG", os);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void markImageByText(String logoText, String srcImgPath, String targerPath, String waterMarkFontColor, int waterMarkFontSize, String waterMarkPosition) {
        ImageMarkLogoUtil.markImageByText(logoText, srcImgPath, targerPath, null, waterMarkFontColor, waterMarkFontSize, waterMarkPosition);
    }

    public static void markImageByText(String logoText, String srcImgPath, String targerPath, Integer degree, String waterMarkFontColor, int waterMarkFontSize, String waterMarkPosition) {
        InputStream is = null;
        OutputStream os = null;
        try {
            try {
                BufferedImage srcImg = ImageIO.read(new File(srcImgPath));
                BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
                Graphics2D g = buffImg.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
                if (degree != null) {
                    g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
                }
                font = new Font("\u5b8b\u4f53", 1, waterMarkFontSize);
                if ("orange".equals(waterMarkFontColor)) {
                    color = Color.orange;
                } else if ("gray".equals(waterMarkFontColor)) {
                    color = Color.gray;
                } else if ("black".equals(waterMarkFontColor)) {
                    color = Color.black;
                } else if ("red".equals(waterMarkFontColor)) {
                    color = Color.red;
                } else if ("yellow".equals(waterMarkFontColor)) {
                    color = Color.yellow;
                } else if ("blue".equals(waterMarkFontColor)) {
                    color = Color.blue;
                } else if ("white".equals(waterMarkFontColor)) {
                    color = Color.white;
                }
                FontMetrics fm = new JLabel().getFontMetrics(font);
                int textwidth = fm.stringWidth(logoText);
                if ("lefttop".equals(waterMarkPosition)) {
                    positionWidth = 0;
                    positionHeight = 20;
                } else if ("leftbottom".equals(waterMarkPosition)) {
                    positionWidth = 0;
                    positionHeight = buffImg.getHeight() - 20;
                } else if ("righttop".equals(waterMarkPosition)) {
                    positionWidth = textwidth <= buffImg.getWidth() ? buffImg.getWidth() - textwidth : 5;
                    positionHeight = 30;
                } else {
                    positionWidth = textwidth <= buffImg.getWidth() ? buffImg.getWidth() - textwidth : 5;
                    positionHeight = buffImg.getHeight() - 20;
                }
                g.setColor(color);
                g.setFont(font);
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                g.drawString(logoText, positionWidth, positionHeight);
                g.dispose();
                os = new FileOutputStream(targerPath);
                ImageIO.write((RenderedImage)buffImg, "JPG", os);
                System.out.println("\u56fe\u7247\u5b8c\u6210\u6dfb\u52a0\u6c34\u5370\u6587\u5b57");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String srcImgPath = "d:/test/source.png";
        String logoText = "\u591c\u7684\u9759\u5374\u6709\u591c\u7684\u8033\u5728\u542c";
        String iconPath = "d:/test/logo.png";
        String targerTextPath = "d:/test/qie_text.jpg";
        String targerTextPath2 = "d:/test/qie_text_rotate.jpg";
        String targerIconPath = "d:/test/qie_icon.jpg";
        String targerIconPath2 = "d:/test/qie_icon_rotate.jpg";
        System.out.println("\u7ed9\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u6587\u5b57\u5f00\u59cb...");
        ImageMarkLogoUtil.markImageByText(logoText, srcImgPath, targerTextPath, "res", 20, "lefttop");
        ImageMarkLogoUtil.markImageByText(logoText, srcImgPath, targerTextPath2, -45, "red", 20, "lefttop");
        System.out.println("\u7ed9\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u6587\u5b57\u7ed3\u675f...");
        System.out.println("\u7ed9\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u56fe\u7247\u5f00\u59cb...");
        ImageMarkLogoUtil.setImageMarkOptions(0.3f, 1, 1, null, null);
        ImageMarkLogoUtil.markImageByIcon(iconPath, srcImgPath, targerIconPath, 50, 50, "lefttop");
        ImageMarkLogoUtil.markImageByIcon(iconPath, srcImgPath, targerIconPath2, -45, 50, 50, "lefttop");
        System.out.println("\u7ed9\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u56fe\u7247\u7ed3\u675f...");
    }
}

