/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.formfile.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.formfile.model.FormFileModel;
import com.actionsoft.bpms.commons.formfile.model.delegate.FormFile;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class FormFileDao
extends DaoObject<FormFile> {
    @Override
    public int insert(FormFile model) throws AWSDataAccessException {
        if (UtilString.isEmpty(model.getId())) {
            ((FormFileModel)model).setId(UUIDGener.getUUID());
            ((FormFileModel)model).setCreateDate(new Timestamp(new Date().getTime()));
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ID", model.getId());
        paraMap.put("APPID", model.getAppId());
        paraMap.put("PROCESSINSTID", model.getProcessInstId());
        paraMap.put("TASKINSTID", model.getTaskInstId());
        paraMap.put("BOID", model.getBoId());
        paraMap.put("BONAME", model.getBoName());
        paraMap.put("BOFIELDNAME", model.getBoItemName());
        paraMap.put("CREATEDATE", model.getCreateDate());
        paraMap.put("CREATEUSER", model.getCreateUser());
        paraMap.put("FILENAME", model.getFileName());
        paraMap.put("FILESIZE", model.getFileSize());
        paraMap.put("REMARK", model.getRemark());
        paraMap.put("EXT1", model.getExt1());
        paraMap.put("SECURITYLEVEL", model.getSecurityLevel());
        paraMap.put("CLOUDINFO", model.getCloudInfo());
        String sql = DBSql.getInsertStatement(this.entityName(), paraMap);
        return DBSql.update(sql, paraMap);
    }

    @Override
    public int update(FormFile model) throws AWSDataAccessException {
        throw new AWSDataAccessException("Not Support Update!");
    }

    public int update(String id, String comment) throws AWSDataAccessException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("REMARK", comment);
        return super.update(id, fields);
    }

    public int updateSecurityLevel(String id, int securityLevel) throws AWSDataAccessException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("SECURITYLEVEL", securityLevel);
        return super.update(id, fields);
    }

    public int update(String id, String key, String value) throws AWSDataAccessException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(key, value);
        return super.update(id, fields);
    }

    private List<FormFile> filter(List<FormFile> list) {
        ArrayList<FormFile> newList = new ArrayList<FormFile>();
        ArrayList<String> duplicateName = new ArrayList<String>();
        for (FormFile formFile : list) {
            String name = formFile.getFileName();
            if (duplicateName.contains(name)) continue;
            duplicateName.add(name);
            newList.add(formFile);
        }
        return newList;
    }

    private List<FormFile> getFilterList(String whereClause, boolean filterFlag, Object ... params) {
        String sql = "SELECT * FROM WFC_FORMFILES WHERE " + whereClause + " ORDER BY FILENAME ASC,CREATEDATE DESC";
        List<FormFile> list = DBSql.query(sql, new Mapper(), params);
        if (filterFlag) {
            return this.filter(list);
        }
        return list;
    }

    private List<FormFile> getOrderList(List<FormFile> filterList, String orderBy, boolean isAsc) {
        if (orderBy.equals("FILENAME")) {
            SortUtil.sortByFileName(filterList, isAsc);
        } else if (orderBy.equals("CREATEDATE")) {
            SortUtil.sortByFileName(filterList, isAsc);
        }
        return filterList;
    }

    public List<FormFile> queryByBoFieldName(String boId, String boFieldName, String orderByFieldName, boolean isAsc) {
        List<FormFile> list = this.getFilterList("BOID=? AND BOFIELDNAME=?", true, boId, boFieldName);
        if (orderByFieldName.equals("FILENAME")) {
            SortUtil.sortByFileName(list, isAsc);
        } else if (orderByFieldName.equals("CREATEDATE")) {
            SortUtil.sortByCreateDate(list, isAsc);
        }
        return list;
    }

    public List<FormFile> queryByBoFieldName(String boId, String boFieldName) {
        return this.getOrderList(this.getFilterList("BOID=? AND BOFIELDNAME=?", true, boId, boFieldName), "FILENAME", true);
    }

    public FormFile queryByBoFieldNameLast(String boId, String boFieldName, String fileName) {
        List<FormFile> list = this.getFilterList("BOID=? AND BOFIELDNAME=? AND FILENAME=?", true, boId, boFieldName, fileName);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<FormFile> queryByProcessInst(String processInstId) {
        return this.getOrderList(this.getFilterList("PROCESSINSTID=?", true, processInstId), "CREATEDATE", true);
    }

    public List<FormFile> queryCommentFiles(String taskInstId, String commentId) {
        return this.getOrderList(this.getFilterList("TASKINSTID=? and BOID=?", true, taskInstId, commentId), "FILENAME", true);
    }

    @Override
    public String entityName() {
        return "WFC_FORMFILES";
    }

    @Override
    public RowMapper<FormFile> rowMapper() {
        return new Mapper();
    }

    private class Mapper
    implements RowMapper<FormFile> {
        private Mapper() {
        }

        public FormFile mapRow(ResultSet rset, int rowNum) throws SQLException {
            FormFileModel model = new FormFileModel();
            model.setId(rset.getString("ID"));
            model.setAppId(rset.getString("APPID"));
            model.setProcessInstId(rset.getString("PROCESSINSTID"));
            model.setTaskInstId(rset.getString("TASKINSTID"));
            model.setBoId(rset.getString("BOID"));
            model.setBoName(rset.getString("BONAME"));
            model.setBoItemName(rset.getString("BOFIELDNAME"));
            model.setCreateDate(rset.getTimestamp("CREATEDATE"));
            model.setCreateUser(rset.getString("CREATEUSER"));
            model.setFileName(rset.getString("FILENAME"));
            model.setFileSize(rset.getLong("FILESIZE"));
            model.setRemark(rset.getString("REMARK"));
            model.setExt1(rset.getString("EXT1"));
            model.setSecurityLevel(rset.getInt("SECURITYLEVEL"));
            model.setCloudInfo(rset.getString("CLOUDINFO"));
            return model;
        }
    }

    private static class SortUtil {
        private SortUtil() {
        }

        public static void sortByFileName(List<FormFile> list, final boolean isAsc) {
            Collections.sort(list, new Comparator<FormFile>(){

                @Override
                public int compare(FormFile o1, FormFile o2) {
                    Collator myCollator = Collator.getInstance(Locale.CHINA);
                    if (isAsc) {
                        return myCollator.compare(o1.getFileName(), o2.getFileName());
                    }
                    return myCollator.compare(o2.getFileName(), o1.getFileName());
                }
            });
        }

        public static void sortByCreateDate(List<FormFile> list, final boolean isAsc) {
            Collections.sort(list, new Comparator<FormFile>(){

                @Override
                public int compare(FormFile o1, FormFile o2) {
                    if (isAsc) {
                        return o1.getCreateDate().compareTo(o2.getCreateDate());
                    }
                    return o2.getCreateDate().compareTo(o1.getCreateDate());
                }
            });
        }
    }
}

