/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.fullsearch;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.FullSearchPluginProfile;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FullSearchManager {
    private static Map<String, FullSearchPluginProfile> _map = new ConcurrentHashMap<String, FullSearchPluginProfile>();

    public static List<FullSearchPluginProfile> getList() {
        ArrayList<FullSearchPluginProfile> list = new ArrayList<FullSearchPluginProfile>();
        for (FullSearchPluginProfile profile : _map.values()) {
            list.add(profile);
        }
        return list;
    }

    public static FullSearchPluginProfile getProfile(String appId, String repositoryName) {
        String key = String.valueOf(AWSServerConf.getProperty("dc.path")) + appId + "/_fullsearch/" + repositoryName;
        return _map.get(key);
    }

    public static boolean registerPlugin(AppContext app, FullSearchPluginProfile plugin) {
        plugin.setAppContext(app);
        FullSearchPluginProfile obj = _map.get(plugin.getDBPath());
        if (obj != null) {
            AppsLogger.err((AppContext)app, (String)("\u6ce8\u518cFS\u5168\u6587\u68c0\u7d22\u63a5\u53e3[" + plugin.getDBPath() + "]\u51b2\u7a81\uff0c\u539f\u56e0\u662f\u8be5\u5e93\u4f4d\u7f6e\u5df2\u88ab\u5360\u7528"));
            return false;
        }
        String dbPath = plugin.getDBPath();
        File dbPathDir = new File(dbPath);
        if (!dbPathDir.exists()) {
            dbPathDir.mkdirs();
        }
        _map.put(plugin.getDBPath(), plugin);
        return true;
    }

    public static boolean destoryPlugin(AppContext app, FullSearchPluginProfile plugin) {
        plugin.setAppContext(app);
        _map.remove(plugin.getDBPath());
        return true;
    }
}

