/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.functionaccess;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.functionaccess.RecordModelObject;
import com.actionsoft.bpms.commons.functionaccess.constant.FunctionRecordConstant;
import com.actionsoft.bpms.commons.functionaccess.dao.RecordDao;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FunctionHistoryWeb
extends ActionWeb {
    public FunctionHistoryWeb(UserContext userContext) {
        super(userContext);
    }

    public String getFuncionHistoryHome(String category, String filter, int pageNow, int pageSize) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        ResponseObject ro = this.buildContentHtml(category, filter, pageNow, pageSize);
        macroLibraries.put("historyDiv", "");
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("pageNow", pageNow);
        macroLibraries.put("totalSize", ro.get("totalSize"));
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.bm.function.history.htm", macroLibraries);
    }

    private List<RecordModelObject> getFR(String category, String filter, int pageNow, int pageSize, ResponseObject ro) {
        List<Object> list = new ArrayList();
        ArrayList<RecordModelObject> pageList = new ArrayList<RecordModelObject>();
        RecordDao recordDao = new RecordDao();
        int start = (pageNow - 1) * pageSize;
        int i = 0;
        int add = 0;
        list = recordDao.findFunctionRecords(category, filter);
        ArrayList<RecordModelObject> tmpList = new ArrayList<RecordModelObject>();
        String uid = this.getContext().getUID();
        HashSet apps = new HashSet();
        AMCAPIManager.getDevApps(uid).forEach(app -> {
            boolean bl = apps.add(app.getId());
        });
        AMCAPIManager.getManagerApps(uid).forEach(app -> {
            boolean bl = apps.add(app.getId());
        });
        for (RecordModelObject recordModelObject : list) {
            String appId = recordModelObject.getTmp1();
            AppContext appContext = AppsAPIManager.getInstance().getAppContext(appId);
            if (appContext == null) continue;
            boolean isRight = false;
            if (GradeSecurityUtil.isSuperMaster(uid)) {
                isRight = true;
            } else if (apps.contains(appId)) {
                isRight = true;
            }
            if (recordModelObject.isBad() || !isRight) continue;
            tmpList.add(recordModelObject);
        }
        for (RecordModelObject recordModelObject : tmpList) {
            if (++i > start && add < pageSize) {
                pageList.add(recordModelObject);
                ++add;
            }
            if (add >= pageSize) break;
        }
        ro.put("totalSize", tmpList.size());
        return pageList;
    }

    private ResponseObject buildContentHtml(String category, String filter, int pageNow, int pageSize) {
        ResponseObject ro = ResponseObject.newOkResponse();
        StringBuilder sb = new StringBuilder();
        List<RecordModelObject> list = this.getFR(category, filter, pageNow, pageSize, ro);
        int i = 0;
        while (i < list.size()) {
            RecordModelObject model = list.get(i);
            sb.append(this.getModelHtml(model));
            ++i;
        }
        ro.put("html", sb.toString());
        return ro;
    }

    private String getModelHtml(RecordModelObject model) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> appInfo = model.getAppInfo(this.getContext());
        String category = appInfo.get("category");
        sb.append("<div class=\"item").append("\">");
        int type = "createCD".equals(model.getTmp2()) ? model.getType() + 1 : model.getType();
        sb.append("<div class='background").append(" ").append(FunctionRecordConstant.CSS_CLASS_NAME.get(type)).append("' ").append(model.getOnClick()).append(">");
        sb.append("<div class='img'><i class=\"awsui-iconfont\" style=\"color:#ffffff;font-size: 55px;\">" + model.getImgSrc() + "</i></div>");
        sb.append("<div class='name' title='");
        if (!UtilString.isEmpty(category)) {
            sb.append(String.valueOf(I18nRes.findValue("_bpm.platform", "\u5206\u7c7b")) + "\uff1a").append(category).append("<br/>");
        }
        sb.append(UtilDate.getAliasDatetime(model.getOpTime())).append("'><a>").append(String.valueOf(model.getFunctionSName()) + "</a></div>");
        if (appInfo.containsKey("appInfo")) {
            sb.append("<div class='app'>").append(appInfo.get("appInfo")).append("</div>");
        }
        sb.append("</div>");
        sb.append("</div>");
        return sb.toString();
    }

    public String getHistoryPanelDIVHtml(String category, String filter, int pageNow, int pageSize) {
        ResponseObject ro = this.buildContentHtml(category, filter, pageNow, pageSize);
        int totalSize = Integer.parseInt(ro.get("totalSize").toString());
        if (totalSize / pageSize < pageNow) {
            ro.put("nextPage", false);
        } else {
            ro.put("nextPage", true);
        }
        return ro.toString();
    }
}

