/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.functionaccess.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.functionaccess.ConsoleFunctionRecordModel;
import com.actionsoft.bpms.commons.functionaccess.RecordModelObject;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RecordDao
extends DaoObject<RecordModelObject> {
    @Override
    public int insert(RecordModelObject model) {
        RecordModelObject fr = model;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ID", fr.getId());
        params.put("CATEGORYTYPE", fr.getSystem());
        params.put("ACCESSUSER", fr.getUID());
        params.put("RESOURCEID", fr.getRresourceId());
        params.put("ACCESSTIME", new Timestamp(new Date().getTime()));
        params.put("RESOURCETYPE", fr.getType());
        params.put("EXT1", fr.getTmp1());
        params.put("EXT2", fr.getTmp2());
        return DBSql.update(DBSql.getInsertStatement("SYS_FUNCTION_ACCESS", params), params);
    }

    @Override
    public int update(RecordModelObject daoObj) {
        return 0;
    }

    public List<RecordModelObject> findFunctionRecords(String category, String filter) {
        List<RecordModelObject> list = new ArrayList<RecordModelObject>();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select * from ").append("SYS_FUNCTION_ACCESS").append(" where ");
            sql.append("CATEGORYTYPE=:CATEGORYTYPE");
            sql.append(" and ACCESSUSER=:").append("ACCESSUSER");
            if (!UtilString.isEmpty(filter)) {
                sql.append(" and ");
                if ("BM".equals(filter.toUpperCase())) {
                    sql.append("RESOURCETYPE").append(">=1 AND ").append("RESOURCETYPE").append("<=20");
                } else if ("ORG".equals(filter.toUpperCase())) {
                    sql.append("RESOURCETYPE").append(">=21 AND ").append("RESOURCETYPE").append("<=40");
                } else if ("SEC".equals(filter.toUpperCase())) {
                    sql.append("RESOURCETYPE").append(">=41 AND ").append("RESOURCETYPE").append("<=60");
                } else if ("SERVICES".equals(filter.toUpperCase())) {
                    sql.append("RESOURCETYPE").append(">=61 AND ").append("RESOURCETYPE").append("<=80");
                }
            }
            sql.append(" order by ACCESSTIME desc");
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("CATEGORYTYPE", Integer.parseInt(category));
            paramsMap.put("ACCESSUSER", DispatcherRequest.getUserContext().getUID());
            list = DBSql.query(sql.toString(), paramsMap, this.rowMapper());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<RecordModelObject> findAllRecords(String category) {
        return this.findFunctionRecords(category, null);
    }

    public int getRecordCount(String system) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        String sql = "select count(*) as c from SYS_FUNCTION_ACCESS where CATEGORYTYPE=:CATEGORYTYPE and ACCESSUSER=:ACCESSUSER";
        paramsMap.put("CATEGORYTYPE", system);
        paramsMap.put("ACCESSUSER", DispatcherRequest.getUserContext().getUID());
        int c = DBSql.getInt(sql, "c", paramsMap);
        return c;
    }

    public void deleteRecords(RecordModelObject fr) {
        String dsql = "delete from SYS_FUNCTION_ACCESS where CATEGORYTYPE=:CATEGORYTYPE and ACCESSUSER=:ACCESSUSER and ACCESSTIME < :ACCESSTIME";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("CATEGORYTYPE", fr.getSystem());
        paramsMap.put("ACCESSUSER", fr.getUID());
        paramsMap.put("ACCESSTIME", fr.getOpTime());
        DBSql.update(dsql, paramsMap);
    }

    public void deleteRepeatRecord(RecordModelObject fr) {
        StringBuilder r = new StringBuilder();
        r.append("delete from SYS_FUNCTION_ACCESS");
        r.append(" where CATEGORYTYPE=:CATEGORYTYPE");
        r.append(" and ACCESSUSER=:ACCESSUSER");
        r.append(" and RESOURCEID=:RESOURCEID");
        HashMap<String, Object> rparamsMap = new HashMap<String, Object>();
        rparamsMap.put("CATEGORYTYPE", fr.getSystem());
        rparamsMap.put("ACCESSUSER", fr.getUID());
        rparamsMap.put("RESOURCEID", fr.getRresourceId());
        DBSql.update(r.toString(), rparamsMap);
    }

    @Override
    public String entityName() {
        return "SYS_FUNCTION_ACCESS";
    }

    @Override
    public RowMapper<RecordModelObject> rowMapper() {
        return new RecordModelObjectMapper();
    }

    public class RecordModelObjectMapper
    implements RowMapper<RecordModelObject> {
        public RecordModelObject mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConsoleFunctionRecordModel model = new ConsoleFunctionRecordModel();
            try {
                model.setId(rs.getString("ID"));
                model.setRresourceId(rs.getString("RESOURCEID"));
                model.setTmp1(rs.getString("EXT1"));
                model.setTmp2(rs.getString("EXT2"));
                model.setType(rs.getInt("RESOURCETYPE"));
                model.setOpTime(rs.getTimestamp("ACCESSTIME"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            model.setUID(DispatcherRequest.getUserContext().getUID());
            return model;
        }
    }
}

