/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.htmlframework;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.htmlframework.ReplaceKey;
import com.actionsoft.bpms.commons.session.dao.Session;
import com.actionsoft.bpms.commons.session.model.SessionModel;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.framework.io.Exchange;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class AlertWindow {
    public static final String ICON_CLOUD = "../commons/js/jquery/themes/default/ui/images/messagePage/service.png";
    public static final String ICON_COFFEE = "../commons/js/jquery/themes/default/ui/images/messagePage/wait.png";
    public static final String ICON_RUN = "../commons/js/jquery/themes/default/ui/images/messagePage/exec.png";
    public static final String ICON_WARNING = "../commons/js/jquery/themes/default/ui/images/messagePage/warning.png";
    public static final String ICON_ERROR = "../commons/js/jquery/themes/default/ui/images/messagePage/error.png";
    public static final String ICON_INFO = "../commons/js/jquery/themes/default/ui/images/messagePage/info.png";
    public static final String ICON_NOT_ACCESS = "../commons/js/jquery/themes/default/ui/images/messagePage/authority.png";
    public static final String ICON_BPMNError = "../commons/js/jquery/themes/default/ui/images/messagePage/info.png";
    public static final String MESSAGE_TYPE_NOT_FOUND = "not_found";
    public static final String MESSAGE_TYPE_INFO = "info";
    public static final String MESSAGE_TYPE_OK = "ok";
    public static final String MESSAGE_TYPE_ERROR = "error";
    public static final String MESSAGE_TYPE_WARNING = "warning";
    public static final String MESSAGE_TYPE_AUTHORITY = "authority";
    public static final String MESSAGE_TYPE_WAIT = "wait";
    public static final String MESSAGE_TYPE_SERVICE = "service";
    public static final String MESSAGE_TYPE_NO_CONTENT = "no_content";
    public static final String MESSAGE_TYPE_NO_SEARCH = "no_search";
    public static final String MESSAGE_TYPE_EXEC = "exec";

    public static String getOkMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_OK);
    }

    public static String getErrorMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_ERROR);
    }

    public static String getWarningMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_WARNING);
    }

    public static String getInfoMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_INFO);
    }

    public static String getAuthorityMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_AUTHORITY);
    }

    public static String getWaitMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_WAIT);
    }

    public static String getNotFoundMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_NOT_FOUND);
    }

    public static String getServiceMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_SERVICE);
    }

    public static String getNoContentMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_NO_CONTENT);
    }

    public static String getNoSearchMessagePage(String title, String desc) {
        return AlertWindow.getMessagePage(title, desc, MESSAGE_TYPE_NO_SEARCH);
    }

    public static String getMessagePage(String title, String desc, String messageType) {
        return AlertWindow.getMessagePage(title, desc, messageType, null);
    }

    public static String getMessagePage(String title, String desc, String messageType, String jsAction) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        UserContext user = DispatcherRequest.getUserContext();
        boolean isMobile = false;
        boolean isRelogin = false;
        if (user != null) {
            isMobile = user.isMobileClient();
        }
        String lang = SDK.getPlatformAPI().getDefaultLanguage();
        try {
            lang = I18nRes.getUserLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String appId = "";
        if (DispatcherRequest.getContext() != null && DispatcherRequest.getContext().getExchange() != null) {
            Exchange exchange = DispatcherRequest.getContext().getExchange();
            Map<String, String> parameters = exchange.getParameters();
            if (parameters != null && parameters.containsKey("appId")) {
                appId = parameters.get("appId");
            }
            if (UtilString.isEmpty(appId) && DispatcherRequest.getContext().getAppContext() != null) {
                appId = DispatcherRequest.getContext().getAppContext().getId();
            }
            if (UtilString.isEmpty(appId)) {
                appId = "_bpm.portal";
            }
        }
        StringBuilder msg = new StringBuilder();
        String msgTypeHtml = "";
        msgTypeHtml = UtilString.isNotEmpty(messageType) && messageType.indexOf("/") > -1 ? "<span class=\"icon\"><img src=\"" + messageType + "\"></span>\n" : "<span class=\"icon\" message-type=\"" + messageType + "\"></span>\n";
        macroLibraries.put("messageType", msgTypeHtml);
        if (!UtilString.isEmpty(messageType)) {
            title = title.indexOf("<I18N#") > -1 ? ReplaceKey.replaceI18NTag((String)appId, (String)lang, (String)title) : I18nRes.findValue(appId, title);
            macroLibraries.put("showTitle", "");
        } else {
            macroLibraries.put("showTitle", "none");
        }
        macroLibraries.put("title", title);
        if (!UtilString.isEmpty(desc)) {
            if ((desc = desc.indexOf("<I18N#") > -1 ? ReplaceKey.replaceI18NTag((String)appId, (String)lang, (String)desc) : I18nRes.findValue(appId, desc)).endsWith("\u8bf7\u91cd\u65b0\u767b\u5f55")) {
                String sid;
                if (user == null && DispatcherRequest.getContext() != null && !UtilString.isEmpty(sid = DispatcherRequest.getContext().getSid())) {
                    SessionModel session = (SessionModel)new Session().queryById((Object)sid);
                    if (session != null) {
                        user = UserContext.fromSessionId((SessionModel)session, (String)DispatcherRequest.getContext().getExchange().getClientIp());
                        DispatcherRequest.getContext().setUserContext(user);
                    }
                    if (user != null) {
                        isMobile = user.isMobileClient();
                    }
                }
                if (!isMobile) {
                    Map extParams;
                    desc = desc.replaceAll("\u91cd\u65b0\u767b\u5f55", "<a onclick='delayURL(0);return false;' style='color: #069AF3;cursor: pointer;'>\u91cd\u65b0\u767b\u5f55</a>\uff0c<span id='time'>3</span>\u79d2\u540e\u81ea\u52a8\u8df3\u8f6c");
                    Map map = extParams = user != null ? user.getExtParams() : new HashMap();
                    if (!extParams.containsKey("loginUrl")) {
                        if (user != null) {
                            if ("A".equals(user.getSessionScope())) {
                                extParams.put("loginUrl", "../console");
                            } else if ("C".equals(user.getSessionScope())) {
                                extParams.put("loginUrl", "../coe/pal");
                            } else if ("P".equals(user.getSessionScope())) {
                                extParams.put("loginUrl", "../");
                            } else {
                                String s = SDK.getAppAPI().getProperty("_bpm.portal", "sessionScopeURL");
                                if (!UtilString.isEmpty(s)) {
                                    try {
                                        String url = JSON.parseObject((String)s).getString(user.getSessionScope());
                                        extParams.put("loginUrl", url);
                                    }
                                    catch (Exception e) {
                                        System.err.println(e);
                                    }
                                }
                            }
                        } else {
                            extParams.put("loginUrl", "");
                        }
                    } else {
                        String loginUrl = (String)extParams.get("loginUrl");
                        try {
                            loginUrl = URLDecoder.decode(loginUrl, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        extParams.put("loginUrl", loginUrl);
                    }
                    macroLibraries.putAll(extParams);
                    isRelogin = true;
                }
            }
            msg.append("        <span class=\"description\">").append(desc).append("</span>\n");
            macroLibraries.put("showDesc", "");
        } else {
            macroLibraries.put("showDesc", "none");
        }
        macroLibraries.put("desc", desc);
        String tpl = SDK.getAppAPI().getProperty("_bpm.platform", "alertWindowTpl");
        if (UtilString.isEmpty(tpl) || tpl.equals("console.user.sys.alert.page.htm")) {
            tpl = "console.user.alert.page.htm";
        }
        macroLibraries.put("title", title);
        macroLibraries.put("msg", msg.toString());
        macroLibraries.put("isRelogin", isRelogin);
        macroLibraries.put("AWSURL", AWSPortalConf.getUrl());
        macroLibraries.put("jsAction", !UtilString.isEmpty(jsAction) ? jsAction : "");
        return HtmlPageTemplate.merge("_bpm.platform", tpl, macroLibraries);
    }

    public static String getPage(String title) {
        return AlertWindow.getPage(title, "");
    }

    public static String getPage(String title, String msg) {
        return AlertWindow.getPage(title, msg, null);
    }

    public static String getPage(String title, String msg, String icon) {
        return AlertWindow.getPage(title, msg, icon, "");
    }

    public static String getPage(String title, String msg, String icon, String jsAction) {
        return AlertWindow.getMessagePage(title, msg, icon, jsAction);
    }
}

