/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.htmlframework;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.scanner.AbstScanner;
import com.actionsoft.apps.resource.scanner.IScanner;
import com.actionsoft.bpms.commons.htmlframework.HtmlFormTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class HtmlFormScanner
extends AbstScanner
implements IScanner {
    public HtmlFormScanner() {
        this.setName("AWS HtmlForm Template Scanner");
        this.setInterval(5000L);
    }

    public void scan() {
        for (AppContext app : AppsAPIManager.getInstance().getInstalledApps()) {
            if (!app.getRuntimeState().equals("ACTIVE") || !app.isReloadable()) continue;
            String scanPath = String.valueOf(app.getPath()) + "template/form";
            Map<String, Long> fileInfo = HtmlFormTemplate.getFileInfo();
            File dir = new File(scanPath);
            File[] files = dir.listFiles();
            if (files == null) continue;
            ArrayList<String> deletedFiles = new ArrayList<String>();
            for (String filePath : fileInfo.keySet()) {
                if (filePath.indexOf("/" + app.getId() + "/") <= 0 && filePath.indexOf("\\" + app.getId() + "\\") <= 0) continue;
                deletedFiles.add(filePath);
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName;
                File file = fileArray[n2];
                if (!file.isDirectory() && ((fileName = file.getName()).toLowerCase().endsWith(".htm") || fileName.toLowerCase().endsWith(".html"))) {
                    if (fileInfo.containsKey(file.getPath())) {
                        Long lastModify = fileInfo.get(file.getPath());
                        if (lastModify.longValue() != file.lastModified()) {
                            HtmlFormTemplate.updateFileCache(app, file);
                        }
                    } else {
                        HtmlFormTemplate.updateFileCache(app, file);
                    }
                    deletedFiles.remove(file.getPath());
                }
                ++n2;
            }
            for (String filePath : deletedFiles) {
                HtmlFormTemplate.removeFileCache(app, filePath);
            }
        }
    }
}

