/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.htmlframework;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.htmlframework.AlertWindow;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.htmlframework.ReplaceKey;
import com.actionsoft.bpms.commons.htmlframework.TemplateTransfer2UTF8;
import com.actionsoft.bpms.commons.mvc.dao.XDaoObject;
import com.actionsoft.bpms.form.design.cache.FormCache;
import com.actionsoft.bpms.form.design.model.FormModel;
import com.actionsoft.bpms.form.engine.FormEngineContext;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nUtil;
import com.actionsoft.sdk.local.SDK;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HtmlFormTemplate {
    private static Map<String, Map<String, String>> _list = new ConcurrentHashMap<String, Map<String, String>>();
    private static Map<String, Long> _fileInfo = new ConcurrentHashMap<String, Long>();

    public static void reloadAll() {
        for (AppContext context : AppsAPIManager.getInstance().getInstalledApps()) {
            HtmlFormTemplate.loadInstancesByApp(context.getId());
        }
    }

    public static void loadInstancesByApp(String appId) {
        Map<String, String> htmlMap = HtmlFormTemplate.getInstancesByApp(appId);
        if (htmlMap.size() > 0) {
            ConsolePrinter.info("[" + AppsAPIManager.getInstance().getAppContext(appId).getName() + "]\u52a0\u8f7d\u8868\u5355HTML\u6a21\u7248[" + htmlMap.size() + "\u4e2a][\u6210\u529f]");
        }
    }

    public static Map<String, Long> getFileInfo() {
        return _fileInfo;
    }

    public static Map<String, String> getListByApp(String appId) {
        Map<String, String> map = _list.get(appId);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public static Map<String, String> getInstancesByApp(String appId) {
        String realPath = XDaoObject.getResourceRealPath(appId, "template/form");
        HashMap<String, String> templateMap = new HashMap<String, String>();
        if (realPath == null) {
            System.err.println("\u975e\u6cd5\u7684null\u8def\u5f84\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
            return templateMap;
        }
        File dir = new File(realPath);
        File[] files = dir.listFiles();
        if (files == null) {
            _list.put(appId, templateMap);
            return templateMap;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            File file = fileArray[n2];
            if (!file.isDirectory() && ((fileName = file.getName()).toLowerCase().endsWith(".htm") || fileName.toLowerCase().endsWith(".html"))) {
                String content;
                boolean isUTF8ile = new UtilFile(file.getPath()).isUTF8File();
                if (!isUTF8ile) {
                    TemplateTransfer2UTF8.execute(file.getPath());
                }
                if ((content = new UtilFile(file.getPath()).readStr("UTF-8")) != null) {
                    content = HtmlFormTemplate.initContent(content, appId);
                    content = HtmlPageTemplate.ieFlagInjection(content);
                    content = HtmlPageTemplate.scriptVersionInjection(content);
                    templateMap.put(fileName, content);
                    _fileInfo.put(file.getPath(), file.lastModified());
                }
            }
            ++n2;
        }
        _list.remove(appId);
        _list.put(appId, templateMap);
        return templateMap;
    }

    public static void updateFileCache(AppContext app, File file) {
        String content;
        String fileName = file.getName();
        boolean isUTF8ile = new UtilFile(file.getPath()).isUTF8File();
        if (!isUTF8ile) {
            TemplateTransfer2UTF8.execute(file.getPath());
        }
        if ((content = new UtilFile(file.getPath()).readStr("UTF-8")) == null) {
            return;
        }
        content = HtmlFormTemplate.initContent(content, app.getId());
        content = HtmlPageTemplate.scriptVersionInjection(content);
        Map<String, String> appFiles = _list.get(app.getId());
        String oldContent = HtmlFormTemplate.getTemplateContent(app.getId(), fileName);
        if (!oldContent.equals(content)) {
            if (appFiles != null) {
                if (appFiles.containsKey(fileName)) {
                    ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u66f4\u65b0]");
                } else {
                    ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u53d1\u73b0]");
                }
                appFiles.put(fileName, content);
                _fileInfo.put(file.getPath(), file.lastModified());
            } else {
                _fileInfo.remove(file.getPath());
            }
        }
    }

    public static void removeFileCache(AppContext app, String filePath) {
        Map<String, String> appFiles = _list.get(app.getId());
        if (appFiles != null) {
            String fileName = "";
            fileName = filePath.lastIndexOf("/") > -1 ? filePath.substring(filePath.lastIndexOf("/") + 1) : filePath.substring(filePath.lastIndexOf("\\") + 1);
            appFiles.remove(fileName);
            ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u5220\u9664]");
        }
        _fileInfo.remove(filePath);
    }

    public static void destoryInstancesByApp(String appId) {
        File[] files;
        String realPath = XDaoObject.getResourceRealPath(appId, "template/form");
        File dir = new File(realPath);
        if (dir != null && (files = dir.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    _fileInfo.remove(file.getPath());
                }
                ++n2;
            }
        }
        _list.remove(appId);
    }

    public static String merge(String appId, String templateFileName, Map<String, Object> macroLibraries, FormEngineContext ctx) {
        String tpl = HtmlFormTemplate.getTemplateContent(appId, templateFileName);
        tpl = tpl.replaceAll("<body.*>", "$0\n[#AWSToolbar]");
        if (ctx != null) {
            tpl = tpl.replaceAll("\\[#AWSUIImport\\]", "");
            tpl = tpl.replaceAll("<body.*>", "$0\n[#AWSImportJS]\n[#AWSUIImport]");
            tpl = SDK.getRuleAPI().executeAtScript(tpl, ctx);
        }
        String formHtml = ReplaceKey.replace((String)appId, (String)tpl, macroLibraries, (String)"[#", (String)"]", (ctx != null ? 1 : 0) != 0);
        long warnSize = 0x100000L;
        if ((long)formHtml.length() > warnSize) {
            AppsLogger.warn((AppContext)SDK.getAppAPI().getAppContext(appId), (String)("\u8868\u5355[" + templateFileName + "]\u6784\u9020\u7684Html\u8d85\u8fc71M\uff08" + formHtml.length() + "\u5b57\u8282\uff09\uff0c\u53ef\u80fd\u5f71\u54cd\u7f51\u7edc\u7528\u6237\u4f53\u9a8c\uff0c\u5efa\u8bae\u8c03\u6574\u8bbe\u8ba1"));
        }
        return formHtml;
    }

    public static String getTemplateContent(String appId, String templateFileName) {
        String o = _list.get(appId).get(templateFileName);
        if (o == null) {
            return AlertWindow.getNotFoundMessagePage("Not find this html file", String.valueOf(appId) + "[" + templateFileName + "]");
        }
        String content = o;
        if (!templateFileName.toLowerCase().startsWith("console.i18n")) {
            content = I18nUtil.setHtmlJavaScriptFlag(content);
            content = I18nUtil.replaceHtmlJavaScriptI18NCommonFlag(content);
        }
        return content;
    }

    public static List<String> getTemplateFileNames(String appId) {
        Map<String, String> fileList = _list.get(appId);
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (fileList != null) {
            for (String fileName : fileList.keySet()) {
                fileNameList.add(fileName);
            }
        }
        return fileNameList;
    }

    public static List<String> getTemplateFileNames() {
        ArrayList<String> fileNameList = new ArrayList<String>();
        List apps = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appContext : apps) {
            Map<String, String> fileList;
            if (!appContext.getRuntimeState().equals("ACTIVE") || (fileList = _list.get(appContext.getId())) == null) continue;
            for (String fileName : fileList.keySet()) {
                String title = fileName.substring(0, fileName.indexOf(".htm"));
                FormModel model = FormCache.getInstance().getModelByTitle(appContext.getId(), title);
                String targetAppId = "_bpm.platform";
                if (model != null) {
                    targetAppId = model.getAppId();
                }
                fileNameList.add(String.valueOf(fileName) + "|" + targetAppId);
            }
        }
        return fileNameList;
    }

    private static String initContent(String content, String appId) {
        if (content.indexOf("<title>[#TITLE]</title>") > -1) {
            content = new UtilString(content).replace("<title>[#TITLE]</title>", "<title>[#%AWS_FORM_TITLE%]</title>");
        }
        return content;
    }
}

