/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.htmlframework;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.htmlframework.ReplaceKey;
import com.actionsoft.bpms.commons.htmlframework.TemplateTransfer2UTF8;
import com.actionsoft.bpms.commons.mvc.dao.XDaoObject;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.ThreadStackTraceInfo;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSObjectNotFindException;
import com.actionsoft.i18n.I18nUtil;
import com.actionsoft.sdk.local.SDK;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlPageTemplate {
    private static Map<String, Map<String, String>> _list;
    private static Map<String, Long> _fileInfo;
    private static boolean isTrack;
    private static StringBuilder trackCode;

    static {
        String t;
        _list = new ConcurrentHashMap<String, Map<String, String>>();
        _fileInfo = new ConcurrentHashMap<String, Long>();
        isTrack = false;
        trackCode = new StringBuilder();
        if (isTrack) {
            trackCode.append("<!-- default analytics -->").append("\n");
            trackCode.append("<script>").append("\n");
            trackCode.append("window.ga=window.ga||function(){(ga.q=ga.q||[]).push(arguments)};ga.l=+new Date;");
            trackCode.append("ga('create', 'UA-68775961-1', 'auto');").append("\n");
            trackCode.append("ga('set', 'location', document.location.host);").append("\n");
            trackCode.append("ga('set', 'hostname', document.domain);").append("\n");
            trackCode.append("ga('set', 'page', document.location.host);").append("\n");
            trackCode.append("ga('ec:addProduct', {").append("\n");
            trackCode.append(" 'name': '").append(SDK.getPlatformAPI().getAWSServer().getAWSVersion()).append("'").append("\n");
            trackCode.append("});").append("\n");
            trackCode.append("ga('ec:setAction', 'purchase', {").append("\n");
            trackCode.append(" 'affiliation': '").append(new String(Base64.encode(Quota.getCompanyName().getBytes()))).append("'").append("\n");
            trackCode.append("});").append("\n");
            trackCode.append("ga('ec:addProduct', {").append("\n");
            trackCode.append(" 'variant': '").append(Quota.getEnvType()).append("'").append("\n");
            trackCode.append("});").append("\n");
            trackCode.append("ga('send', 'pageview');").append("\n");
            trackCode.append("</script>").append("\n");
            trackCode.append("<script async src='../commons/js/ga/analytics.js'></script>\n");
        }
        isTrack = UtilString.isEmpty(t = AWSPortalConf.getProperty("www.track")) || t.equalsIgnoreCase("true");
        String c = AWSPortalConf.getProperty("www.track.code");
        if (!UtilString.isEmpty(c)) {
            trackCode.append("\n\r<!-- user analytics -->\n").append(c);
        }
        isTrack = false;
        trackCode.setLength(0);
    }

    public static void reloadAll() {
        for (AppContext context : AppsAPIManager.getInstance().getInstalledApps()) {
            HtmlPageTemplate.loadInstancesByApp(context.getId());
        }
    }

    public static void loadInstancesByApp(String appId) {
        Map<String, String> htmlMap = HtmlPageTemplate.getInstancesByApp(appId);
        if (htmlMap.size() > 0) {
            ConsolePrinter.info("[" + AppsAPIManager.getInstance().getAppContext(appId).getName() + "]\u52a0\u8f7d\u7a0b\u5e8fHTML\u6a21\u7248[" + htmlMap.size() + "\u4e2a][\u6210\u529f]");
        }
    }

    public static Map<String, Long> getFileInfo() {
        return _fileInfo;
    }

    public static Map<String, String> getListByApp(String appId) {
        Map<String, String> map = _list.get(appId);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    protected static Map<String, String> getInstancesByApp(String appId) {
        String realPath = XDaoObject.getResourceRealPath(appId, "template/page");
        HashMap<String, String> templateMap = new HashMap<String, String>();
        if (realPath == null) {
            ConsolePrinter.err("\u975e\u6cd5\u7684null\u8def\u5f84\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
            return templateMap;
        }
        File dir = new File(realPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return templateMap;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            File file = fileArray[n2];
            if (!file.isDirectory() && ((fileName = file.getName()).toLowerCase().endsWith(".htm") || fileName.toLowerCase().endsWith(".html"))) {
                String content;
                boolean isUTF8ile = new UtilFile(file.getPath()).isUTF8File();
                if (!isUTF8ile) {
                    TemplateTransfer2UTF8.execute(file.getPath());
                }
                if ((content = new UtilFile(file.getPath()).readStr("UTF-8")) != null) {
                    if (AWSServerConf.isDebugTemplatePage()) {
                        content = HtmlPageTemplate.getSystemModelContent(appId, fileName, content);
                    }
                    content = HtmlPageTemplate.ieFlagInjection(content);
                    content = HtmlPageTemplate.scriptVersionInjection(content);
                    templateMap.put(fileName, content);
                    _fileInfo.put(file.getPath(), file.lastModified());
                }
            }
            ++n2;
        }
        _list.remove(appId);
        _list.put(appId, templateMap);
        return templateMap;
    }

    public static String ieFlagInjection(String content) {
        StringBuilder ie = new StringBuilder();
        ie.append("<meta name=\"renderer\" content=\"webkit\">\n");
        ie.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\" />\n");
        if (content.indexOf("<head>") > -1 && content.indexOf(ie.toString()) == -1) {
            StringBuilder ieFlag = new StringBuilder();
            ieFlag.append("<head>\n");
            ieFlag.append((CharSequence)ie);
            content = content.replaceAll("<head>", ieFlag.toString());
            return content;
        }
        return content;
    }

    public static String scriptVersionInjection(String content) {
        String path;
        ArrayList<String> urlSrc = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(<script[^>]*?\\.js)(?!\\?v=)");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            path = matcher.group(0);
            String js = path.substring(path.indexOf("../") + 3, path.length());
            urlSrc.add(js);
        }
        pattern = Pattern.compile("(<link[^>]*?\\.css)(?!\\?v=)");
        matcher = pattern.matcher(content);
        while (matcher.find()) {
            path = matcher.group(0);
            String css = path.substring(path.indexOf("../") + 3, path.length());
            urlSrc.add(css);
        }
        String UrlSrcRoot = AWSPortalConf.getLocation();
        for (String src : urlSrc) {
            File srcFile = new File(String.valueOf(UrlSrcRoot) + src);
            if (!srcFile.exists()) continue;
            String newSrc = String.valueOf(src) + "?v=" + srcFile.lastModified();
            content = content.replaceAll(src, newSrc);
        }
        return content;
    }

    public static void updateFileCache(AppContext app, File file) {
        String content;
        String fileName = file.getName();
        boolean isUTF8ile = new UtilFile(file.getPath()).isUTF8File();
        if (!isUTF8ile) {
            TemplateTransfer2UTF8.execute(file.getPath());
        }
        if ((content = new UtilFile(file.getPath()).readStr("UTF-8")) == null) {
            return;
        }
        if (AWSServerConf.isDebugTemplatePage()) {
            content = HtmlPageTemplate.getSystemModelContent(app.getId(), fileName, content);
        }
        content = HtmlPageTemplate.scriptVersionInjection(content);
        Map<String, String> appFiles = _list.get(app.getId());
        if (appFiles != null) {
            if (appFiles.containsKey(fileName)) {
                ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u66f4\u65b0]");
            } else {
                ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u53d1\u73b0]");
            }
            appFiles.put(fileName, content);
            _fileInfo.put(file.getPath(), file.lastModified());
        } else {
            _fileInfo.remove(file.getPath());
        }
    }

    public static void removeFileCache(AppContext app, String filePath) {
        Map<String, String> appFiles = _list.get(app.getId());
        if (appFiles != null) {
            String fileName = "";
            fileName = filePath.lastIndexOf("/") > -1 ? filePath.substring(filePath.lastIndexOf("/") + 1) : filePath.substring(filePath.lastIndexOf("\\") + 1);
            appFiles.remove(fileName);
            ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u5220\u9664]");
        }
        _fileInfo.remove(filePath);
    }

    public static void destoryInstancesByApp(String appId) {
        File[] files;
        String realPath = XDaoObject.getResourceRealPath(appId, "template/page");
        File dir = new File(realPath);
        if (dir != null && (files = dir.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    _fileInfo.remove(file.getPath());
                }
                ++n2;
            }
        }
        _list.remove(appId);
    }

    public static String merge(String appId, String templateFileName, Map<String, Object> macroLibraries) {
        UserContext userContext;
        if ("client.user.sys.logout.htm".equals(templateFileName) && !macroLibraries.containsKey("loginUrl") && (userContext = DispatcherRequest.getUserContext()) != null) {
            Map extParams;
            if (macroLibraries == null) {
                macroLibraries = new HashMap<String, Object>();
            }
            if (!(extParams = userContext.getExtParams()).containsKey("loginUrl")) {
                if ("A".equals(userContext.getSessionScope())) {
                    macroLibraries.put("loginUrl", "../console");
                } else if ("C".equals(userContext.getSessionScope())) {
                    macroLibraries.put("loginUrl", "../coe/pal");
                } else {
                    macroLibraries.put("loginUrl", "../");
                }
            } else {
                String loginUrl = (String)extParams.get("loginUrl");
                try {
                    loginUrl = URLDecoder.decode(loginUrl, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                macroLibraries.put("loginUrl", loginUrl);
            }
        }
        return ReplaceKey.replace((String)appId, (String)HtmlPageTemplate.getTemplateContent(appId, templateFileName), macroLibraries);
    }

    public static String merge(String templateFileName, Map<String, Object> macroLibraries) {
        return HtmlPageTemplate.merge(DispatcherRequest.getContext().getAppContext().getId(), templateFileName, macroLibraries);
    }

    public static String formStyleMerge(String appId, String templateFileName, Map<String, Object> macroLibraries) {
        return ReplaceKey.replace((String)appId, (String)HtmlPageTemplate.getTemplateContent(appId, templateFileName, false), macroLibraries, (String)"[#", (String)"]");
    }

    public static String getTemplateContent(String appId, String templateFileName) {
        boolean debug = false;
        String str = AWSServerConf.getProperty("template.debug");
        if (!UtilString.isEmpty(str)) {
            debug = Boolean.parseBoolean(str);
        }
        return HtmlPageTemplate.getTemplateContent(appId, templateFileName, debug, true);
    }

    public static String getTemplateContent(String appId, String templateFileName, boolean isAppendTrackCode) {
        boolean debug = false;
        String str = AWSServerConf.getProperty("template.debug");
        if (!UtilString.isEmpty(str)) {
            debug = Boolean.parseBoolean(str);
        }
        return HtmlPageTemplate.getTemplateContent(appId, templateFileName, debug, isAppendTrackCode);
    }

    public static String getTemplateContent(String appId, String templateFileName, boolean isDebug, boolean isAppendTrackCode) {
        String o = null;
        try {
            o = _list.get(appId).get(templateFileName);
        }
        catch (Exception e) {
            throw new AWSObjectNotFindException("install/" + appId + "/template/page/" + templateFileName);
        }
        if (o == null) {
            throw new AWSObjectNotFindException("install/" + appId + "/template/page/" + templateFileName);
        }
        String content = o;
        if (isDebug) {
            StringBuffer sb = new StringBuffer();
            sb.append("CallerClass:\\n");
            sb.append(ThreadStackTraceInfo.getCurrentThreadStackTraces());
        }
        if (isAppendTrackCode && isTrack && content.lastIndexOf("</body>") > -1 && !Quota.isTEST()) {
            StringBuilder c = new StringBuilder(content.substring(0, content.lastIndexOf("</body>")));
            c.append((CharSequence)trackCode);
            c.append(content.substring(content.lastIndexOf("</body>"), content.length()));
            content = c.toString();
        }
        if (!templateFileName.toLowerCase().startsWith("console.i18n")) {
            content = I18nUtil.setHtmlJavaScriptFlag(content);
            content = I18nUtil.replaceHtmlJavaScriptI18NCommonFlag(content);
        }
        return content;
    }

    private static String getSystemModelContent(String appId, String templateFileName, String content) {
        String editPannel = "\n\n<!--\u6b64\u5904\u4e3aAWS\u6a21\u677f\u5f15\u64ce\u52a8\u6001\u751f\u6210\u7684\u4ee3\u7801\uff0c\u4e0d\u88ab\u5b9a\u4e49\u5230\u6a21\u677f\u4e2d -->\n";
        editPannel = String.valueOf(editPannel) + "<div id=editAWSPagePannel style='position:absolute; z-index:1001;bottom:5px;right:5px;'>";
        editPannel = String.valueOf(editPannel) + "<input name=editAWSPageBtn type=submit style='background-color: #00FFFF;text-decoration: blink;border: 1px dashed #00FFFF;;font-size: 9px;FILTER: alpha(opacity=30);opacity:0.3;' onclick=\"alert('AppId:'+'" + appId + "'+'\\nFileName:'+'" + templateFileName + "');return false;\" value='+View Page Model'></div>\n\n";
        content = new UtilString(content).replace("</body>", String.valueOf(editPannel) + "\n</body>");
        return content;
    }
}

