/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.iox.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.iox.dao.IoXDao;
import com.actionsoft.bpms.commons.iox.model.IoXModel;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class IoXCache
extends Cache<String, IoXModel> {
    public IoXCache(CachePluginProfile profile) {
        super(profile);
    }

    public static List<IoXModel> getListOfType(String advanceType) {
        ArrayList<IoXModel> list = new ArrayList<IoXModel>();
        Iterator it = IoXCache.getCache().iterator();
        while (it.hasNext()) {
            IoXModel iox = (IoXModel)it.next();
            if (!iox.getAdvanceType().equals(advanceType)) continue;
            list.add(iox);
        }
        Collections.sort(list, new Comparator<IoXModel>(){

            @Override
            public int compare(IoXModel o1, IoXModel o2) {
                return o1.getOrderIndex() - o2.getOrderIndex();
            }
        });
        return list;
    }

    public static void putModel(IoXModel model) {
        IoXCache.getCache().put(model.getId(), model, true);
    }

    public static IoXModel getModel(String id) {
        return (IoXModel)IoXCache.getCache().get(id);
    }

    public static void removeById(String id) {
        IoXCache.getCache().remove(id);
    }

    @Override
    public void load() {
        List list = new IoXDao().query().list();
        for (IoXModel model : list) {
            this.put(model.getId(), model, false);
        }
        ConsolePrinter.info("Cache\u52a0\u8f7dIoX\u89c4\u5219 [" + list.size() + "\u4e2a][\u6210\u529f]");
    }

    public static IoXCache getCache() {
        return CacheManager.getCache(IoXCache.class);
    }
}

